/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.persistence.PersistenceUnit;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class EntityManagerFactoryReferenceHandler
extends AbstractResourceHandler {
    public Class<? extends Annotation> getAnnotationType() {
        return PersistenceUnit.class;
    }

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        PersistenceUnit emfRefAn = (PersistenceUnit)ainfo.getAnnotation();
        return this.processEmfRef(ainfo, rcContexts, emfRefAn);
    }

    protected HandlerProcessingResult processEmfRef(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts, PersistenceUnit emfRefAn) throws AnnotationProcessorException {
        block7: {
            EntityManagerFactoryReferenceDescriptor[] emfRefs;
            block8: {
                block6: {
                    emfRefs = null;
                    if (!ElementType.FIELD.equals((Object)ainfo.getElementType())) break block6;
                    Field f = (Field)ainfo.getAnnotatedElement();
                    String targetClassName = f.getDeclaringClass().getName();
                    String logicalName = emfRefAn.name();
                    if (logicalName.equals("")) {
                        logicalName = targetClassName + "/" + f.getName();
                    }
                    emfRefs = this.getEmfReferenceDescriptors(logicalName, rcContexts);
                    InjectionTarget target = new InjectionTarget();
                    target.setFieldName(f.getName());
                    target.setClassName(targetClassName);
                    target.setMetadataSource(MetadataSource.ANNOTATION);
                    for (EntityManagerFactoryReferenceDescriptor emfRef : emfRefs) {
                        emfRef.addInjectionTarget(target);
                        if (emfRef.getName().length() != 0) continue;
                        this.processNewEmfRefAnnotation(emfRef, logicalName, emfRefAn);
                    }
                    break block7;
                }
                if (!ElementType.METHOD.equals((Object)ainfo.getElementType())) break block8;
                Method m = (Method)ainfo.getAnnotatedElement();
                String targetClassName = m.getDeclaringClass().getName();
                String logicalName = emfRefAn.name();
                if (logicalName.equals("")) {
                    String propertyName = this.getInjectionMethodPropertyName(m, ainfo);
                    logicalName = targetClassName + "/" + propertyName;
                }
                this.validateInjectionMethod(m, ainfo);
                emfRefs = this.getEmfReferenceDescriptors(logicalName, rcContexts);
                InjectionTarget target = new InjectionTarget();
                target.setMethodName(m.getName());
                target.setClassName(targetClassName);
                target.setMetadataSource(MetadataSource.ANNOTATION);
                for (EntityManagerFactoryReferenceDescriptor emfRef : emfRefs) {
                    emfRef.addInjectionTarget(target);
                    if (emfRef.getName().length() != 0) continue;
                    this.processNewEmfRefAnnotation(emfRef, logicalName, emfRefAn);
                }
                break block7;
            }
            if (!ElementType.TYPE.equals((Object)ainfo.getElementType())) break block7;
            String logicalName = emfRefAn.name();
            if ("".equals(logicalName)) {
                Class c = (Class)ainfo.getAnnotatedElement();
                this.log(Level.SEVERE, ainfo, localStrings.getLocalString("enterprise.deployment.annotation.handlers.nonametypelevel", "TYPE-Level annotation symbol on class must specify name."));
                return this.getDefaultFailedResult();
            }
            for (EntityManagerFactoryReferenceDescriptor emfRef : emfRefs = this.getEmfReferenceDescriptors(logicalName, rcContexts)) {
                if (emfRef.getName().length() != 0) continue;
                this.processNewEmfRefAnnotation(emfRef, logicalName, emfRefAn);
            }
        }
        return this.getDefaultProcessedResult();
    }

    private EntityManagerFactoryReferenceDescriptor[] getEmfReferenceDescriptors(String logicalName, ResourceContainerContext[] rcContexts) {
        EntityManagerFactoryReferenceDescriptor[] emfRefs = new EntityManagerFactoryReferenceDescriptor[rcContexts.length];
        for (int i = 0; i < rcContexts.length; ++i) {
            EntityManagerFactoryReferenceDescriptor emfRef = rcContexts[i].getEntityManagerFactoryReference(logicalName);
            if (emfRef == null) {
                emfRef = new EntityManagerFactoryReferenceDescriptor();
                rcContexts[i].addEntityManagerFactoryReferenceDescriptor(emfRef);
            }
            emfRefs[i] = emfRef;
        }
        return emfRefs;
    }

    private void processNewEmfRefAnnotation(EntityManagerFactoryReferenceDescriptor emfRef, String logicalName, PersistenceUnit annotation) {
        emfRef.setName(logicalName);
        if (!annotation.unitName().equals("")) {
            emfRef.setUnitName(annotation.unitName());
        }
    }
}

