/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WSDolSupport;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.DefaultDOLVisitor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.Globals;

public class ModuleContentLinker
extends DefaultDOLVisitor {
    protected ReadableArchive rootLocation_;
    private boolean forceWSDLURLs;

    public ModuleContentLinker(ReadableArchive rootLocation, boolean forceWSDLURLs) {
        this.rootLocation_ = rootLocation;
        this.forceWSDLURLs = forceWSDLURLs;
    }

    public ModuleContentLinker(ReadableArchive rootLocation) {
        this(rootLocation, false);
    }

    protected ModuleContentLinker() {
    }

    private String getModuleLocation(ModuleDescriptor module) throws IOException {
        String moduleLocation = new File(this.rootLocation_.getURI()).getAbsolutePath();
        if (!module.isStandalone()) {
            String archiveUri = module.getArchiveUri();
            archiveUri = archiveUri.replace('.', '_');
            moduleLocation = moduleLocation + File.separator + archiveUri;
        }
        return moduleLocation;
    }

    private URL internalGetUrl(ModuleDescriptor module, String uri) throws Exception {
        File moduleLocation = new File(this.getModuleLocation(module));
        URL url = ModuleContentLinker.getEntryAsUrl(moduleLocation, uri);
        return url;
    }

    public static URL createJarUrl(File jarFile, String entry) throws MalformedURLException, IOException {
        return new URL("jar:" + jarFile.toURI().toURL() + "!/" + entry);
    }

    public static URL getEntryAsUrl(File moduleLocation, String uri) throws MalformedURLException, IOException {
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException e) {
            url = null;
        }
        if (url != null) {
            return url;
        }
        if (moduleLocation != null) {
            if (moduleLocation.isFile()) {
                url = ModuleContentLinker.createJarUrl(moduleLocation, uri);
            } else {
                String path = uri.replace('/', File.separatorChar);
                url = new File(moduleLocation, path).toURI().toURL();
            }
        }
        return url;
    }

    public void accept(ServiceReferenceDescriptor serviceRef) {
        try {
            ModuleDescriptor moduleDesc = serviceRef.getBundleDescriptor().getModuleDescriptor();
            if (serviceRef.hasWsdlFile()) {
                String wsdlFileUri = serviceRef.getWsdlFileUri();
                File tmpFile = new File(wsdlFileUri);
                if (tmpFile.isAbsolute()) {
                    serviceRef.setWsdlFileUrl(tmpFile.toURI().toURL());
                } else if (wsdlFileUri.startsWith("http")) {
                    serviceRef.setWsdlFileUrl(new URL(wsdlFileUri));
                } else {
                    File wsdlFile = new File(this.getModuleLocation(moduleDesc), wsdlFileUri);
                    URL wsdlFileUrl = this.internalGetUrl(moduleDesc, wsdlFileUri);
                    serviceRef.setWsdlFileUrl(wsdlFile.toURI().toURL());
                }
            } else {
                ClassLoader classloader = Thread.currentThread().getContextClassLoader();
                Class<?> serviceInterfaceClass = classloader.loadClass(serviceRef.getServiceInterface());
                WSDolSupport dolSupport = Globals.getDefaultHabitat().getComponent(WSDolSupport.class);
                if (dolSupport != null) {
                    dolSupport.setServiceRef(serviceInterfaceClass, serviceRef);
                }
            }
            if (serviceRef.hasMappingFile()) {
                String mappingFileUri = serviceRef.getMappingFileUri();
                File mappingFile = new File(this.getModuleLocation(moduleDesc), mappingFileUri);
                serviceRef.setMappingFile(mappingFile);
            }
        }
        catch (MalformedURLException mex) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidWsdlURL", new Object[]{serviceRef.getWsdlFileUri()});
        }
        catch (Exception e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{serviceRef.getName(), this.rootLocation_});
        }
    }

    public void accept(WebService webService) {
        try {
            ModuleDescriptor moduleDesc = webService.getBundleDescriptor().getModuleDescriptor();
            if (webService.hasWsdlFile() && (webService.getWsdlFileUrl() == null || this.forceWSDLURLs)) {
                String wsdlFileUri = webService.getWsdlFileUri();
                URL wsdlFileURL = null;
                try {
                    URL url = new URL(wsdlFileUri);
                    if (url.getProtocol() != null && !url.getProtocol().equalsIgnoreCase("file")) {
                        wsdlFileURL = url;
                    }
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                if (wsdlFileURL == null) {
                    File wsdlFile = new File(this.getModuleLocation(moduleDesc), wsdlFileUri);
                    wsdlFileURL = wsdlFile.toURI().toURL();
                }
                webService.setWsdlFileUrl(wsdlFileURL);
            }
            if (webService.hasMappingFile()) {
                String mappingFileUri = webService.getMappingFileUri();
                File mappingFile = new File(this.getModuleLocation(moduleDesc), mappingFileUri);
                webService.setMappingFile(mappingFile);
            }
        }
        catch (Exception e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure", new Object[]{webService.getName(), this.rootLocation_});
        }
    }
}

