/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.glassfish.admin.cli.resources.ResourceFactory;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.admin.cli.resources.ResourcesXMLParser;
import org.glassfish.resource.common.Resource;
import org.glassfish.resource.common.ResourceStatus;

public class ResourcesManager {
    static ArrayList createResources(Resources resources, File resourceXMLFile, Server targetServer, ResourceFactory resourceFactory) throws Exception {
        ArrayList<ResourceStatus> results = new ArrayList<ResourceStatus>();
        ResourcesXMLParser resourcesParser = new ResourcesXMLParser(resourceXMLFile);
        List vResources = resourcesParser.getResourcesList();
        for (Resource resource : ResourcesXMLParser.getNonConnectorResourcesList(vResources, false)) {
            ResourceStatus rs;
            HashMap attrList = resource.getAttributes();
            String desc = resource.getDescription();
            if (desc != null) {
                attrList.put("description", desc);
            }
            Properties props = resource.getProperties();
            try {
                ResourceManager rm = resourceFactory.getResourceManager(resource);
                rs = rm.create(resources, attrList, props, targetServer);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                rs = new ResourceStatus(1, msg);
            }
            results.add(rs);
        }
        for (Resource resource : ResourcesXMLParser.getConnectorResourcesList(vResources, false)) {
            ResourceStatus rs;
            HashMap attrList = resource.getAttributes();
            String desc = resource.getDescription();
            if (desc != null) {
                attrList.put("description", desc);
            }
            Properties props = resource.getProperties();
            try {
                ResourceManager rm = resourceFactory.getResourceManager(resource);
                rs = rm.create(resources, attrList, props, targetServer);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                rs = new ResourceStatus(1, msg);
            }
            results.add(rs);
        }
        return results;
    }
}

