/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.client;

import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.Image;
import com.sun.pkg.client.ImagePlanProgressTracker;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

class FileList {
    static final int max_bytes = 0x100000;
    Image img;
    Fmri fmri;
    Map<String, List<DataSink>> flist = new HashMap<String, List<DataSink>>();
    File download_dir;

    public FileList(Image i, Fmri f) {
        this.img = i;
        this.fmri = f;
        this.download_dir = new File(new File(this.img.getMetaDirectory(), "download"), FileList.getPID());
    }

    public void add(DataSink a) {
        String h = a.getHash();
        List<DataSink> l = this.flist.get(h);
        if (l == null) {
            l = new ArrayList<DataSink>();
            this.flist.put(h, l);
        }
        l.add(a);
    }

    public long computeTransferSize() {
        long total = 0L;
        for (List<DataSink> ds : this.flist.values()) {
            total += (long)ds.get(0).getSize();
        }
        return total;
    }

    public int computeTransferFiles() {
        return this.flist.size();
    }

    public void download(ImagePlanProgressTracker tracker) throws IOException {
        if (this.flist.isEmpty()) {
            return;
        }
        this.download_dir.mkdirs();
        StringBuffer reqbuf = new StringBuffer();
        int i = 0;
        int size = 0;
        int nfile = 0;
        byte[] buf = new byte[32768];
        this.img.getLogger().log(Level.FINE, "downloadfiles", new Object[]{this.fmri, this.flist.size()});
        tracker.startPackageDownload(this.fmri, this.flist.size(), this.computeTransferSize());
        Iterator<String> aiter = this.flist.keySet().iterator();
        while (aiter.hasNext()) {
            String hash = aiter.next();
            if (reqbuf.length() > 0) {
                reqbuf.append("&");
            }
            reqbuf.append("File-Name-" + i + "=" + URLEncoder.encode(hash, "UTF-8"));
            DataSink fa = this.flist.get(hash).get(0);
            if ((size += fa.getSize()) > 0x100000 || !aiter.hasNext()) {
                TarEntry te;
                HttpURLConnection uc = this.img.getRepositoryURLConnection("filelist/0", this.fmri);
                uc.setDoOutput(true);
                OutputStreamWriter osw = new OutputStreamWriter(uc.getOutputStream());
                osw.write(reqbuf.toString());
                osw.close();
                this.img.checkRepositoryConnection(uc);
                TarInputStream tis = new TarInputStream(new BufferedInputStream(uc.getInputStream()));
                while ((te = tis.getNextEntry()) != null) {
                    int numRead;
                    hash = te.getName();
                    List<DataSink> fal = this.flist.get(hash);
                    if (fal == null) {
                        throw new IOException("invalid response from server: unrequested file: " + hash);
                    }
                    fa = fal.get(0);
                    String outfilename = hash;
                    this.img.getLogger().log(Level.FINER, "downloading", outfilename);
                    tracker.startFileDownload(nfile, fa.getSize());
                    File gzipfile = new File(this.download_dir, outfilename);
                    fa.setGzipFile(gzipfile);
                    FileOutputStream fos = new FileOutputStream(gzipfile);
                    long xferedBytes = 0L;
                    while ((numRead = tis.read(buf, 0, buf.length)) != -1) {
                        ((OutputStream)fos).write(buf, 0, numRead);
                        tracker.onFileDownloadProgress(nfile, xferedBytes += (long)numRead);
                    }
                    tracker.onFileDownloadProgress(nfile, xferedBytes);
                    ((OutputStream)fos).close();
                    tracker.endFileDownload(nfile++, fa.getSize());
                    for (int j = 1; j < fal.size(); ++j) {
                        DataSink nfa = fal.get(j);
                        nfa.setGzipFile(gzipfile);
                    }
                }
                size = 0;
                i = 0;
                reqbuf = new StringBuffer();
            }
            ++i;
        }
        tracker.endPackageDownload(this.fmri, this.flist.size());
    }

    public void cleanupDownload() throws IOException {
        this.img.getLogger().log(Level.FINEST, "deletingtemp");
        File[] files = this.download_dir.listFiles();
        if (files != null && files.length > 0) {
            for (File f : files) {
                f.delete();
            }
        }
        if (this.download_dir.exists()) {
            this.download_dir.delete();
        }
    }

    static String getPID() {
        int i;
        String name = ManagementFactory.getRuntimeMXBean().getName();
        for (i = 0; i < name.length() && Character.isDigit(name.charAt(i)); ++i) {
        }
        return i > 0 ? name.substring(0, i) : "0";
    }

    static interface DataSink {
        public String getHash();

        public int getSize();

        public void setGzipFile(File var1);
    }
}

