/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.logging.LogDomains;
import java.io.Console;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.glassfish.api.admin.config.Container;
import org.glassfish.api.admin.config.DomainContext;
import org.glassfish.api.admin.config.DomainInitializer;
import org.glassfish.api.embedded.EmbeddedFileSystem;
import org.glassfish.api.embedded.LifecycleException;
import org.glassfish.api.embedded.Server;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="create-domain")
@Scoped(value=PerLookup.class)
public final class CreateDomainCommand
extends CLICommand {
    private static final String DOMAINDIR = "domaindir";
    private static final String ADMIN_PORT = "adminport";
    private static final String ADMIN_PASSWORD = "AS_ADMIN_PASSWORD";
    private static final String ADMIN_ADMINPASSWORD = "AS_ADMIN_ADMINPASSWORD";
    private static final String MASTER_PASSWORD = "AS_ADMIN_MASTERPASSWORD";
    private static final String DEFAULT_MASTER_PASSWORD = "changeit";
    private static final String SAVE_MASTER_PASSWORD = "savemasterpassword";
    private static final String PROFILE_OPTION = "profile";
    private static final String DOMAIN_PATH = "path";
    private static final String INSTANCE_PORT = "instanceport";
    private static final String TEMPLATE = "template";
    private static final String DOMAIN_PROPERTIES = "domainproperties";
    private static final String CHECKPORTS_OPTION = "checkports";
    private static final String PORTBASE_OPTION = "portbase";
    private static final String SAVELOGIN_OPTION = "savelogin";
    private static final String KEYTOOLOPTIONS = "keytooloptions";
    private static final String NOPASSWORD = "nopassword";
    private static final int DEFAULT_HTTPSSL_PORT = 8181;
    private static final int DEFAULT_IIOPSSL_PORT = 3820;
    private static final int DEFAULT_IIOPMUTUALAUTH_PORT = 3920;
    private static final int DEFAULT_INSTANCE_PORT = 8080;
    private static final int DEFAULT_JMS_PORT = 7676;
    private static final String DEFAULT_JMS_USER = "admin";
    private static final String DEFAULT_JMS_PASSWORD = "admin";
    private static final int DEFAULT_IIOP_PORT = 3700;
    private static final int DEFAULT_JMX_PORT = 8686;
    private static final int DEFAULT_OSGI_SHELL_TELNET_PORT = 6666;
    private static final int PORT_MAX_VAL = 65535;
    private static final int PORTBASE_ADMINPORT_SUFFIX = 48;
    private static final int PORTBASE_HTTPSSL_SUFFIX = 81;
    private static final int PORTBASE_IIOPSSL_SUFFIX = 38;
    private static final int PORTBASE_IIOPMUTUALAUTH_SUFFIX = 39;
    private static final int PORTBASE_INSTANCE_SUFFIX = 80;
    private static final int PORTBASE_JMS_SUFFIX = 76;
    private static final int PORTBASE_IIOP_SUFFIX = 37;
    private static final int PORTBASE_JMX_SUFFIX = 86;
    private static final int PORTBASE_OSGI_SHELL_SUFFIX = 66;
    private static final char ESCAPE_CHAR = '\\';
    private static final char EQUAL_SIGN = '=';
    private static final String DELIMITER = ":";
    private String domainName = null;
    private String adminUser = null;
    private String adminPassword = null;
    private String masterPassword = null;
    private boolean checkPorts;
    private ValidOption masterPasswordOption = new ValidOption("AS_ADMIN_MASTERPASSWORD", "PASSWORD", 1, strings.get("MasterPassword"));
    private ValidOption adminPasswordOption = new ValidOption("AS_ADMIN_PASSWORD", "PASSWORD", 1, strings.get("AdminPassword"));
    private ValidOption adminPortOption;
    private ValidOption instancePortOption;
    private static final LocalStringsImpl strings = new LocalStringsImpl(CreateDomainCommand.class);

    protected void prepare() throws CommandException, CommandValidationException {
        LinkedHashSet opts = new LinkedHashSet();
        this.adminPortOption = CreateDomainCommand.addOption(opts, (String)ADMIN_PORT, (char)'\u0000', (String)"STRING", (boolean)false, null);
        CreateDomainCommand.addOption(opts, (String)PORTBASE_OPTION, (char)'\u0000', (String)"STRING", (boolean)false, null);
        CreateDomainCommand.addOption(opts, (String)PROFILE_OPTION, (char)'\u0000', (String)"STRING", (boolean)false, null);
        CreateDomainCommand.addOption(opts, (String)TEMPLATE, (char)'\u0000', (String)"STRING", (boolean)false, null);
        CreateDomainCommand.addOption(opts, (String)DOMAINDIR, (char)'\u0000', (String)"STRING", (boolean)false, null);
        this.instancePortOption = CreateDomainCommand.addOption(opts, (String)INSTANCE_PORT, (char)'\u0000', (String)"STRING", (boolean)false, null);
        CreateDomainCommand.addOption(opts, (String)SAVE_MASTER_PASSWORD, (char)'\u0000', (String)"BOOLEAN", (boolean)false, (String)"false");
        CreateDomainCommand.addOption(opts, (String)DOMAIN_PROPERTIES, (char)'\u0000', (String)"STRING", (boolean)false, null);
        CreateDomainCommand.addOption(opts, (String)KEYTOOLOPTIONS, (char)'\u0000', (String)"STRING", (boolean)false, null);
        CreateDomainCommand.addOption(opts, (String)SAVELOGIN_OPTION, (char)'\u0000', (String)"BOOLEAN", (boolean)false, (String)"false");
        CreateDomainCommand.addOption(opts, (String)CHECKPORTS_OPTION, (char)'\u0000', (String)"BOOLEAN", (boolean)false, (String)"true");
        CreateDomainCommand.addOption(opts, (String)ADMIN_PASSWORD, (char)'\u0000', (String)"PASSWORD", (boolean)false, null);
        CreateDomainCommand.addOption(opts, (String)NOPASSWORD, (char)'\u0000', (String)"BOOLEAN", (boolean)false, (String)"false");
        CreateDomainCommand.addOption(opts, (String)"help", (char)'?', (String)"BOOLEAN", (boolean)false, (String)"false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandName = "domain_name";
        this.operandType = "STRING";
        this.operandMin = 1;
        this.operandMax = 1;
        this.processProgramOptions();
    }

    protected Set<ValidOption> usageOptions() {
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        CreateDomainCommand.addOption(opts, (String)ADMIN_PORT, (char)'\u0000', (String)"STRING", (boolean)false, (String)Integer.toString(4848));
        CreateDomainCommand.addOption(opts, (String)INSTANCE_PORT, (char)'\u0000', (String)"STRING", (boolean)false, (String)Integer.toString(8080));
        opts.addAll(this.commandOpts);
        opts.remove(this.adminPortOption);
        opts.remove(this.instancePortOption);
        return opts;
    }

    protected void validate() throws CommandException, CommandValidationException {
        if (this.programOpts.getUser() == null && !this.getBooleanOption(NOPASSWORD)) {
            Console cons = System.console();
            if (cons != null && this.programOpts.isInteractive()) {
                cons.printf("%s", strings.get("AdminUserRequiredPrompt", new Object[]{"admin"}));
                String val = cons.readLine();
                if (CreateDomainCommand.ok((String)val)) {
                    this.programOpts.setUser(val);
                }
            } else {
                throw new CommandValidationException(strings.get("AdminUserRequired"));
            }
        }
        super.validate();
        this.checkPorts = this.getBooleanOption(CHECKPORTS_OPTION);
    }

    public void verifyPortBase() throws CommandValidationException {
        if (this.usePortBase()) {
            int portbase = this.convertPortStr(this.getOption(PORTBASE_OPTION));
            this.setOptionsWithPortBase(portbase);
        } else if (this.getOption(ADMIN_PORT) == null) {
            this.options.put(ADMIN_PORT, Integer.toString(4848));
        }
    }

    private void setOptionsWithPortBase(int portbase) throws CommandValidationException {
        this.verifyPortBasePortIsValid(ADMIN_PORT, portbase + 48);
        this.options.put(ADMIN_PORT, String.valueOf(portbase + 48));
        this.verifyPortBasePortIsValid(INSTANCE_PORT, portbase + 80);
        this.options.put(INSTANCE_PORT, String.valueOf(portbase + 80));
        StringBuffer sb = new StringBuffer();
        this.verifyPortBasePortIsValid("http.ssl.port", portbase + 81);
        sb.append("http.ssl.port");
        sb.append("=");
        sb.append(String.valueOf(portbase + 81));
        sb.append(DELIMITER);
        this.verifyPortBasePortIsValid("orb.ssl.port", portbase + 38);
        sb.append("orb.ssl.port");
        sb.append("=");
        sb.append(String.valueOf(portbase + 38));
        sb.append(DELIMITER);
        this.verifyPortBasePortIsValid("orb.mutualauth.port", portbase + 39);
        sb.append("orb.mutualauth.port");
        sb.append("=");
        sb.append(String.valueOf(portbase + 39));
        sb.append(DELIMITER);
        this.verifyPortBasePortIsValid("jms.port", portbase + 76);
        sb.append("jms.port");
        sb.append("=");
        sb.append(String.valueOf(portbase + 76));
        sb.append(DELIMITER);
        this.verifyPortBasePortIsValid("orb.listener.port", portbase + 37);
        sb.append("orb.listener.port");
        sb.append("=");
        sb.append(String.valueOf(portbase + 37));
        sb.append(DELIMITER);
        this.verifyPortBasePortIsValid("domain.jmxPort", portbase + 86);
        sb.append("domain.jmxPort");
        sb.append("=");
        sb.append(String.valueOf(portbase + 86));
        sb.append(DELIMITER);
        this.verifyPortBasePortIsValid("osgi.shell.telnet.port", portbase + 66);
        sb.append("osgi.shell.telnet.port");
        sb.append("=");
        sb.append(String.valueOf(portbase + 66));
        this.options.put(DOMAIN_PROPERTIES, sb.toString());
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            this.domainName = (String)this.operands.get(0);
            PEDomainsManager manager = new PEDomainsManager();
            DomainConfig config = new DomainConfig(this.domainName, this.getDomainsRoot());
            manager.validateDomain(config, false);
            this.verifyPortBase();
        }
        catch (DomainException e) {
            logger.printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(strings.get("CouldNotCreateDomain", new Object[]{this.domainName}), (Throwable)e);
        }
        this.adminUser = this.programOpts.getUser();
        if (!CreateDomainCommand.ok((String)this.adminUser)) {
            this.adminUser = "admin";
            this.adminPassword = "";
            this.masterPassword = DEFAULT_MASTER_PASSWORD;
        } else if (this.getBooleanOption(NOPASSWORD)) {
            this.adminPassword = "";
            this.masterPassword = DEFAULT_MASTER_PASSWORD;
        } else {
            boolean haveAdminPwd = false;
            this.adminPassword = (String)this.passwords.get(ADMIN_ADMINPASSWORD);
            if (this.adminPassword != null) {
                haveAdminPwd = true;
                logger.printWarning(strings.get("DeprecatedAdminPassword"));
            } else {
                haveAdminPwd = this.passwords.get(ADMIN_PASSWORD) != null;
                this.adminPassword = this.getAdminPassword();
            }
            this.validatePassword(this.adminPassword, this.adminPasswordOption);
            this.masterPassword = haveAdminPwd ? (String)this.passwords.get(MASTER_PASSWORD) : this.getMasterPassword();
            if (this.masterPassword == null) {
                this.masterPassword = DEFAULT_MASTER_PASSWORD;
            }
            this.validatePassword(this.masterPassword, this.masterPasswordOption);
        }
        try {
            if (this.getOption(ADMIN_PORT) != null) {
                this.verifyPortIsValid(this.getOption(ADMIN_PORT));
            }
            if (this.getOption(INSTANCE_PORT) != null) {
                this.verifyPortIsValid(this.getOption(INSTANCE_PORT));
            }
            Properties domainProperties = this.getDomainProperties(this.getOption(DOMAIN_PROPERTIES));
            domainProperties.remove("domain.adminPort");
            this.createTheDomain(this.getDomainsRoot(), domainProperties);
        }
        catch (CommandException ce) {
            logger.printMessage(ce.getLocalizedMessage());
            throw new CommandException(strings.get("CouldNotCreateDomain", new Object[]{this.domainName}), (Throwable)ce);
        }
        catch (Exception e) {
            logger.printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(strings.get("CouldNotCreateDomain", new Object[]{this.domainName}), (Throwable)e);
        }
        return 0;
    }

    private void verifyPortIsValid(String portNum) throws CommandException, CommandValidationException {
        int portToVerify = this.convertPortStr(portNum);
        NetUtils.PortAvailability avail = NetUtils.checkPort((int)portToVerify);
        String domainName = (String)this.operands.get(0);
        switch (avail) {
            case illegalNumber: {
                throw new CommandException(strings.get("InvalidPortRange", new Object[]{portNum}));
            }
            case inUse: {
                if (this.checkPorts) {
                    throw new CommandException(strings.get("PortInUseError", new Object[]{domainName, portNum}));
                }
                logger.printWarning(strings.get("PortInUseWarning", new Object[]{portNum}));
                break;
            }
            case noPermission: {
                if (this.checkPorts) {
                    throw new CommandException(strings.get("NoPermissionForPortError", new Object[]{portNum, domainName}));
                }
                logger.printWarning(strings.get("NoPermissionForPortWarning", new Object[]{portNum, domainName}));
                break;
            }
            case unknown: {
                throw new CommandException(strings.get("UnknownPortMsg", new Object[]{portNum}));
            }
            case OK: {
                logger.printDebugMessage("Port =" + portToVerify);
            }
        }
    }

    private int convertPortStr(String port) throws CommandValidationException {
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new CommandValidationException(strings.get("InvalidPortNumber", new Object[]{port}));
        }
    }

    private void verifyPortBasePortIsValid(String portName, int portNum) throws CommandValidationException {
        if (portNum <= 0 || portNum > 65535) {
            throw new CommandValidationException(strings.get("InvalidPortBaseRange", new Object[]{portNum, portName}));
        }
        if (this.checkPorts && !NetUtils.isPortFree((int)portNum)) {
            throw new CommandValidationException(strings.get("PortBasePortInUse", new Object[]{portNum, portName}));
        }
        logger.printDebugMessage("Port =" + portNum);
    }

    private Properties getDomainProperties(String propertyValues) throws CommandException, CommandValidationException {
        Properties propertyList = new Properties();
        if (propertyValues == null) {
            return propertyList;
        }
        StringTokenizer st = new StringTokenizer(propertyValues, DELIMITER);
        while (st.hasMoreTokens()) {
            String propertyString = st.nextToken();
            while (st.hasMoreTokens() && propertyString.endsWith(Character.toString('\\'))) {
                propertyString = propertyString.concat(st.nextToken());
            }
            int index = propertyString.indexOf(Character.toString('='));
            if (index == -1) {
                throw new CommandValidationException(strings.get("InvalidPropertySyntax"));
            }
            String propertyName = propertyString.substring(0, index);
            String propertyValue = propertyString.substring(index + 1);
            propertyList.put(propertyName, propertyValue);
        }
        logger.printDebugMessage("domain properties = " + propertyList);
        return propertyList;
    }

    private void createTheDomain(String domainPath, Properties domainProperties) throws DomainException, CommandValidationException {
        Integer adminPort = Integer.valueOf(this.getOption(ADMIN_PORT));
        logger.printDetailMessage(strings.get("UsingPort", new Object[]{"Admin", Integer.toString(adminPort)}));
        String domainFilePath = domainPath + File.separator + this.domainName;
        if (FileUtils.safeGetCanonicalFile((File)new File(domainFilePath)).exists()) {
            throw new CommandValidationException(strings.get("DomainExists", new Object[]{this.domainName}));
        }
        Integer instancePort = this.getPort(domainProperties, "domain.instancePort", this.getOption(INSTANCE_PORT), Integer.toString(8080), "HTTP Instance");
        Integer jmsPort = this.getPort(domainProperties, "jms.port", null, Integer.toString(7676), "JMS");
        String jmsUser = "admin";
        String jmsPassword = "admin";
        Integer orbPort = this.getPort(domainProperties, "orb.listener.port", null, Integer.toString(3700), "IIOP");
        Integer httpSSLPort = this.getPort(domainProperties, "http.ssl.port", null, Integer.toString(8181), "HTTP_SSL");
        Integer iiopSSLPort = this.getPort(domainProperties, "orb.ssl.port", null, Integer.toString(3820), "IIOP_SSL");
        Integer iiopMutualAuthPort = this.getPort(domainProperties, "orb.mutualauth.port", null, Integer.toString(3920), "IIOP_MUTUALAUTH");
        Integer jmxPort = this.getPort(domainProperties, "domain.jmxPort", null, Integer.toString(8686), "JMX_ADMIN");
        Integer osgiShellTelnetPort = this.getPort(domainProperties, "osgi.shell.telnet.port", null, Integer.toString(6666), "OSGI_SHELL");
        boolean saveMasterPassword = this.getSaveMasterPassword(this.masterPassword);
        this.checkPortPrivilege(new Integer[]{adminPort, instancePort, jmsPort, orbPort, httpSSLPort, jmsPort, orbPort, httpSSLPort, iiopSSLPort, iiopMutualAuthPort, jmxPort});
        DomainConfig domainConfig = new DomainConfig(this.domainName, adminPort, domainPath, this.adminUser, this.adminPassword, this.masterPassword, Boolean.valueOf(saveMasterPassword), instancePort, "admin", "admin", jmsPort, orbPort, httpSSLPort, iiopSSLPort, iiopMutualAuthPort, jmxPort, osgiShellTelnetPort, domainProperties);
        if (this.getOption(TEMPLATE) != null) {
            domainConfig.put((Object)"template.name", (Object)this.getOption(TEMPLATE));
        }
        domainConfig.put((Object)"domain.validatePorts", (Object)this.checkPorts);
        domainConfig.put((Object)KEYTOOLOPTIONS, (Object)this.getOption(KEYTOOLOPTIONS));
        PEDomainsManager manager = new PEDomainsManager();
        manager.createDomain(domainConfig);
        try {
            this.modifyInitialDomainXml(domainConfig);
        }
        catch (Exception e) {
            logger.printWarning(strings.get("CustomizationFailed", new Object[]{e.getMessage()}));
        }
        logger.printMessage(strings.get("DomainCreated", new Object[]{this.domainName}));
        logger.printMessage(strings.get("DomainPort", new Object[]{this.domainName, Integer.toString(adminPort)}));
        if (this.adminPassword.equals("")) {
            logger.printMessage(strings.get("DomainAllowsUnauth", new Object[]{this.domainName, this.adminUser}));
        } else {
            logger.printMessage(strings.get("DomainAdminUser", new Object[]{this.domainName, this.adminUser}));
        }
        if (this.getBooleanOption(SAVELOGIN_OPTION)) {
            this.saveLogin(adminPort, this.adminUser, this.adminPassword, this.domainName);
        }
    }

    private void setUsageProfile(DomainConfig dc) {
        String pp = this.getOption(PROFILE_OPTION);
        String source = strings.get("ProfileUserSource");
        if (pp == null) {
            pp = "developer";
            source = strings.get("ProfileGlobalDefaultSource");
        }
        dc.put((Object)"domain.profile", (Object)pp);
        String msg = strings.get("UsingProfile", new Object[]{pp, source});
        String templateName = this.getOption(TEMPLATE);
        if (templateName != null) {
            msg = strings.get("UsingTemplate", new Object[]{templateName});
        }
        logger.printMessage(msg);
    }

    private void saveLogin(int port, String user, String password, String dn) {
        block3: {
            try {
                LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
                LoginInfo login = new LoginInfo("localhost", port, user, password);
                if (store.exists(login.getHost(), login.getPort())) {
                    logger.printMessage(strings.get("OverwriteLoginMsgCreateDomain", new Object[]{login.getHost(), "" + login.getPort()}));
                }
                store.store(login, true);
                logger.printMessage(strings.get("LoginInfoStoredCreateDomain", new Object[]{user, dn, store.getName()}));
            }
            catch (Exception e) {
                logger.printWarning(strings.get("LoginInfoNotStoredCreateDomain", new Object[]{user, dn}));
                if (!logger.isDebug()) break block3;
                logger.printExceptionStackTrace((Throwable)e);
            }
        }
    }

    private Integer getPort(Properties properties, String key, String portStr, String defaultPort, String name) throws CommandValidationException {
        int port = 0;
        boolean portNotSpecified = false;
        boolean invalidPortSpecified = false;
        boolean defaultPortUsed = false;
        if (portStr != null && !portStr.equals("")) {
            port = this.convertPortStr(portStr);
            if (port <= 0 || port > 65535) {
                invalidPortSpecified = true;
            }
        } else if (properties != null) {
            String property = properties.getProperty(key);
            if (property != null && !property.equals("")) {
                port = this.convertPortStr(property);
            } else {
                portNotSpecified = true;
            }
        } else {
            portNotSpecified = true;
        }
        if (portNotSpecified) {
            port = this.convertPortStr(defaultPort);
            defaultPortUsed = true;
        }
        if (this.checkPorts && !NetUtils.isPortFree((int)port)) {
            int newport = NetUtils.getFreePort();
            if (portNotSpecified) {
                if (defaultPortUsed) {
                    logger.printDetailMessage(strings.get("DefaultPortInUse", new Object[]{name, defaultPort, Integer.toString(newport)}));
                } else {
                    logger.printDetailMessage(strings.get("PortNotSpecified", new Object[]{name, Integer.toString(newport)}));
                }
            } else if (invalidPortSpecified) {
                logger.printDetailMessage(strings.get("InvalidPortRangeMsg", new Object[]{name, Integer.toString(newport)}));
            } else {
                logger.printDetailMessage(strings.get("PortInUse", new Object[]{name, Integer.toString(port), Integer.toString(newport)}));
            }
            port = newport;
        } else if (defaultPortUsed) {
            logger.printDetailMessage(strings.get("UsingDefaultPort", new Object[]{name, Integer.toString(port)}));
        } else {
            logger.printDetailMessage(strings.get("UsingPort", new Object[]{name, Integer.toString(port)}));
        }
        if (properties != null) {
            properties.remove(key);
        }
        return port;
    }

    private boolean usePortBase() throws CommandValidationException {
        if (this.getOption(PORTBASE_OPTION) != null) {
            if (this.getOption(ADMIN_PORT) != null) {
                throw new CommandValidationException(strings.get("MutuallyExclusiveOption", new Object[]{ADMIN_PORT, PORTBASE_OPTION}));
            }
            if (this.getOption(INSTANCE_PORT) != null) {
                throw new CommandValidationException(strings.get("MutuallyExclusiveOption", new Object[]{INSTANCE_PORT, PORTBASE_OPTION}));
            }
            if (this.getOption(DOMAIN_PROPERTIES) != null) {
                throw new CommandValidationException(strings.get("MutuallyExclusiveOption", new Object[]{DOMAIN_PROPERTIES, PORTBASE_OPTION}));
            }
            return true;
        }
        return false;
    }

    private void checkPortPrivilege(Integer[] ports) {
        for (Integer port : ports) {
            int p = port;
            if (p >= 1024) continue;
            logger.printWarning(strings.get("PortPrivilege"));
            break;
        }
    }

    public void validatePassword(String password, ValidOption pwdOpt) throws CommandValidationException {
        String description = pwdOpt.getDefaultValue();
        if (!CreateDomainCommand.ok((String)description)) {
            description = pwdOpt.getName();
        }
        if (password == null) {
            throw new CommandValidationException(strings.get("PasswordMissing", new Object[]{description}));
        }
    }

    protected String getAdminPassword() throws CommandValidationException {
        return this.getPassword(this.adminPasswordOption, "", true);
    }

    private String getMasterPassword() throws CommandValidationException, CommandException {
        return this.getPassword(this.masterPasswordOption, DEFAULT_MASTER_PASSWORD, true);
    }

    private void modifyInitialDomainXml(DomainConfig domainConfig) throws LifecycleException {
        Server.Builder builder = new Server.Builder("dummylaunch");
        EmbeddedFileSystem.Builder efsb = new EmbeddedFileSystem.Builder();
        efsb.installRoot(new File(domainConfig.getInstallRoot()));
        File domainDir = new File(domainConfig.getDomainRoot(), domainConfig.getDomainName());
        File configDir = new File(domainDir, "config");
        efsb.configurationFile(new File(configDir, "domain.xml"), false);
        builder.embeddedFileSystem(efsb.build());
        Properties properties = new Properties();
        properties.setProperty("hk2.startup.context.moduleStartup", "DomainCreation");
        org.glassfish.api.embedded.Server server = builder.build(properties);
        server.start();
        Habitat habitat = server.getHabitat();
        Server serverConfig = (Server)habitat.getComponent(Server.class, "server");
        Config config = (Config)habitat.getComponent(Config.class, serverConfig.getConfigRef());
        DomainContext ctx = new DomainContext();
        ctx.setDomainType("dev");
        ctx.setLogger(LogDomains.getLogger(DomainInitializer.class, (String)"javax.enterprise.system"));
        Collection inits = habitat.getAllByContract(DomainInitializer.class);
        if (inits.isEmpty()) {
            logger.printMessage("No domain initializers found, bypassing customization step");
        }
        for (DomainInitializer inhabitant : habitat.getAllByContract(DomainInitializer.class)) {
            logger.printMessage("Invoke DomainInitializer " + inhabitant.getClass());
            Container newContainerConfig = inhabitant.getInitialConfig(ctx);
            config.getContainers().add(newContainerConfig);
        }
        server.stop();
    }

    protected boolean getSaveMasterPassword(String masterPassword) {
        boolean saveMasterPassword = this.getBooleanOption(SAVE_MASTER_PASSWORD);
        if (masterPassword != null && masterPassword.equals(DEFAULT_MASTER_PASSWORD)) {
            saveMasterPassword = true;
        }
        return saveMasterPassword;
    }

    protected String getDomainsRoot() throws CommandException {
        String domainDir = this.getOption(DOMAINDIR);
        if (domainDir == null) {
            domainDir = this.getSystemProperty("com.sun.aas.domainsRoot");
        }
        if (domainDir == null) {
            throw new CommandException(strings.get("InvalidDomainPath", new Object[]{domainDir}));
        }
        return domainDir;
    }
}

