/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataConverter;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;

public class LobMetadata
extends MetadataConverter {
    public LobMetadata() {
        super("<lob>");
    }

    public LobMetadata(MetadataAnnotation lob, MetadataAccessibleObject accessibleObject) {
        super(lob, accessibleObject);
    }

    public static boolean isValidBlobType(MetadataClass cls) {
        return cls.equals(byte[].class) || cls.equals(Byte[].class) || cls.equals(Blob.class);
    }

    public static boolean isValidClobType(MetadataClass cls) {
        return cls.equals(char[].class) || cls.equals(String.class) || cls.equals(Character[].class) || cls.equals(Clob.class);
    }

    public static boolean isValidLobType(MetadataClass cls) {
        return LobMetadata.isValidClobType(cls) || LobMetadata.isValidBlobType(cls);
    }

    public void process(DatabaseMapping mapping, MappingAccessor accessor, MetadataClass referenceClass, boolean isForMapKey) {
        if (LobMetadata.isValidClobType(referenceClass)) {
            this.setFieldClassification(mapping, Clob.class, isForMapKey);
            this.setConverter(mapping, (Converter)new TypeConversionConverter(mapping), isForMapKey);
        } else if (LobMetadata.isValidBlobType(referenceClass)) {
            this.setFieldClassification(mapping, Blob.class, isForMapKey);
            this.setConverter(mapping, (Converter)new TypeConversionConverter(mapping), isForMapKey);
        } else if (referenceClass.extendsInterface(Serializable.class)) {
            this.setFieldClassification(mapping, Blob.class, isForMapKey);
            this.setConverter(mapping, (Converter)new SerializedObjectConverter(mapping), isForMapKey);
        } else {
            throw ValidationException.invalidTypeForLOBAttribute((String)mapping.getAttributeName(), (Object)referenceClass, (Object)accessor.getJavaClass());
        }
    }
}

