/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.spi;

import com.sun.faces.config.AnnotationScanner;
import com.sun.faces.spi.AnnotationProvider;
import com.sun.faces.spi.ServiceFactoryUtils;
import java.lang.reflect.Constructor;
import javax.faces.FacesException;
import javax.servlet.ServletContext;

public class AnnotationProviderFactory {
    private static final Class<? extends AnnotationProvider> DEFAULT_ANNOTATION_PROVIDER = AnnotationScanner.class;
    private static final String ANNOTATION_PROVIDER_SERVICE_KEY = "com.sun.faces.spi.annotationprovider";

    public static AnnotationProvider createAnnotationProvider(ServletContext sc) {
        AnnotationProvider annotationProvider = AnnotationProviderFactory.createDefaultProvider(sc);
        String[] services = ServiceFactoryUtils.getServiceEntries(ANNOTATION_PROVIDER_SERVICE_KEY);
        if (services.length > 0) {
            Object provider = ServiceFactoryUtils.getProviderFromEntry(services[0], new Class[]{ServletContext.class, AnnotationProvider.class}, new Object[]{sc, annotationProvider});
            if (provider == null) {
                provider = ServiceFactoryUtils.getProviderFromEntry(services[0], new Class[]{ServletContext.class}, new Object[]{sc});
            }
            if (provider != null) {
                if (!(provider instanceof AnnotationProvider)) {
                    throw new FacesException("Class " + provider.getClass().getName() + " is not an instance of com.sun.faces.spi.AnnotationProvider");
                }
                annotationProvider = (AnnotationProvider)provider;
            }
        }
        return annotationProvider;
    }

    private static AnnotationProvider createDefaultProvider(ServletContext sc) {
        try {
            Constructor<? extends AnnotationProvider> c = DEFAULT_ANNOTATION_PROVIDER.getDeclaredConstructor(ServletContext.class);
            return c.newInstance(sc);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }
}

