/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.util.LinkedHashSet;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.glassfish.external.amx.MBeanListener;
import org.glassfish.gmbal.GmbalException;
import org.glassfish.gmbal.generic.UnaryVoidFunction;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.MBeanImpl;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;

public class JMXRegistrationManager {
    private int suspendCount = 0;
    private final ManagedObjectManagerInternal mom;
    private final ObjectName rootParentName;
    final Object lock = new Object();
    private final LinkedHashSet<MBeanImpl> deferredRegistrations;
    MBeanImpl root;
    boolean isJMXRegistrationEnabled;
    private RootParentListener callback;
    private MBeanListener rpListener;

    public JMXRegistrationManager(ManagedObjectManagerInternal mom, ObjectName rootParentName) {
        this.mom = mom;
        this.rootParentName = rootParentName;
        this.deferredRegistrations = new LinkedHashSet();
        this.root = null;
        this.isJMXRegistrationEnabled = false;
        this.callback = null;
        this.rpListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoot(MBeanImpl root) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        Object object = this.lock;
        synchronized (object) {
            this.root = root;
            if (this.rootParentName == null) {
                this.isJMXRegistrationEnabled = true;
                this.register(root);
            } else {
                if (this.suspendCount > 0) {
                    this.deferredRegistrations.add(root);
                    root.suspended(true);
                }
                this.callback = new RootParentListener();
                this.rpListener = new MBeanListener((MBeanServerConnection)this.mom.getMBeanServer(), this.rootParentName, (MBeanListener.Callback)this.callback);
                this.rpListener.startListening();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.root = null;
            this.isJMXRegistrationEnabled = false;
            if (this.rpListener != null) {
                this.rpListener.stopListening();
            }
            this.rpListener = null;
            this.callback = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendRegistration() {
        Object object = this.lock;
        synchronized (object) {
            ++this.suspendCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeRegistration() {
        Object object = this.lock;
        synchronized (object) {
            --this.suspendCount;
            if (this.suspendCount == 0) {
                for (MBeanImpl mb : this.deferredRegistrations) {
                    try {
                        if (this.isJMXRegistrationEnabled) {
                            mb.register();
                        }
                        mb.suspended(false);
                    }
                    catch (JMException ex) {
                        Exceptions.self.deferredRegistrationException(ex, mb);
                    }
                }
                this.deferredRegistrations.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(MBeanImpl mb) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        Object object = this.lock;
        synchronized (object) {
            if (this.suspendCount > 0) {
                this.deferredRegistrations.add(mb);
                mb.suspended(true);
            } else if (this.isJMXRegistrationEnabled) {
                mb.register();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(MBeanImpl mb) throws InstanceNotFoundException, MBeanRegistrationException {
        Object object = this.lock;
        synchronized (object) {
            boolean wasSuspended = mb.suspended();
            if (wasSuspended) {
                this.deferredRegistrations.remove(mb);
                mb.suspended(false);
            } else if (this.isJMXRegistrationEnabled) {
                mb.unregister();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RootParentListener
    implements MBeanListener.Callback {
        private final UnaryVoidFunction<MBeanImpl> REGISTER_FUNC = new UnaryVoidFunction<MBeanImpl>(){

            @Override
            public void evaluate(MBeanImpl arg) {
                if (!arg.suspended()) {
                    try {
                        arg.register();
                    }
                    catch (Exception ex) {
                        throw new GmbalException("Registration exception", ex);
                    }
                }
            }
        };
        private final UnaryVoidFunction<MBeanImpl> UNREGISTER_FUNC = new UnaryVoidFunction<MBeanImpl>(){

            @Override
            public void evaluate(MBeanImpl arg) {
                if (!arg.suspended()) {
                    try {
                        arg.unregister();
                    }
                    catch (Exception ex) {
                        throw new GmbalException("Registration exception", ex);
                    }
                }
            }
        };

        private RootParentListener() {
        }

        private void traverse(MBeanImpl mb, UnaryVoidFunction<MBeanImpl> pre, UnaryVoidFunction<MBeanImpl> post) {
            if (pre != null) {
                pre.evaluate(mb);
            }
            for (Map<String, MBeanImpl> nameToMBean : mb.children().values()) {
                for (MBeanImpl child : nameToMBean.values()) {
                    this.traverse(child, pre, post);
                }
            }
            if (post != null) {
                post.evaluate(mb);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mbeanRegistered(ObjectName arg0, MBeanListener arg1) {
            Object object = JMXRegistrationManager.this.lock;
            synchronized (object) {
                if (!JMXRegistrationManager.this.isJMXRegistrationEnabled) {
                    JMXRegistrationManager.this.isJMXRegistrationEnabled = true;
                    if (JMXRegistrationManager.this.root != null) {
                        this.traverse(JMXRegistrationManager.this.root, this.REGISTER_FUNC, null);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mbeanUnregistered(ObjectName arg0, MBeanListener arg1) {
            Object object = JMXRegistrationManager.this.lock;
            synchronized (object) {
                if (JMXRegistrationManager.this.isJMXRegistrationEnabled) {
                    JMXRegistrationManager.this.isJMXRegistrationEnabled = false;
                    if (JMXRegistrationManager.this.root != null) {
                        this.traverse(JMXRegistrationManager.this.root, null, this.UNREGISTER_FUNC);
                    }
                }
            }
        }
    }
}

