/*
 * Decompiled with CFR 0.152.
 */
package com.sun.servicetag;

import com.sun.servicetag.Installer;
import com.sun.servicetag.Util;
import java.io.IOException;
import java.util.Date;

public class ServiceTag {
    private String instanceURN;
    private String productName;
    private String productVersion;
    private String productURN;
    private String productParent;
    private String productParentURN;
    private String productDefinedInstanceID;
    private String productVendor;
    private String platformArch;
    private String container;
    private String source;
    private int installerUID;
    private Date timestamp;
    private final int MAX_URN_LEN = 255;
    private final int MAX_PRODUCT_NAME_LEN = 255;
    private final int MAX_PRODUCT_VERSION_LEN = 63;
    private final int MAX_PRODUCT_PARENT_LEN = 255;
    private final int MAX_PRODUCT_VENDOR_LEN = 63;
    private final int MAX_PLATFORM_ARCH_LEN = 63;
    private final int MAX_CONTAINER_LEN = 63;
    private final int MAX_SOURCE_LEN = 63;

    private ServiceTag() {
    }

    ServiceTag(String instanceURN, String productName, String productVersion, String productURN, String productParent, String productParentURN, String productDefinedInstanceID, String productVendor, String platformArch, String container, String source, int installerUID, Date timestamp) {
        this.setInstanceURN(instanceURN);
        this.setProductName(productName);
        this.setProductVersion(productVersion);
        this.setProductURN(productURN);
        this.setProductParentURN(productParentURN);
        this.setProductParent(productParent);
        this.setProductDefinedInstanceID(productDefinedInstanceID);
        this.setProductVendor(productVendor);
        this.setPlatformArch(platformArch);
        this.setContainer(container);
        this.setSource(source);
        this.setInstallerUID(installerUID);
        this.setTimestamp(timestamp);
    }

    public static ServiceTag newInstance(String productName, String productVersion, String productURN, String productParent, String productParentURN, String productDefinedInstanceID, String productVendor, String platformArch, String container, String source) {
        return new ServiceTag("", productName, productVersion, productURN, productParent, productParentURN, productDefinedInstanceID, productVendor, platformArch, container, source, -1, null);
    }

    public static ServiceTag newInstance(String instanceURN, String productName, String productVersion, String productURN, String productParent, String productParentURN, String productDefinedInstanceID, String productVendor, String platformArch, String container, String source) {
        return new ServiceTag(instanceURN, productName, productVersion, productURN, productParent, productParentURN, productDefinedInstanceID, productVendor, platformArch, container, source, -1, null);
    }

    static ServiceTag newInstanceWithUrnTimestamp(ServiceTag st) {
        String instanceURN = st.getInstanceURN().length() == 0 ? Util.generateURN() : st.getInstanceURN();
        ServiceTag svcTag = new ServiceTag(instanceURN, st.getProductName(), st.getProductVersion(), st.getProductURN(), st.getProductParent(), st.getProductParentURN(), st.getProductDefinedInstanceID(), st.getProductVendor(), st.getPlatformArch(), st.getContainer(), st.getSource(), st.getInstallerUID(), new Date());
        return svcTag;
    }

    public static String generateInstanceURN() {
        return Util.generateURN();
    }

    public String getInstanceURN() {
        return this.instanceURN;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getProductURN() {
        return this.productURN;
    }

    public String getProductParentURN() {
        return this.productParentURN;
    }

    public String getProductParent() {
        return this.productParent;
    }

    public String getProductDefinedInstanceID() {
        return this.productDefinedInstanceID;
    }

    public String getProductVendor() {
        return this.productVendor;
    }

    public String getPlatformArch() {
        return this.platformArch;
    }

    public Date getTimestamp() {
        if (this.timestamp != null) {
            return (Date)this.timestamp.clone();
        }
        return null;
    }

    public String getContainer() {
        return this.container;
    }

    public String getSource() {
        return this.source;
    }

    public int getInstallerUID() {
        return this.installerUID;
    }

    private void setInstanceURN(String instanceURN) {
        if (instanceURN == null) {
            throw new NullPointerException("Parameter instanceURN cannot be null");
        }
        if (instanceURN.length() > 255) {
            throw new IllegalArgumentException("instanceURN \"" + instanceURN + "\" exceeds maximum length " + 255);
        }
        this.instanceURN = instanceURN;
    }

    private void setProductName(String productName) {
        if (productName == null) {
            throw new NullPointerException("Parameter productName cannot be null");
        }
        if (productName.length() == 0) {
            throw new IllegalArgumentException("product name cannot be empty");
        }
        if (productName.length() > 255) {
            throw new IllegalArgumentException("productName \"" + productName + "\" exceeds maximum length " + 255);
        }
        this.productName = productName;
    }

    private void setProductVersion(String productVersion) {
        if (productVersion == null) {
            throw new NullPointerException("Parameter productVersion cannot be null");
        }
        if (productVersion.length() == 0) {
            throw new IllegalArgumentException("product version cannot be empty");
        }
        if (productVersion.length() > 63) {
            throw new IllegalArgumentException("productVersion \"" + productVersion + "\" exceeds maximum length " + 63);
        }
        this.productVersion = productVersion;
    }

    private void setProductURN(String productURN) {
        if (productURN == null) {
            throw new NullPointerException("Parameter productURN cannot be null");
        }
        if (productURN.length() == 0) {
            throw new IllegalArgumentException("product URN cannot be empty");
        }
        if (productURN.length() > 255) {
            throw new IllegalArgumentException("productURN \"" + productURN + "\" exceeds maximum length " + 255);
        }
        this.productURN = productURN;
    }

    private void setProductParentURN(String productParentURN) {
        if (productParentURN == null) {
            throw new NullPointerException("Parameter productParentURN cannot be null");
        }
        if (productParentURN.length() > 255) {
            throw new IllegalArgumentException("productParentURN \"" + productParentURN + "\" exceeds maximum length " + 255);
        }
        this.productParentURN = productParentURN;
    }

    private void setProductParent(String productParent) {
        if (productParent == null) {
            throw new NullPointerException("Parameter productParent cannot be null");
        }
        if (productParent.length() == 0) {
            throw new IllegalArgumentException("product parent cannot be empty");
        }
        if (productParent.length() > 255) {
            throw new IllegalArgumentException("productParent \"" + productParent + "\" exceeds maximum length " + 255);
        }
        this.productParent = productParent;
    }

    void setProductDefinedInstanceID(String productDefinedInstanceID) {
        if (productDefinedInstanceID == null) {
            throw new NullPointerException("Parameter productDefinedInstanceID cannot be null");
        }
        if (productDefinedInstanceID.length() > 255) {
            throw new IllegalArgumentException("productDefinedInstanceID \"" + productDefinedInstanceID + "\" exceeds maximum length " + 255);
        }
        this.productDefinedInstanceID = productDefinedInstanceID;
    }

    private void setProductVendor(String productVendor) {
        if (productVendor == null) {
            throw new NullPointerException("Parameter productVendor cannot be null");
        }
        if (productVendor.length() == 0) {
            throw new IllegalArgumentException("product vendor cannot be empty");
        }
        if (productVendor.length() > 63) {
            throw new IllegalArgumentException("productVendor \"" + productVendor + "\" exceeds maximum length " + 63);
        }
        this.productVendor = productVendor;
    }

    private void setPlatformArch(String platformArch) {
        if (platformArch == null) {
            throw new NullPointerException("Parameter platformArch cannot be null");
        }
        if (platformArch.length() == 0) {
            throw new IllegalArgumentException("platform architecture cannot be empty");
        }
        if (platformArch.length() > 63) {
            throw new IllegalArgumentException("platformArch \"" + platformArch + "\" exceeds maximum length " + 63);
        }
        this.platformArch = platformArch;
    }

    private void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    private void setContainer(String container) {
        if (container == null) {
            throw new NullPointerException("Parameter container cannot be null");
        }
        if (container.length() == 0) {
            throw new IllegalArgumentException("container cannot be empty");
        }
        if (container.length() > 63) {
            throw new IllegalArgumentException("container \"" + container + "\" exceeds maximum length " + 63);
        }
        this.container = container;
    }

    private void setSource(String source) {
        if (source == null) {
            throw new NullPointerException("Parameter source cannot be null");
        }
        if (source.length() == 0) {
            throw new IllegalArgumentException("source cannot be empty");
        }
        if (source.length() > 63) {
            throw new IllegalArgumentException("source \"" + source + "\" exceeds maximum length " + 63);
        }
        this.source = source;
    }

    private void setInstallerUID(int installerUID) {
        this.installerUID = installerUID;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ServiceTag)) {
            return false;
        }
        ServiceTag st = (ServiceTag)obj;
        if (st == this) {
            return true;
        }
        return st.getInstanceURN().equals(this.getInstanceURN());
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (this.instanceURN != null ? this.instanceURN.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("instance_urn").append("=").append(this.instanceURN).append("\n");
        sb.append("product_name").append("=").append(this.productName).append("\n");
        sb.append("product_version").append("=").append(this.productVersion).append("\n");
        sb.append("product_urn").append("=").append(this.productURN).append("\n");
        sb.append("product_parent_urn").append("=").append(this.productParentURN).append("\n");
        sb.append("product_parent").append("=").append(this.productParent).append("\n");
        sb.append("product_defined_inst_id").append("=").append(this.productDefinedInstanceID).append("\n");
        sb.append("product_vendor").append("=").append(this.productVendor).append("\n");
        sb.append("platform_arch").append("=").append(this.platformArch).append("\n");
        sb.append("timestamp").append("=").append(Util.formatTimestamp(this.timestamp)).append("\n");
        sb.append("container").append("=").append(this.container).append("\n");
        sb.append("source").append("=").append(this.source).append("\n");
        sb.append("installer_uid").append("=").append(String.valueOf(this.installerUID)).append("\n");
        return sb.toString();
    }

    public static ServiceTag getJavaServiceTag(String source) throws IOException {
        return Installer.getJavaServiceTag(source);
    }
}

