/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CLIEntityResolver;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import com.sun.enterprise.cli.framework.ValidCommand;
import com.sun.enterprise.cli.framework.ValidCommandsList;
import com.sun.enterprise.cli.framework.ValidOption;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CLIDescriptorsReader {
    public static final int DONT_SERIALIZE = 0;
    public static final int SERIALIZE_COMMANDS_TO_FILES = 1;
    public static final int SERIALIZE_COMMANDS_TO_FILE = 2;
    public static final String SERIALIZED_DESCRIPTOR_FILE = ".CLIDescriptors";
    public static final String SERIALIZED_COMMANDS_DEFAULT_DIR = "cli";
    public static final String ENVIRONMENT_PREFIX = "environment-prefix";
    public static final String ENVIRONMENT_FILENAME = "environment-filename";
    private static CLIDescriptorsReader cliDescriptorsReader;
    private String serializeDir = "cli";
    private int serializeDescriptors = 0;
    private ValidCommandsList commandsList = null;
    private HashMap<String, ValidOption> validOptions = null;
    private HashMap<String, ValidOption> replaceOptions = null;
    private Vector<URL> descriptors = null;
    private Vector<Properties> properties = null;
    private String defaultCommand = null;
    private String helpClass = null;
    private static final String DESCRIPTOR_FILE_NAME = "CLIDescriptor.xml";

    private CLIDescriptorsReader() {
        this.initialize();
    }

    private CLIDescriptorsReader(URL descriptor) {
        this.setDescriptor(descriptor);
        this.initialize();
    }

    private CLIDescriptorsReader(Vector<URL> descriptors) {
        this.descriptors = descriptors;
        this.initialize();
    }

    private void initialize() {
        this.commandsList = new ValidCommandsList();
        this.validOptions = new HashMap();
        this.replaceOptions = new HashMap();
        this.properties = new Vector();
    }

    public static synchronized CLIDescriptorsReader getInstance() {
        if (cliDescriptorsReader == null) {
            cliDescriptorsReader = new CLIDescriptorsReader();
        }
        return cliDescriptorsReader;
    }

    public ValidCommand getCommand(String commandName) throws CommandValidationException {
        ValidCommand command = null;
        command = this.commandsList == null || this.commandsList.size() == 0 ? this.getCommandFromFileOrDescriptor(commandName) : this.commandsList.getValidCommand(commandName);
        return command;
    }

    public String getDefaultCommand() {
        return this.defaultCommand;
    }

    public String getHelpClass() {
        return this.helpClass;
    }

    public ValidCommandsList getCommandsList() throws CommandValidationException {
        if (this.commandsList == null || this.commandsList.size() == 0) {
            this.loadAllCommandsFromFilesOrDescriptors();
        }
        return this.commandsList;
    }

    public Iterator<Properties> getProperties() throws CommandValidationException {
        return this.properties.iterator();
    }

    private ValidCommand getCommandFromFileOrDescriptor(String commandName) throws CommandValidationException {
        ValidCommand command = null;
        if (this.serializeDescriptors == 1 && (command = this.getSerializedCommand(commandName)) != null) {
            return command;
        }
        int saveSerializedDescriptor = this.getSerializeDescriptorsProperty();
        this.setSerializeDescriptorsProperty(0);
        this.loadAllCommandsFromFilesOrDescriptors();
        this.setSerializeDescriptorsProperty(saveSerializedDescriptor);
        if (commandName != null) {
            return this.commandsList.getValidCommand(commandName);
        }
        if (this.defaultCommand != null) {
            return this.commandsList.getValidCommand(this.defaultCommand);
        }
        throw new CommandValidationException(LocalStringsManagerFactory.getFrameworkLocalStringsManager().getString("CommandNotSpecified", null));
    }

    private ValidCommand getSerializedCommand(String commandName) throws CommandValidationException {
        ValidCommand command = null;
        String encodedCommandName = null;
        try {
            encodedCommandName = URLEncoder.encode(commandName, "UTF-8");
        }
        catch (UnsupportedEncodingException ue) {
            encodedCommandName = commandName;
        }
        InputStream in = CLIDescriptorsReader.class.getClassLoader().getResourceAsStream(this.serializeDir + "/." + encodedCommandName);
        if (in == null) {
            return null;
        }
        command = this.getSerializedCommand(in);
        return command;
    }

    private ValidCommand getSerializedCommand(InputStream commandFile) throws CommandValidationException {
        try {
            ValidCommand command = null;
            ObjectInputStream in = new ObjectInputStream(commandFile);
            this.defaultCommand = (String)in.readObject();
            this.helpClass = (String)in.readObject();
            this.properties = (Vector)in.readObject();
            command = (ValidCommand)in.readObject();
            CLILogger.getInstance().printDebugMessage("++++++++++++++++++++++++++++ Command loaded from file and it is " + command);
            return command;
        }
        catch (Exception e) {
            throw new CommandValidationException(e);
        }
    }

    private void loadAllCommandsFromFilesOrDescriptors() throws CommandValidationException {
        if (this.serializeDescriptors == 0) {
            this.readDescriptors();
        } else if (this.serializeDescriptors == 1) {
            this.loadCommandsFromMultipleFiles();
        } else if (this.serializeDescriptors == 2) {
            this.loadCommandsFromSingleFile();
        }
    }

    private void loadCommandsFromMultipleFiles() throws CommandValidationException {
        this.readDescriptors();
    }

    private void loadCommandsFromSingleFile() throws CommandValidationException {
        Vector<URL> serializedDescriptorFile = this.getSerializedDescriptorFile();
        if (serializedDescriptorFile.size() > 0) {
            this.loadSerializedDescriptorFile(serializedDescriptorFile);
        } else {
            this.readDescriptors();
        }
    }

    public void readDescriptors() throws CommandValidationException {
        this.commandsList.removeAllCommands();
        try {
            DOMParser parser = new DOMParser();
            parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", true);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
            parser.setEntityResolver(new CLIEntityResolver());
            if (this.descriptors == null) {
                this.getDescriptors();
                if (this.descriptors == null) {
                    LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
                    throw new CommandValidationException(lsm.getString("NoDescriptorsDefined"));
                }
            }
            for (int i = 0; i < this.descriptors.size(); ++i) {
                CLILogger.getInstance().printDebugMessage(i + " descriptor = " + this.descriptors.get(i));
                URL descriptorURL = this.descriptors.get(i);
                parser.parse(new InputSource(descriptorURL.toString()));
                Document document = parser.getDocument();
                this.generateOptionsAndCommands(document);
            }
            this.replaceOptionsInCommandsList(this.replaceOptions);
            this.validateOptionsInCommand();
            if (this.serializeDescriptors == 1) {
                this.saveCommandsAsMultipleFiles();
            } else if (this.serializeDescriptors == 2) {
                this.saveCommandsAsSingleFile();
            }
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            throw new CommandValidationException(x);
        }
        catch (IOException ioe) {
            throw new CommandValidationException(ioe);
        }
    }

    private String[] getSerializedCommandsFileList(File commandsDir) {
        String[] commandFiles = commandsDir.list(new FilenameFilter(){

            public boolean accept(File parentDir, String name) {
                return name.startsWith(".");
            }
        });
        return commandFiles;
    }

    private Vector<URL> getSerializedDescriptorFile() throws CommandValidationException {
        Vector<URL> descriptorFiles = new Vector<URL>();
        try {
            String sDescriptorFile = this.serializeDir + "/" + SERIALIZED_DESCRIPTOR_FILE;
            Enumeration<URL> urls = CLIDescriptorsReader.class.getClassLoader().getResources(sDescriptorFile);
            if (urls == null || !urls.hasMoreElements()) {
                return descriptorFiles;
            }
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                descriptorFiles.add(url);
            }
        }
        catch (IOException ioe) {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            CLILogger.getInstance().printMessage(lsm.getString("CouldNotLoadDescriptor"));
        }
        return descriptorFiles;
    }

    private boolean loadSerializedCommands() throws CommandValidationException {
        File commandsDir = new File(this.serializeDir);
        String[] commandFiles = this.getSerializedCommandsFileList(commandsDir);
        if (commandsDir == null || !commandsDir.exists() || commandFiles.length <= 0) {
            return false;
        }
        boolean loaded = true;
        for (int i = 0; i < commandFiles.length && loaded; ++i) {
            InputStream in = CLIDescriptorsReader.class.getClassLoader().getResourceAsStream(this.serializeDir + "/." + commandFiles[i]);
            try {
                ValidCommand command = this.getSerializedCommand(in);
                if (command != null) {
                    this.commandsList.addCommand(command);
                    continue;
                }
                loaded = false;
                continue;
            }
            catch (CommandValidationException e) {
                loaded = false;
                break;
            }
        }
        return loaded;
    }

    private void loadSerializedDescriptorFile(Vector<URL> descriptorFile) throws CommandValidationException {
        try {
            for (int ii = 0; ii < descriptorFile.size(); ++ii) {
                URL descriptorURL = descriptorFile.get(ii);
                ObjectInputStream ois = new ObjectInputStream(descriptorURL.openStream());
                this.defaultCommand = (String)ois.readObject();
                this.helpClass = (String)ois.readObject();
                this.properties = (Vector)ois.readObject();
                ValidCommandsList validCommandsList = (ValidCommandsList)ois.readObject();
                if (this.commandsList != null && this.commandsList.size() > 0) {
                    Iterator commands = validCommandsList.getCommands();
                    while (commands.hasNext()) {
                        this.commandsList.addCommand((ValidCommand)commands.next());
                    }
                } else {
                    this.commandsList = validCommandsList;
                }
                CLILogger.getInstance().printDebugMessage("++++++++++++++++++++++++++++ Commands loaded from file");
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new CommandValidationException(fnfe);
        }
        catch (IOException ioe) {
            throw new CommandValidationException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new CommandValidationException(cnfe);
        }
    }

    private Vector getDescriptors() throws CommandValidationException {
        if (this.descriptors != null) {
            return this.descriptors;
        }
        try {
            Enumeration<URL> urls;
            String descriptor_file_name = System.getProperty("DESCRIPTOR_FILE");
            if (descriptor_file_name == null) {
                descriptor_file_name = DESCRIPTOR_FILE_NAME;
            }
            if ((urls = CLIDescriptorsReader.class.getClassLoader().getResources(descriptor_file_name)) == null || !urls.hasMoreElements()) {
                return this.descriptors;
            }
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                this.setDescriptor(url);
            }
        }
        catch (IOException ioe) {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            CLILogger.getInstance().printMessage(lsm.getString("CouldNotLoadDescriptor"));
        }
        return this.descriptors;
    }

    public void setDescriptor(URL descriptor) {
        if (descriptor != null) {
            if (this.descriptors == null) {
                this.descriptors = new Vector();
            }
            this.descriptors.add(descriptor);
            Collections.reverse(this.descriptors);
        }
    }

    public void setDescriptors(Vector<URL> descriptors) {
        this.descriptors = descriptors;
    }

    private void generateOptionsAndCommands(Document document) throws CommandValidationException {
        if (document != null) {
            for (Node nextKid = document.getDocumentElement().getFirstChild(); nextKid != null; nextKid = nextKid.getNextSibling()) {
                String grandKidNodeName;
                Node grandKid;
                String nodeName = nextKid.getNodeName();
                if (nodeName.equalsIgnoreCase("CommandProperties")) {
                    Properties props = new Properties();
                    for (Node grandKid2 = nextKid.getFirstChild(); grandKid2 != null; grandKid2 = grandKid2.getNextSibling()) {
                        String grandKidNodeName2 = grandKid2.getNodeName();
                        if (!grandKidNodeName2.equalsIgnoreCase("CommandProperty")) continue;
                        NamedNodeMap nodeMap = grandKid2.getAttributes();
                        String nameAttr = nodeMap.getNamedItem("name").getNodeValue();
                        String valueAttr = nodeMap.getNamedItem("value").getNodeValue();
                        props.setProperty(nameAttr, valueAttr);
                    }
                    NamedNodeMap commandPropertiesAttribute = nextKid.getAttributes();
                    if (commandPropertiesAttribute != null && commandPropertiesAttribute.getNamedItem("defaultcommand") != null) {
                        this.defaultCommand = commandPropertiesAttribute.getNamedItem("defaultcommand").getNodeValue();
                    }
                    if (commandPropertiesAttribute != null && commandPropertiesAttribute.getNamedItem("helpclass") != null) {
                        this.helpClass = commandPropertiesAttribute.getNamedItem("helpclass").getNodeValue();
                    }
                    this.properties.add(props);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("Options")) {
                    for (grandKid = nextKid.getFirstChild(); grandKid != null; grandKid = grandKid.getNextSibling()) {
                        ValidOption option;
                        grandKidNodeName = grandKid.getNodeName();
                        if (grandKidNodeName.equalsIgnoreCase("Option")) {
                            option = this.generateOption(document, grandKid);
                            String optionName = option.getName();
                            if (!this.validOptions.containsKey(optionName)) {
                                this.validOptions.put(optionName, option);
                                continue;
                            }
                            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
                            throw new CommandValidationException(lsm.getString("DuplicateOptionDeclaration", new Object[]{optionName}));
                        }
                        if (!grandKidNodeName.equalsIgnoreCase("ReplaceOption")) continue;
                        option = this.generateOption(document, grandKid);
                        this.replaceOptions.put(option.getName(), option);
                    }
                    continue;
                }
                if (!nodeName.equalsIgnoreCase("Commands")) continue;
                for (grandKid = nextKid.getFirstChild(); grandKid != null; grandKid = grandKid.getNextSibling()) {
                    grandKidNodeName = grandKid.getNodeName();
                    if (!grandKidNodeName.equalsIgnoreCase("Command")) continue;
                    ValidCommand command = this.generateCommand(document, grandKid);
                    this.commandsList.addCommand(command);
                }
            }
        }
    }

    private ValidOption generateOption(Document document, Node grandKid) {
        ValidOption option = new ValidOption();
        NamedNodeMap nodeMap = grandKid.getAttributes();
        String nameAttr = nodeMap.getNamedItem("name").getNodeValue();
        String typeAttr = nodeMap.getNamedItem("type").getNodeValue();
        boolean valueReqdAttr = Boolean.valueOf(nodeMap.getNamedItem("value-required").getNodeValue());
        Node defaultAttrNode = nodeMap.getNamedItem("default");
        String defaultAttr = null;
        if (defaultAttrNode != null) {
            defaultAttr = defaultAttrNode.getNodeValue();
        }
        option.setName(nameAttr);
        option.setType(typeAttr);
        option.setRequired(valueReqdAttr ? 1 : 2);
        option.setDefaultValue(defaultAttr);
        for (Node nextGrandKid = grandKid.getFirstChild(); nextGrandKid != null; nextGrandKid = nextGrandKid.getNextSibling()) {
            String grandKidName = nextGrandKid.getNodeName();
            if (!grandKidName.equalsIgnoreCase("shortoption")) continue;
            String shortOption = nextGrandKid.getFirstChild().getNodeValue();
            if ((shortOption = shortOption.trim()) == null) continue;
            option.setShortName(shortOption);
        }
        return option;
    }

    private ValidCommand generateCommand(Document document, Node grandKid) throws CommandValidationException {
        ValidCommand command = new ValidCommand();
        NamedNodeMap nodeMap = grandKid.getAttributes();
        String nameAttr = nodeMap.getNamedItem("name").getNodeValue();
        String classNameAttr = nodeMap.getNamedItem("classname").getNodeValue();
        String numberOfOperandsAttr = nodeMap.getNamedItem("numberofoperands").getNodeValue();
        String defaultOperandAttr = null;
        if (nodeMap.getNamedItem("defaultoperand") != null) {
            defaultOperandAttr = nodeMap.getNamedItem("defaultoperand").getNodeValue();
        }
        Node usageTextNode = nodeMap.getNamedItem("usage-text");
        String usageTextAttr = null;
        if (usageTextNode != null) {
            usageTextAttr = usageTextNode.getNodeValue();
        }
        command.setName(nameAttr);
        command.setNumberOfOperands(numberOfOperandsAttr);
        command.setDefaultOperand(defaultOperandAttr);
        command.setClassName(classNameAttr);
        command.setUsageText(usageTextAttr);
        for (Node nextGrandKid = grandKid.getFirstChild(); nextGrandKid != null; nextGrandKid = nextGrandKid.getNextSibling()) {
            String deprecatedOption;
            String grandKidName = nextGrandKid.getNodeName();
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            if (grandKidName.equalsIgnoreCase("ValidOption")) {
                ValidOption option;
                NamedNodeMap validOptionNodeMap = nextGrandKid.getAttributes();
                String validOption = validOptionNodeMap.getNamedItem("name").getNodeValue();
                if (command.hasValidOption(validOption)) {
                    throw new CommandValidationException(lsm.getString("OptionAlreadyDefined", new Object[]{validOption, command.getName()}));
                }
                deprecatedOption = null;
                if (validOptionNodeMap.getNamedItem("deprecatedoption") != null) {
                    deprecatedOption = validOptionNodeMap.getNamedItem("deprecatedoption").getNodeValue();
                }
                String defaultValue = null;
                if (validOptionNodeMap.getNamedItem("defaultvalue") != null) {
                    defaultValue = validOptionNodeMap.getNamedItem("defaultvalue").getNodeValue();
                }
                if ((option = this.findOption(validOption)) == null) {
                    throw new CommandValidationException(lsm.getString("ValidOptionNotDefined", new Object[]{validOption}));
                }
                ValidOption newOption = new ValidOption(option);
                if (deprecatedOption != null) {
                    newOption.setDeprecatedOption(deprecatedOption);
                }
                if (defaultValue != null) {
                    newOption.setDefaultValue(defaultValue);
                }
                command.addValidOption(newOption);
                continue;
            }
            if (grandKidName.equalsIgnoreCase("RequiredOption")) {
                ValidOption option;
                NamedNodeMap reqdOptionNodeMap = nextGrandKid.getAttributes();
                String reqdOption = reqdOptionNodeMap.getNamedItem("name").getNodeValue();
                if (command.hasRequiredOption(reqdOption)) {
                    throw new CommandValidationException(lsm.getString("OptionAlreadyDefined", new Object[]{reqdOption, command.getName()}));
                }
                deprecatedOption = null;
                if (reqdOptionNodeMap.getNamedItem("deprecatedoption") != null) {
                    deprecatedOption = reqdOptionNodeMap.getNamedItem("deprecatedoption").getNodeValue();
                }
                if ((option = this.findOption(reqdOption)) == null) {
                    throw new CommandValidationException(lsm.getString("RequiredOptionNotDefined", new Object[]{reqdOption}));
                }
                if (deprecatedOption != null) {
                    option.setDeprecatedOption(deprecatedOption);
                }
                command.addRequiredOption(new ValidOption(option));
                continue;
            }
            if (grandKidName.equalsIgnoreCase("DeprecatedOption")) {
                String deprecatedOption2 = nextGrandKid.getFirstChild().getNodeValue();
                if (command.hasDeprecatedOption(deprecatedOption2)) {
                    throw new CommandValidationException(lsm.getString("OptionAlreadyDefined", new Object[]{deprecatedOption2, command.getName()}));
                }
                ValidOption option = this.findOption(deprecatedOption2);
                if (option == null) {
                    throw new CommandValidationException(lsm.getString("DeprecatedOptionNotDefined", new Object[]{deprecatedOption2}));
                }
                command.addDeprecatedOption(option);
                continue;
            }
            if (!grandKidName.equalsIgnoreCase("properties")) continue;
            for (Node nextGreatGrandKid = nextGrandKid.getFirstChild(); nextGreatGrandKid != null; nextGreatGrandKid = nextGreatGrandKid.getNextSibling()) {
                String greatGrandKidName = nextGreatGrandKid.getNodeName();
                if (!greatGrandKidName.equalsIgnoreCase("property")) continue;
                nodeMap = nextGreatGrandKid.getAttributes();
                String propertyNameAttr = nodeMap.getNamedItem("name").getNodeValue();
                Vector<String> values = new Vector<String>();
                for (Node nextGreatGreatGrandKid = nextGreatGrandKid.getFirstChild(); nextGreatGreatGrandKid != null; nextGreatGreatGrandKid = nextGreatGreatGrandKid.getNextSibling()) {
                    String greatGreatGrandKidName = nextGreatGreatGrandKid.getNodeName();
                    if (!greatGreatGrandKidName.equalsIgnoreCase("value")) continue;
                    String value = null;
                    if (nextGreatGreatGrandKid.getFirstChild() != null) {
                        value = nextGreatGreatGrandKid.getFirstChild().getNodeValue();
                    }
                    values.add(value);
                }
                command.setProperty(propertyNameAttr, values);
            }
        }
        return command;
    }

    private ValidOption findOption(String optionStr) {
        ValidOption option = null;
        option = this.validOptions.get(optionStr);
        return option;
    }

    private void saveCommandsAsMultipleFiles() throws CommandValidationException {
        Iterator commands = this.commandsList.getCommands();
        while (commands.hasNext()) {
            try {
                ValidCommand command = (ValidCommand)commands.next();
                File file = new File(this.serializeDir);
                if (!file.exists()) {
                    file.mkdir();
                }
                String encodedCommandName = null;
                try {
                    encodedCommandName = URLEncoder.encode(command.getName(), "UTF-8");
                }
                catch (UnsupportedEncodingException ue) {
                    encodedCommandName = command.getName();
                }
                ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(this.serializeDir + "/." + encodedCommandName));
                os.writeObject(this.defaultCommand);
                os.writeObject(this.helpClass);
                os.writeObject(this.properties);
                os.writeObject(command);
            }
            catch (Exception e) {
                LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
                CLILogger.getInstance().printWarning(lsm.getString("CouldNotWriteCommandToFile", new Object[]{e.getMessage()}));
            }
        }
    }

    private void saveCommandsAsSingleFile() throws CommandValidationException {
        try {
            ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(this.serializeDir + "/" + SERIALIZED_DESCRIPTOR_FILE));
            os.writeObject(this.defaultCommand);
            os.writeObject(this.helpClass);
            os.writeObject(this.properties);
            os.writeObject(this.commandsList);
        }
        catch (Exception e) {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            CLILogger.getInstance().printWarning(lsm.getString("CouldNotWriteComponentToFile", new Object[]{e.getMessage()}));
        }
    }

    private int getSerializeDescriptorsProperty() {
        return this.serializeDescriptors;
    }

    public void setSerializeDescriptorsProperty(int serializeDescriptors) {
        if (serializeDescriptors <= 2 && serializeDescriptors >= 0) {
            this.serializeDescriptors = serializeDescriptors;
        }
    }

    public String getSerializeDir() {
        return this.serializeDir;
    }

    private void setSerializeDir(String serializeDir) throws CommandValidationException {
        try {
            File file = new File(serializeDir);
            if (file.exists()) {
                this.serializeDir = serializeDir;
            } else {
                LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
                CLILogger.getInstance().printWarning(lsm.getString("InvalidFilePath", new Object[]{serializeDir}));
            }
        }
        catch (NullPointerException npe) {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            throw new CommandValidationException(lsm.getString("CouldNoSetSerializeDirectory"), npe);
        }
    }

    private void replaceOptionsInCommandsList(HashMap replaceOptions) {
        for (String replaceOptionName : replaceOptions.keySet()) {
            Iterator commands = this.commandsList.getCommands();
            while (commands.hasNext()) {
                ValidCommand command = (ValidCommand)commands.next();
                if (!command.hasValidOption(replaceOptionName) && !command.hasRequiredOption(replaceOptionName) && !command.hasDeprecatedOption(replaceOptionName)) continue;
                command.replaceAllOptions((ValidOption)replaceOptions.get(replaceOptionName));
            }
        }
    }

    private void validateOptionsInCommand() throws CommandValidationException {
        Iterator commands = this.commandsList.getCommands();
        while (commands.hasNext()) {
            ValidCommand command = (ValidCommand)commands.next();
            Vector vvo = command.getOptions();
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            int ii = 1;
            int size = vvo.size();
            for (ValidOption vo : vvo) {
                String optionName = vo.getName();
                if (ii < size) {
                    List sub_vvo = vvo.subList(ii, size);
                    for (ValidOption sub_vo : sub_vvo) {
                        if (optionName.equals(sub_vo.getName())) {
                            throw new CommandValidationException(lsm.getString("OptionAlreadyDefined", new Object[]{optionName, command.getName()}));
                        }
                        if (!vo.hasShortName()) continue;
                        Vector<String> shortNames = vo.getShortNames();
                        for (String shortName : shortNames) {
                            Vector<String> sub_shortNames = sub_vo.getShortNames();
                            if (!sub_shortNames.contains(shortName)) continue;
                            throw new CommandValidationException(lsm.getString("ShortOptionAlreadyDefined", new Object[]{shortName, vo.getName(), sub_vo.getName(), command.getName()}));
                        }
                    }
                }
                ++ii;
            }
        }
    }

    public String getEnvironmentPrefix() {
        if (this.properties != null) {
            for (int i = 0; i < this.properties.size(); ++i) {
                Properties props = this.properties.get(i);
                String prefix = props.getProperty(ENVIRONMENT_PREFIX);
                if (prefix == null) continue;
                return prefix;
            }
        }
        return null;
    }

    public String getEnvironmentFileName() {
        if (this.properties != null) {
            for (int i = 0; i < this.properties.size(); ++i) {
                Properties props = this.properties.get(i);
                String file = props.getProperty(ENVIRONMENT_FILENAME);
                if (file == null) continue;
                return file;
            }
        }
        return ".cliprefs";
    }

    public static void main(String[] args) {
        try {
            CLIDescriptorsReader cliDescriptorsReader = CLIDescriptorsReader.getInstance();
            String SERIALIZE_TYPE = System.getProperty("SERIALIZE_TYPE");
            if (SERIALIZE_TYPE == null) {
                cliDescriptorsReader.setSerializeDescriptorsProperty(1);
            } else {
                if (SERIALIZE_TYPE.equals("SINGLE_FILE")) {
                    cliDescriptorsReader.setSerializeDescriptorsProperty(2);
                }
                if (SERIALIZE_TYPE.equals("MULTIPLE_FILES")) {
                    cliDescriptorsReader.setSerializeDescriptorsProperty(1);
                }
                if (SERIALIZE_TYPE.equals("DONT_SERIALIZE")) {
                    cliDescriptorsReader.setSerializeDescriptorsProperty(0);
                }
            }
            cliDescriptorsReader.readDescriptors();
        }
        catch (CommandValidationException cve) {
            System.out.println(cve.getLocalizedMessage());
            System.exit(1);
        }
    }
}

