/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CommandValidationException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalStringsManager {
    private final String packageName;
    private final String propertyFile;
    private final Vector<ResourceBundle> resourceBundles = new Vector();
    public static final String DEFAULT_STRING_VALUE = "Key not found";

    public LocalStringsManager(String packageNameIn, String propertyFileIn) {
        this.packageName = packageNameIn;
        this.propertyFile = propertyFileIn;
        ResourceBundle resourceBundle = ResourceBundle.getBundle(packageNameIn + "." + this.propertyFile);
        this.resourceBundles.add(resourceBundle);
    }

    public LocalStringsManager(Vector<Properties> localizePropertiesList) {
        this.packageName = null;
        this.propertyFile = null;
        for (int i = 0; i < localizePropertiesList.size(); ++i) {
            Properties properties = localizePropertiesList.get(i);
            String packageNameStr = (String)properties.get("base-package");
            String propertyFileStr = (String)properties.get("property-file-name");
            ResourceBundle resourceBundle = ResourceBundle.getBundle(packageNameStr + "." + propertyFileStr);
            this.resourceBundles.add(resourceBundle);
        }
    }

    public LocalStringsManager(Vector<String> localizeStringList, Locale locale) {
        this.packageName = null;
        this.propertyFile = null;
        for (int i = 0; i < localizeStringList.size(); ++i) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(localizeStringList.get(i), locale);
            this.resourceBundles.add(resourceBundle);
        }
    }

    public String getPropertiesFile() {
        return this.propertyFile;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Vector<ResourceBundle> getResourceBundles() {
        return this.resourceBundles;
    }

    public String getString(String key) {
        Iterator<ResourceBundle> resourcesIter = this.resourceBundles.iterator();
        String value = "Key not found (" + key + ")";
        while (resourcesIter.hasNext()) {
            ResourceBundle resourceBundle = resourcesIter.next();
            try {
                value = resourceBundle.getString(key);
                break;
            }
            catch (MissingResourceException mre) {
            }
        }
        return value;
    }

    public String getString(String key, Object[] toInsert) throws CommandValidationException {
        String fmtStr = null;
        try {
            MessageFormat msgFormat = new MessageFormat(this.getString(key));
            fmtStr = msgFormat.format(toInsert);
        }
        catch (Exception e) {
            throw new CommandValidationException(e);
        }
        return fmtStr;
    }
}

