/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmaki.services;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Security;

public class HttpClient {
    private String proxyHost = null;
    private int proxyPort = -1;
    private boolean isHttps = false;
    private boolean isProxy = false;
    private URLConnection urlConnection = null;

    public HttpClient(String url) throws MalformedURLException {
        this.urlConnection = this.getURLConnection(url);
    }

    public HttpClient(String phost, int pport, String url) throws MalformedURLException {
        if (phost != null && pport != -1) {
            this.isProxy = true;
        }
        this.proxyHost = phost;
        this.proxyPort = pport;
        if (url.indexOf("https") >= 0) {
            this.isHttps = true;
        }
        this.urlConnection = this.getURLConnection(url);
        String ua = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; .NET CLR 1.1.4322)";
        this.urlConnection.setRequestProperty("user-agent", ua);
    }

    private URLConnection getURLConnection(String str) throws MalformedURLException {
        try {
            if (this.isHttps) {
                Security.addProvider((java.security.Provider)new Provider());
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                if (this.isProxy) {
                    System.setProperty("https.proxyHost", this.proxyHost);
                    System.setProperty("https.proxyPort", this.proxyPort + "");
                }
            } else if (this.isProxy) {
                System.setProperty("http.proxyHost", this.proxyHost);
                System.setProperty("http.proxyPort", this.proxyPort + "");
            }
            URL url = new URL(str);
            return url.openConnection();
        }
        catch (MalformedURLException me) {
            throw new MalformedURLException(str + " is not a valid URL");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public InputStream getInputStream() {
        try {
            return this.urlConnection.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public OutputStream getOutputStream() {
        try {
            return this.urlConnection.getOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public InputStream doPost(String postData) {
        this.urlConnection.setDoOutput(true);
        OutputStream os = this.getOutputStream();
        PrintStream ps = new PrintStream(os);
        ps.print(postData);
        ps.close();
        return this.getInputStream();
    }

    public String getContentEncoding() {
        if (this.urlConnection == null) {
            return null;
        }
        return this.urlConnection.getContentEncoding();
    }

    public int getContentLength() {
        if (this.urlConnection == null) {
            return -1;
        }
        return this.urlConnection.getContentLength();
    }

    public String getContentType() {
        if (this.urlConnection == null) {
            return null;
        }
        return this.urlConnection.getContentType();
    }

    public long getDate() {
        if (this.urlConnection == null) {
            return -1L;
        }
        return this.urlConnection.getDate();
    }

    public String getHeader(String name) {
        if (this.urlConnection == null) {
            return null;
        }
        return this.urlConnection.getHeaderField(name);
    }

    public long getIfModifiedSince() {
        if (this.urlConnection == null) {
            return -1L;
        }
        return this.urlConnection.getIfModifiedSince();
    }
}

