/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import jmaki.runtime.AjaxContext;
import jmaki.runtime.AjaxException;
import jmaki.runtime.AjaxWriter;
import jmaki.runtime.IOUtil;
import jmaki.runtime.ResourceManager;
import jmaki.runtime.config.ApiKey;
import jmaki.runtime.config.Config;
import jmaki.runtime.config.Extension;
import jmaki.runtime.config.GlobalConfig;
import jmaki.runtime.config.GlueInclude;

public abstract class CommonGlobalRenderer {
    public static void writeBootStrap(AjaxContext ajx, AjaxWriter out) throws IOException {
        String jmakiBootUri;
        String resourcesDir = ajx.getResourceHandler().getResourcesDir();
        String string = jmakiBootUri = ajx.isCompressedScript() ? "/jmaki-min.js" : "/jmaki.js";
        if (ajx.isWriteComments()) {
            out.writeComment("CommonGlobalRenderer.writeBootStrap()");
        }
        out.writeLib(ajx.buildResourceReference(resourcesDir + jmakiBootUri, ajx.getGlobalConfig().isGlobalBootstrapScriptWebAppResource()));
        String clientLocale = "";
        if (ajx.getClientLocale() != null) {
            clientLocale = "jmaki.locale='" + ajx.getClientLocale() + "';";
        }
        out.writeScript("jmaki.webRoot='" + ajx.getGlobalWebRoot() + "';" + "jmaki.resourcesRoot ='" + resourcesDir + "';" + "jmaki.xhp ='" + ajx.getXhpMapping() + "';" + clientLocale + (ajx.getInlineClientErrors() ? "" : "jmaki.displayErrorsInline = false;"));
    }

    public static void writeExtensions(AjaxContext ajx, AjaxWriter out) throws IOException {
        if (ajx.isWriteComments()) {
            out.writeComment("CommonGlobalRenderer.writeExtensions()");
        }
        Iterator extensions = ajx.getGlobalConfig().getExtensions();
        GlobalConfig config = ajx.getGlobalConfig();
        while (extensions.hasNext()) {
            Extension ex = (Extension)extensions.next();
            String name = ex.getName();
            String args = ex.getArgs();
            String url = ex.getURL();
            if (ajx.isExtensionWritten(args == null ? name : name + args) || url == null || !IOUtil.matchURL(ajx.getCurrentURI(), url)) continue;
            CommonGlobalRenderer.writeExtension(ajx, out, name, args, config.getExtensionConfig(name));
            ajx.setExtensionWritten(args == null ? name : name + args);
        }
    }

    public static void writeGlueIncludes(AjaxContext ajx, AjaxWriter out) throws IOException {
        if (ajx.isWriteComments()) {
            out.writeComment("CommonGlobalRenderer.writeGlueIncludes()");
        }
        Iterator glueIncludes = ajx.getGlobalConfig().getGlueIncludes();
        while (glueIncludes.hasNext()) {
            GlueInclude glueInclude = (GlueInclude)glueIncludes.next();
            String glueIncludeLib = null;
            if (!IOUtil.matchURL(ajx.getCurrentURI(), glueInclude.getURL()) || ajx.isLibraryWritten(glueIncludeLib = glueInclude.getLib())) continue;
            out.writeLib(ajx.buildResourceReference(glueIncludeLib));
            ajx.setLibraryWritten(glueIncludeLib);
        }
    }

    public static void writeExtension(AjaxContext ajx, AjaxWriter out, String extensionName, String args, Config config) throws IOException, AjaxException {
        ResourceManager resourceManager;
        String extensionDir;
        String extensionLib;
        if (ajx.isWriteComments()) {
            out.writeComment("CommonGlobalRenderer.writeExtension(" + extensionName + "," + args + ")");
        }
        if (config != null) {
            CommonGlobalRenderer.writeTypeResources(ajx, out, config, null);
        }
        if (!ajx.isLibraryWritten(extensionLib = (extensionDir = ajx.buildResourceReference((resourceManager = ajx.getResourceHandler()).getResourcesDir() + resourceManager.getExtensionDir(extensionName))) + "/extension.js")) {
            out.writeLib(extensionLib);
            ajx.setLibraryWritten(extensionLib);
        }
        if (args == null) {
            out.writeScript("jmaki.addExtension({name : '" + extensionName + "', extensionDir : '" + extensionDir + "'});");
        } else {
            out.writeScript("jmaki.addExtension({name : '" + extensionName + "', extensionDir : '" + extensionDir + "', args : " + args + "});");
        }
    }

    public static void writeTypeLibs(AjaxContext ajx, AjaxWriter out, Config config, String uuid) throws IOException {
        String preload = null;
        preload = config.getPreLoad();
        if (preload != null) {
            out.writeScript(preload);
        }
        Iterator libs = config.getLibs();
        while (libs.hasNext()) {
            String lib = (String)libs.next();
            Iterator apiKeys = config.getApiKeys();
            while (apiKeys.hasNext()) {
                ApiKey apiKey = (ApiKey)apiKeys.next();
                String targetURL = apiKey.getUrl();
                if ((targetURL == null || !targetURL.equals(ajx.getWebRoot() + "/")) && !targetURL.equals(ajx.getGlobalWebRoot() + "/") && !targetURL.equals("*")) continue;
                lib = lib + apiKey.getKey();
                break;
            }
            if (ajx.isLibraryWritten(lib)) continue;
            if (config.isDynamicallyLoadable()) {
                out.writeLib(ajx.buildResourceReference(lib));
            } else {
                out.writeScript("jmaki.writeScript('" + ajx.buildResourceReference(lib) + "', '" + uuid + "');");
            }
            ajx.setLibraryWritten(lib);
        }
        String postload = null;
        postload = config.getPostLoad();
        if (postload != null) {
            out.writeScript(postload);
        }
    }

    public static void writeTypeStyles(AjaxContext ajx, AjaxWriter out, Config config) throws IOException {
        if (config.getThemes() != null) {
            Map themes = config.getThemes();
            String key = config.getGlobalTheme();
            String defaultTheme = config.getDefaultTheme();
            String theme = null;
            if (themes.get(key) != null) {
                theme = (String)themes.get(key);
            } else if (defaultTheme != null) {
                theme = (String)themes.get(defaultTheme);
            }
            if (theme != null && !ajx.isStyleWritten(theme)) {
                String style = ajx.buildResourceReference(theme);
                if (ajx.getCombineStyles() && ajx.getCombinedResourceManager() != null) {
                    ajx.getCombinedResourceManager().addStyleLink(style);
                } else {
                    out.writeStyle(style);
                }
                ajx.setStyleWritten(theme);
            }
        }
        Iterator styles = config.getStyles();
        while (styles.hasNext()) {
            String style = (String)styles.next();
            if (ajx.isStyleWritten(style)) continue;
            String styleURL = ajx.buildResourceReference(style);
            if (ajx.getCombineStyles() && ajx.getCombinedResourceManager() != null) {
                ajx.getCombinedResourceManager().addStyleLink(styleURL);
            } else {
                out.writeStyle(styleURL);
            }
            ajx.setStyleWritten(style);
        }
    }

    public static void writeTypeResources(AjaxContext ajx, AjaxWriter out, Config config, String uuid) throws IOException {
        String resourceId = config.getId();
        if (resourceId != null && !ajx.isTypeWritten(resourceId)) {
            CommonGlobalRenderer.writeTypeLibs(ajx, out, config, uuid);
            CommonGlobalRenderer.writeTypeStyles(ajx, out, config);
            ajx.setTypeWritten(resourceId);
        }
    }
}

