/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.listener;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.email.EmailAddress;
import org.apache.tools.ant.taskdefs.email.Mailer;
import org.apache.tools.ant.taskdefs.email.Message;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.mail.MailMessage;

public class MailLogger
extends DefaultLogger {
    private StringBuffer buffer = new StringBuffer();
    static /* synthetic */ Class class$org$apache$tools$ant$listener$MailLogger;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$email$Mailer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished(BuildEvent event) {
        super.buildFinished(event);
        Project project = event.getProject();
        Hashtable properties = project.getProperties();
        Properties fileProperties = new Properties();
        String filename = (String)properties.get("MailLogger.properties.file");
        if (filename != null) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(filename);
                fileProperties.load(is);
            }
            catch (IOException ioe) {
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        Enumeration<Object> e = fileProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = fileProperties.getProperty(key);
            properties.put(key, project.replaceProperties(value));
        }
        boolean success = event.getException() == null;
        String prefix = success ? "success" : "failure";
        try {
            boolean notify = Project.toBoolean(this.getValue(properties, prefix + ".notify", "on"));
            if (!notify) {
                return;
            }
            String mailhost = this.getValue(properties, "mailhost", "localhost");
            int port = Integer.parseInt(this.getValue(properties, "port", String.valueOf(25)));
            String user = this.getValue(properties, "user", "");
            String password = this.getValue(properties, "password", "");
            boolean ssl = Project.toBoolean(this.getValue(properties, "ssl", "off"));
            String from = this.getValue(properties, "from", null);
            String replytoList = this.getValue(properties, "replyto", "");
            String toList = this.getValue(properties, prefix + ".to", null);
            String subject = this.getValue(properties, prefix + ".subject", success ? "Build Success" : "Build Failure");
            if (user.equals("") && password.equals("") && !ssl) {
                this.sendMail(mailhost, port, from, replytoList, toList, subject, this.buffer.substring(0));
            } else {
                this.sendMimeMail(event.getProject(), mailhost, port, user, password, ssl, from, replytoList, toList, subject, this.buffer.substring(0));
            }
        }
        catch (Exception e2) {
            System.out.println("MailLogger failed to send e-mail!");
            e2.printStackTrace(System.err);
        }
    }

    protected void log(String message) {
        this.buffer.append(message).append(StringUtils.LINE_SEP);
    }

    private String getValue(Hashtable properties, String name, String defaultValue) throws Exception {
        String propertyName = "MailLogger." + name;
        String value = (String)properties.get(propertyName);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            throw new Exception("Missing required parameter: " + propertyName);
        }
        return value;
    }

    private void sendMail(String mailhost, int port, String from, String replyToList, String toList, String subject, String message) throws IOException {
        StringTokenizer t;
        MailMessage mailMessage = new MailMessage(mailhost, port);
        mailMessage.setHeader("Date", DateUtils.getDateForHeader());
        mailMessage.from(from);
        if (!replyToList.equals("")) {
            t = new StringTokenizer(replyToList, ", ", false);
            while (t.hasMoreTokens()) {
                mailMessage.replyto(t.nextToken());
            }
        }
        t = new StringTokenizer(toList, ", ", false);
        while (t.hasMoreTokens()) {
            mailMessage.to(t.nextToken());
        }
        mailMessage.setSubject(subject);
        PrintStream ps = mailMessage.getPrintStream();
        ps.println(message);
        mailMessage.sendAndClose();
    }

    private void sendMimeMail(Project project, String host, int port, String user, String password, boolean ssl, String from, String replyToString, String toString, String subject, String message) {
        Mailer mailer = null;
        try {
            mailer = (Mailer)ClasspathUtils.newInstance("org.apache.tools.ant.taskdefs.email.MimeMailer", (class$org$apache$tools$ant$listener$MailLogger == null ? (class$org$apache$tools$ant$listener$MailLogger = MailLogger.class$("org.apache.tools.ant.listener.MailLogger")) : class$org$apache$tools$ant$listener$MailLogger).getClassLoader(), class$org$apache$tools$ant$taskdefs$email$Mailer == null ? (class$org$apache$tools$ant$taskdefs$email$Mailer = MailLogger.class$("org.apache.tools.ant.taskdefs.email.Mailer")) : class$org$apache$tools$ant$taskdefs$email$Mailer);
        }
        catch (BuildException e) {
            Throwable t = e.getCause() == null ? e : e.getCause();
            this.log("Failed to initialise MIME mail: " + t.getMessage());
            return;
        }
        Vector replyToList = this.vectorizeEmailAddresses(replyToString);
        mailer.setHost(host);
        mailer.setPort(port);
        mailer.setUser(user);
        mailer.setPassword(password);
        mailer.setSSL(ssl);
        Message mymessage = new Message(message);
        mymessage.setProject(project);
        mailer.setMessage(mymessage);
        mailer.setFrom(new EmailAddress(from));
        mailer.setReplyToList(replyToList);
        Vector toList = this.vectorizeEmailAddresses(toString);
        mailer.setToList(toList);
        mailer.setCcList(new Vector());
        mailer.setBccList(new Vector());
        mailer.setFiles(new Vector());
        mailer.setSubject(subject);
        mailer.send();
    }

    private Vector vectorizeEmailAddresses(String listString) {
        Vector<EmailAddress> emailList = new Vector<EmailAddress>();
        StringTokenizer tokens = new StringTokenizer(listString, ",");
        while (tokens.hasMoreTokens()) {
            emailList.addElement(new EmailAddress(tokens.nextToken()));
        }
        return emailList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

