/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import org.apache.derby.impl.drda.CodePoint;

class AppRequester {
    protected static final int MGR_LEVEL_UNKNOWN = -1;
    protected static final int UNKNOWN_CLIENT = 0;
    protected static final int JCC_CLIENT = 1;
    protected static final int CCC_CLIENT = 2;
    protected static final int DNC_CLIENT = 3;
    private static final int[] MIN_MGR_LEVELS = new int[]{3, 4, 3, 4, 5, 1, 3, 4, 1, 6, 1, 5, 0};
    protected String extnam;
    protected String srvnam;
    protected String srvrlslv;
    protected String srvclsnm;
    protected String spvnam;
    protected String prdid;
    private int[] managerLevels = new int[CodePoint.MGR_CODEPOINTS.length];
    private int clientType;
    protected int versionLevel;
    protected int releaseLevel;
    protected int modifyLevel;

    AppRequester() {
        for (int i = 0; i < CodePoint.MGR_CODEPOINTS.length; ++i) {
            this.managerLevels[i] = -1;
        }
    }

    protected int getManagerLevel(int n) {
        int n2 = CodePoint.getManagerIndex(n);
        return this.managerLevels[n2];
    }

    protected void setClientVersion(String string) {
        this.prdid = string;
        this.versionLevel = Integer.parseInt(this.prdid.substring(3, 5));
        this.releaseLevel = Integer.parseInt(this.prdid.substring(5, 7));
        this.modifyLevel = Integer.parseInt(this.prdid.substring(7, 8));
        this.clientType = this.srvrlslv == null ? 0 : (this.srvrlslv.indexOf("JCC") != -1 ? 1 : (this.srvrlslv.indexOf("DNC") != -1 ? 3 : 0));
    }

    protected boolean supportsSecMecUSRSSBPWD() {
        return this.clientType == 3 && this.greaterThanOrEqualTo(10, 2, 0);
    }

    protected final boolean supportsQryclsimpForLmtblkprc() {
        return this.clientType == 3;
    }

    protected boolean greaterThanOrEqualTo(int n, int n2, int n3) {
        if (this.versionLevel > n) {
            return true;
        }
        if (this.versionLevel == n) {
            if (this.releaseLevel > n2) {
                return true;
            }
            if (this.releaseLevel == n2 && this.modifyLevel >= n3) {
                return true;
            }
        }
        return false;
    }

    protected void setManagerLevel(int n, int n2) {
        int n3 = CodePoint.getManagerIndex(n);
        this.managerLevels[n3] = n2 >= MIN_MGR_LEVELS[n3] ? n2 : 0;
    }

    protected boolean equals(AppRequester appRequester) {
        if (!this.prdid.equals(appRequester.prdid)) {
            return false;
        }
        if (this.notEquals(this.srvrlslv, appRequester.srvrlslv)) {
            return false;
        }
        if (this.notEquals(this.extnam, appRequester.extnam)) {
            return false;
        }
        if (this.notEquals(this.srvnam, appRequester.srvnam)) {
            return false;
        }
        if (this.notEquals(this.srvclsnm, appRequester.srvclsnm)) {
            return false;
        }
        if (this.notEquals(this.spvnam, appRequester.spvnam)) {
            return false;
        }
        for (int i = 0; i < this.managerLevels.length; ++i) {
            if (this.managerLevels[i] == appRequester.managerLevels[i]) continue;
            return false;
        }
        return true;
    }

    private boolean notEquals(Object object, Object object2) {
        if (object != null && object2 == null) {
            return true;
        }
        if (object == null && object2 != null) {
            return true;
        }
        return object != null && !object.equals(object2);
    }

    protected int supportedMessageParamLength() {
        switch (this.clientType) {
            case 1: 
            case 3: {
                return 2400;
            }
        }
        return 70;
    }

    protected int getClientType() {
        return this.clientType;
    }

    protected boolean isXARequester() {
        return this.getManagerLevel(7169) >= 7;
    }

    protected boolean supportsSessionDataCaching() {
        return this.clientType == 3 && this.greaterThanOrEqualTo(10, 4, 0);
    }
}

