/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.interceptor.model.InterceptorMetadata;
import org.jboss.interceptor.proxy.DirectClassInterceptionHandler;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.interceptor.InterceptionMetadataService;
import org.jboss.weld.bean.interceptor.WeldClassReference;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorImpl<T>
extends ManagedBean<T>
implements Interceptor<T> {
    private final InterceptorMetadata interceptorClassMetadata;
    private final Set<Annotation> interceptorBindingTypes;
    private final boolean serializable;

    public static <T> InterceptorImpl<T> of(WeldClass<T> type, BeanManagerImpl beanManager) {
        return new InterceptorImpl<T>(type, beanManager);
    }

    protected InterceptorImpl(WeldClass<T> type, BeanManagerImpl beanManager) {
        super(type, Interceptor.class.getSimpleName() + "-" + type.getName(), beanManager);
        this.interceptorClassMetadata = beanManager.getServices().get(InterceptionMetadataService.class).getInterceptorMetadataRegistry().getInterceptorClassMetadata(WeldClassReference.of(type));
        this.serializable = type.isSerializable();
        this.interceptorBindingTypes = new HashSet<Annotation>();
        this.interceptorBindingTypes.addAll(InterceptorImpl.flattenInterceptorBindings(beanManager, this.getWeldAnnotated().getAnnotations()));
        for (Class<Annotation> annotation : this.getStereotypes()) {
            this.interceptorBindingTypes.addAll(InterceptorImpl.flattenInterceptorBindings(beanManager, beanManager.getStereotypeDefinition(annotation)));
        }
        if (this.interceptorBindingTypes.size() == 0) {
            throw new DeploymentException(BeanMessage.MISSING_BINDING_ON_INTERCEPTOR, type.getName());
        }
        if (Beans.findInterceptorBindingConflicts(beanManager, this.interceptorBindingTypes)) {
            throw new DeploymentException(BeanMessage.CONFLICTING_INTERCEPTOR_BINDINGS, this.getType());
        }
    }

    @Override
    public Set<Annotation> getInterceptorBindings() {
        return this.interceptorBindingTypes;
    }

    @Override
    public Object intercept(javax.enterprise.inject.spi.InterceptionType type, T instance, InvocationContext ctx) {
        try {
            return new DirectClassInterceptionHandler(instance, this.interceptorClassMetadata).invoke(ctx.getTarget(), InterceptionType.valueOf(type.name()), ctx);
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    @Override
    public boolean intercepts(javax.enterprise.inject.spi.InterceptionType type) {
        return this.interceptorClassMetadata.getInterceptorMethods(InterceptionType.valueOf(type.name())).size() > 0;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    @Override
    protected void defaultPostConstruct(T instance) {
    }

    @Override
    protected void defaultPreDestroy(T instance) {
    }
}

