/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import org.apache.catalina.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterDef
implements Serializable {
    private String description = null;
    private String displayName = null;
    private String filterClassName = null;
    private Class<? extends Filter> filterClass;
    private Filter filter;
    private String filterName = null;
    private String largeIcon = null;
    private String smallIcon = null;
    private Map<String, String> parameters = new HashMap<String, String>();
    private boolean isAsyncSupported = false;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getFilterClassName() {
        return this.filterClassName;
    }

    public void setFilterClassName(String filterClassName) {
        if (this.filterClass != null) {
            throw new IllegalStateException("Filter class already set");
        }
        this.filterClassName = filterClassName;
    }

    public Class<? extends Filter> getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(Class<? extends Filter> filterClass) {
        if (this.filterClassName != null) {
            throw new IllegalStateException("Filter class name already set");
        }
        this.filterClass = filterClass;
        this.filterClassName = filterClass.getName();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        if (filter == null) {
            throw new NullPointerException("Null Filter instance");
        }
        if (this.filterClassName != null) {
            throw new IllegalStateException("Filter class name already set");
        }
        this.filter = filter;
        this.filterClassName = filter.getClass().getName();
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    public void setIsAsyncSupported(boolean isAsyncSupported) {
        this.isAsyncSupported = isAsyncSupported;
    }

    public boolean isAsyncSupported() {
        return this.isAsyncSupported;
    }

    public void addInitParameter(String name, String value) {
        this.setInitParameter(name, value, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setInitParameter(String name, String value, boolean override) {
        if (null == name || null == value) {
            throw new IllegalArgumentException("Null filter init parameter name or value");
        }
        Map<String, String> map = this.parameters;
        synchronized (map) {
            if (override || !this.parameters.containsKey(name)) {
                this.parameters.put(name, value);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> setInitParameters(Map<String, String> initParameters) {
        if (null == initParameters) {
            throw new IllegalArgumentException("Null init parameters");
        }
        Map<String, String> map = this.parameters;
        synchronized (map) {
            HashSet<String> conflicts = null;
            for (Map.Entry<String, String> e : initParameters.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) {
                    throw new IllegalArgumentException("Null parameter name or value");
                }
                if (!this.parameters.containsKey(e.getKey())) continue;
                if (conflicts == null) {
                    conflicts = new HashSet<String>();
                }
                conflicts.add(e.getKey());
            }
            if (conflicts != null) {
                return conflicts;
            }
            for (Map.Entry<String, String> e : initParameters.entrySet()) {
                this.setInitParameter(e.getKey(), e.getValue(), true);
            }
            return Collections.EMPTY_SET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInitParameter(String name) {
        Map<String, String> map = this.parameters;
        synchronized (map) {
            return this.parameters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getInitParameters() {
        Map<String, String> map = this.parameters;
        synchronized (map) {
            return Collections.unmodifiableMap(this.parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getInitParameterNames() {
        Map<String, String> map = this.parameters;
        synchronized (map) {
            return new Enumerator<String>(this.parameters.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInitParameter(String name) {
        Map<String, String> map = this.parameters;
        synchronized (map) {
            this.parameters.remove(name);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FilterDef[");
        sb.append("filterName=");
        sb.append(this.filterName);
        sb.append(", filterClassname=");
        sb.append(this.filterClassName);
        sb.append("]");
        return sb.toString();
    }
}

