/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.extras.osgicontainer;

import com.sun.enterprise.module.Module;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.jvnet.hk2.component.PreDestroy;

public class RefCountingClassLoader
extends DelegatingClassLoader
implements PreDestroy {
    volatile int refs = 0;
    final Module module;

    public RefCountingClassLoader(ClassLoader parent, Module module) {
        super(parent);
        this.addDelegate(new ProtectedClassLoader(parent, module.getClassLoader()));
        this.module = module;
    }

    public void increment() {
        ++this.refs;
    }

    public synchronized void decrement() {
        --this.refs;
        if (this.refs == 0) {
            this.module.stop();
            this.module.uninstall();
        }
    }

    public void preDestroy() {
        this.decrement();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProtectedClassLoader
    implements DelegatingClassLoader.ClassFinder {
        final ClassLoader parent;
        final ClassLoader delegate;

        public ProtectedClassLoader(ClassLoader parent, ClassLoader delegate) {
            this.parent = parent;
            this.delegate = delegate;
        }

        public ClassLoader getParent() {
            return this.parent;
        }

        public Class<?> findClass(String name) throws ClassNotFoundException {
            return this.delegate.loadClass(name);
        }

        public Class<?> findExistingClass(String name) {
            try {
                return this.delegate.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public URL findResource(String name) {
            return this.delegate.getResource(name);
        }

        public Enumeration<URL> findResources(String name) throws IOException {
            return this.delegate.getResources(name);
        }
    }
}

