/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Dictionary;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.osgi.framework.ServiceReference;

abstract class ConfigurationBase {
    private final ConfigurationManager configurationManager;
    private final PersistenceManager persistenceManager;
    private final String baseId;
    private volatile String staticBundleLocation;
    private volatile String dynamicBundleLocation;
    private volatile ServiceReference serviceReference;

    protected ConfigurationBase(ConfigurationManager configurationManager, PersistenceManager persistenceManager, String baseId, String bundleLocation) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("ConfigurationManager must not be null");
        }
        if (persistenceManager == null) {
            throw new IllegalArgumentException("PersistenceManager must not be null");
        }
        this.configurationManager = configurationManager;
        this.persistenceManager = persistenceManager;
        this.baseId = baseId;
        this.staticBundleLocation = bundleLocation;
        this.dynamicBundleLocation = configurationManager.getDynamicBundleLocation(baseId);
    }

    ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    String getBaseId() {
        return this.baseId;
    }

    String getBundleLocation() {
        if (this.staticBundleLocation != null) {
            return this.staticBundleLocation;
        }
        return this.dynamicBundleLocation;
    }

    String getBoundBundleLocation() {
        if (this.dynamicBundleLocation != null) {
            return this.dynamicBundleLocation;
        }
        return this.staticBundleLocation;
    }

    String getDynamicBundleLocation() {
        return this.dynamicBundleLocation;
    }

    String getStaticBundleLocation() {
        return this.staticBundleLocation;
    }

    void setServiceReference(ServiceReference serviceReference) {
        this.serviceReference = serviceReference;
    }

    ServiceReference getServiceReference() {
        return this.serviceReference;
    }

    void setStaticBundleLocation(String bundleLocation) {
        this.staticBundleLocation = bundleLocation;
        this.storeSilently();
        if (bundleLocation != null && this.getDynamicBundleLocation() != null && !bundleLocation.equals(this.getDynamicBundleLocation())) {
            this.setDynamicBundleLocation(null);
            this.setServiceReference(null);
        }
    }

    void setDynamicBundleLocation(String bundleLocation) {
        this.dynamicBundleLocation = bundleLocation;
        this.configurationManager.setDynamicBundleLocation(this.getBaseId(), bundleLocation);
    }

    boolean tryBindLocation(String bundleLocation) {
        if (this.dynamicBundleLocation != null) {
            return this.dynamicBundleLocation.equals(bundleLocation);
        }
        if (this.staticBundleLocation != null && !this.staticBundleLocation.equals(bundleLocation)) {
            return false;
        }
        this.setDynamicBundleLocation(bundleLocation);
        return true;
    }

    abstract void store() throws IOException;

    void storeSilently() {
        try {
            this.store();
        }
        catch (IOException ioe) {
            this.configurationManager.log(1, "Persisting new bundle location failed", ioe);
        }
    }

    protected static void replaceProperty(Dictionary properties, String key, String value) {
        if (value == null) {
            properties.remove(key);
        } else {
            properties.put(key, value);
        }
    }
}

