/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service(name="set-log-level")
@I18n(value="set.log.level")
public class SetLogLevel
implements AdminCommand {
    @Param(name="name_value", primary=true, separator=58)
    Properties properties;
    @Inject
    LoggingConfigImpl loggingConfig;
    String[] validLevels = new String[]{"SEVERE", "WARNING", "INFO", "FINE", "FINER", "FINEST"};
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SetLogLevel.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            for (Object key : this.properties.keySet()) {
                String logger_name = (String)key;
                String level = (String)this.properties.get(logger_name);
                boolean vlvl = false;
                for (String s : this.validLevels) {
                    if (!s.equals(level)) continue;
                    m.put(logger_name + ".level", level);
                    vlvl = true;
                    break;
                }
                if (vlvl) continue;
                report.setMessage(localStrings.getLocalString("set.log.level.invalid", "Invalid logger level found {0}.  Valid levels are: SEVERE, WARNING, INFO, FINE, FINER, FINEST", new Object[]{level}));
            }
            this.loggingConfig.updateLoggingProperties(m);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (IOException e) {
            report.setMessage("Could not set logger levels ");
            report.setMessage(localStrings.getLocalString("set.log.level.failed", "Could not set logger levels."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

