/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.common;

import com.sun.enterprise.v3.common.ActionReporter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="hk2-agent")
@Scoped(value=PerLookup.class)
public class PropsFileActionReporter
extends ActionReporter {
    private boolean useMainChildrenAttr = false;

    public void setMessage(String message) {
        if (message != null) {
            message = message.replace("\n", "%%%EOL%%%");
            message = message.replace(System.getProperty("line.separator"), "%%%EOL%%%");
        }
        super.setMessage(message);
    }

    public void writeReport(OutputStream os) throws IOException {
        Manifest out = new Manifest();
        Attributes mainAttr = out.getMainAttributes();
        mainAttr.put(Attributes.Name.SIGNATURE_VERSION, "1.0");
        mainAttr.putValue("exit-code", this.exitCode.toString());
        mainAttr.putValue("use-main-children-attribute", Boolean.toString(this.useMainChildrenAttr));
        if (this.exitCode == ActionReport.ExitCode.FAILURE) {
            this.writeCause(mainAttr);
        }
        this.writeReport(null, this.topMessage, out, mainAttr);
        out.write(os);
    }

    public void writeReport(String prefix, ActionReport.MessagePart part, Manifest m, Attributes attr) {
        String keys;
        StringBuilder sb = new StringBuilder();
        this.getCombinedMessages(this, sb);
        attr.putValue("message", sb.toString());
        if (part.getProps().size() > 0) {
            keys = null;
            for (Map.Entry<Object, Object> entry : part.getProps().entrySet()) {
                String key = entry.getKey().toString().replaceAll(" ", "_");
                keys = keys == null ? key : keys + ";" + key;
                attr.putValue(key + "_name", entry.getKey().toString());
                attr.putValue(key + "_value", entry.getValue().toString());
            }
            attr.putValue("keys", keys);
        }
        if (part.getChildren().size() > 0) {
            attr.putValue("children-type", part.getChildrenType());
            keys = null;
            for (ActionReport.MessagePart child : part.getChildren()) {
                String newPrefix = prefix == null ? child.getMessage() : prefix + "." + child.getMessage();
                keys = keys == null ? newPrefix : keys + ";" + newPrefix;
                Attributes childAttr = new Attributes();
                m.getEntries().put(newPrefix, childAttr);
                this.writeReport(newPrefix, child, m, childAttr);
            }
            attr.putValue("children", keys);
        }
    }

    private void writeCause(Attributes mainAttr) {
        Throwable t = this.getFailureCause();
        if (t == null) {
            return;
        }
        String causeMessage = t.toString();
        mainAttr.putValue("cause", causeMessage);
    }

    public void useMainChildrenAttribute(boolean useMainChildrenAttr) {
        this.useMainChildrenAttr = useMainChildrenAttr;
    }
}

