/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessManagerTimeoutException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessManager {
    private String[] cmdline;
    private StringBuffer sb_out;
    private StringBuffer sb_err;
    private int exit = -1;
    private int timeout;
    private Process process;
    private boolean wasError = true;
    private static final boolean debugOn = false;
    private String[] stdinLines;
    private List<Thread> threads = new ArrayList<Thread>(2);

    public ProcessManager(String ... cmds) {
        this.cmdline = cmds;
    }

    public ProcessManager(List<String> Cmdline) {
        this.cmdline = new String[Cmdline.size()];
        this.cmdline = Cmdline.toArray(this.cmdline);
    }

    public final void setTimeoutMsec(int num) {
        if (num > 0) {
            this.timeout = num;
        }
    }

    public final void setStdinLines(List<String> list) {
        if (list != null && list.size() > 0) {
            this.stdinLines = new String[list.size()];
            this.stdinLines = list.toArray(this.cmdline);
        }
    }

    public final int execute() throws ProcessManagerException {
        try {
            this.sb_out = new StringBuffer();
            this.sb_err = new StringBuffer();
            Runtime rt = Runtime.getRuntime();
            this.process = rt.exec(this.cmdline);
            this.writeStdin();
            this.readStream("stderr", this.process.getErrorStream(), this.sb_err);
            this.readStream("stdout", this.process.getInputStream(), this.sb_out);
            this.await();
            try {
                this.exit = this.process.exitValue();
                this.wasError = false;
            }
            catch (IllegalThreadStateException tse) {
                this.process.destroy();
                throw new ProcessManagerTimeoutException(tse);
            }
        }
        catch (ProcessManagerException pme) {
            throw pme;
        }
        catch (Exception e) {
            if (this.process != null) {
                this.process.destroy();
            }
            throw new ProcessManagerException(e);
        }
        return this.exit;
    }

    public final String getStdout() {
        return this.sb_out.toString();
    }

    public final String getStderr() {
        return this.sb_err.toString();
    }

    public final int getExitValue() {
        return this.exit;
    }

    public String toString() {
        return Arrays.toString(this.cmdline);
    }

    private void writeStdin() throws ProcessManagerException {
        if (this.stdinLines == null || this.stdinLines.length <= 0) {
            return;
        }
        PrintWriter pipe = null;
        try {
            pipe = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream())));
            for (int i = 0; i < this.stdinLines.length; ++i) {
                ProcessManager.debug("InputLine ->" + this.stdinLines[i] + "<-");
                pipe.println(this.stdinLines[i]);
            }
            pipe.flush();
        }
        catch (Exception e) {
            throw new ProcessManagerException(e);
        }
        finally {
            try {
                pipe.close();
            }
            catch (Throwable t) {}
        }
    }

    private void readStream(String name, InputStream stream, StringBuffer sb) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        Thread thread = new Thread((Runnable)new ReaderThread(reader, sb), name);
        this.threads.add(thread);
        thread.start();
    }

    private void await() throws InterruptedException {
        if (this.timeout <= 0) {
            this.waitForever();
        } else {
            this.waitAwhile();
        }
    }

    private void waitForever() throws InterruptedException {
        this.process.waitFor();
        for (Thread t : this.threads) {
            t.join();
        }
    }

    private void waitAwhile() throws InterruptedException {
        Thread processWaiter = new Thread(new TimeoutThread(this.process));
        processWaiter.start();
        processWaiter.join(this.timeout);
    }

    private static void debug(String s) {
    }

    public static void main(String[] args) {
        try {
            if (args.length <= 0) {
                System.out.println("Usage: ProcessManager cmd arg1 arg2 ... argn");
                System.exit(1);
            }
            ArrayList<String> cmds = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                cmds.add(args[i]);
            }
            ProcessManager pm = new ProcessManager(cmds);
            pm.execute();
            System.out.println("*********** STDOUT ***********\n" + pm.getStdout());
            System.out.println("*********** STDERR ***********\n" + pm.getStderr());
            System.out.println("*********** EXIT VALUE: " + pm.getExitValue());
        }
        catch (ProcessManagerException pme) {
            pme.printStackTrace();
        }
    }

    static class TimeoutThread
    implements Runnable {
        private Process process;

        TimeoutThread(Process p) {
            this.process = p;
        }

        public void run() {
            try {
                this.process.waitFor();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProcessManager.debug("TimeoutThread exiting...");
        }
    }

    static class ReaderThread
    implements Runnable {
        private BufferedReader reader;
        private StringBuffer sb;

        ReaderThread(BufferedReader Reader2, StringBuffer SB) {
            this.reader = Reader2;
            this.sb = SB;
        }

        public void run() {
            try {
                String line = this.reader.readLine();
                while (line != null) {
                    this.sb.append(line).append('\n');
                    System.out.println(line);
                    line = this.reader.readLine();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProcessManager.debug("ReaderThread exiting...");
        }
    }
}

