/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;

public class DBWSException
extends EclipseLinkException {
    public static final int COULD_NOT_LOCATE_FILE = 47000;
    public static final int COULD_NOT_LOCATE_DESCRIPTOR = 47001;
    public static final int COULD_NOT_LOCATE_QUERY_FOR_DESCRIPTOR = 47002;
    public static final int COULD_NOT_LOCATE_QUERY_FOR_SESSION = 47003;
    public static final int PARAMETER_DOES_NOT_EXIST_FOR_OPERATION = 47004;
    public static final int PARAMETER_HAS_NO_MAPPING = 47005;
    public static final int RESULT_DOES_NOT_EXIST_FOR_OPERATION = 47006;
    public static final int RESULT_HAS_NO_MAPPING = 47007;
    public static final int MULTIPLE_OUTPUT_ARGUMENTS_ONLY_FOR_SIMPLE_XML = 47008;
    public static final int INOUT_CURSOR_ARGUMENTS_NOT_SUPPORTED = 47009;
    public static final int COULD_NOT_LOCATE_OR_SESSION_FOR_SERVICE = 47010;
    public static final int COULD_NOT_LOCATE_OX_SESSION_FOR_SERVICE = 47011;
    public static final int COULD_NOT_PARSE_DBWS_FILE = 47012;

    public DBWSException() {
    }

    public DBWSException(String message, Throwable cause) {
        super(message, cause);
    }

    public DBWSException(String message) {
        super(message);
    }

    public static DBWSException couldNotLocateFile(String missingFile) {
        Object[] args = new Object[]{missingFile};
        DBWSException exception = new DBWSException(ExceptionMessageGenerator.buildMessage(DBWSException.class, 47000, args));
        exception.setErrorCode(47000);
        return exception;
    }

    public static DBWSException couldNotLocateDescriptorForOperation(String descriptor, String operation) {
        Object[] args = new Object[]{descriptor, operation};
        DBWSException exception = new DBWSException(ExceptionMessageGenerator.buildMessage(DBWSException.class, 47001, args));
        exception.setErrorCode(47001);
        return exception;
    }

    public static DBWSException couldNotLocateQueryForDescriptor(String query, String descriptor) {
        Object[] args = new Object[]{query, descriptor};
        DBWSException exception = new DBWSException(ExceptionMessageGenerator.buildMessage(DBWSException.class, 47002, args));
        exception.setErrorCode(47002);
        return exception;
    }

    public static DBWSException couldNotLocateQueryForSession(String query, String session) {
        Object[] args = new Object[]{query, session};
        DBWSException exception = new DBWSException(ExceptionMessageGenerator.buildMessage(DBWSException.class, 47003, args));
        exception.setErrorCode(47003);
        return exception;
    }

    public static DBWSException parameterDoesNotExistForOperation(String parameterType, String operation) {
        Object[] args = new Object[]{parameterType, operation};
        DBWSException exception = new DBWSException(ExceptionMessageGenerator.buildMessage(DBWSException.class, 47004, args));
        exception.setErrorCode(47004);
        return exception;
    }

    public static DBWSException parameterHasNoMapping(String parameterType, String operation) {
        Object[] args = new Object[]{parameterType, operation};
        DBWSException exception = new DBWSException(ExceptionMessageGenerator.buildMessage(DBWSException.class, 47005, args));
        exception.setErrorCode(47005);
        return exception;
    }

    public static DBWSException resultDoesNotExistForOperation(String resultType, String operation) {
        Object[] args = new Object[]{resultType, operation};
        DBWSException exception = new DBWSException(ExceptionMessageGenerator.buildMessage(DBWSException.class, 47006, args));
        exception.setErrorCode(47006);
        return exception;
    }

    public static DBWSException resultHasNoMapping(String resultType, String operation) {
        Object[] args = new Object[]{resultType, operation};
        DBWSException exception = new DBWSException(ExceptionMessageGenerator.buildMessage(DBWSException.class, 47007, args));
        exception.setErrorCode(47007);
        return exception;
    }

    public static DBWSException multipleOutputArgumentsOnlySupportedForSimpleXML() {
        Object[] args = new Object[]{};
        DBWSException exception = new DBWSException(ExceptionMessageGenerator.buildMessage(DBWSException.class, 47008, args));
        exception.setErrorCode(47008);
        return exception;
    }

    public static DBWSException inoutCursorArgumentsNotSupported() {
        Object[] args = new Object[]{};
        DBWSException exception = new DBWSException(ExceptionMessageGenerator.buildMessage(DBWSException.class, 47009, args));
        exception.setErrorCode(47009);
        return exception;
    }

    public static DBWSException couldNotLocateORSessionForService(String serviceName) {
        Object[] args = new Object[]{serviceName};
        DBWSException exception = new DBWSException(ExceptionMessageGenerator.buildMessage(DBWSException.class, 47010, args));
        exception.setErrorCode(47010);
        return exception;
    }

    public static DBWSException couldNotLocateOXSessionForService(String serviceName) {
        Object[] args = new Object[]{serviceName};
        DBWSException exception = new DBWSException(ExceptionMessageGenerator.buildMessage(DBWSException.class, 47011, args));
        exception.setErrorCode(47011);
        return exception;
    }

    public static DBWSException couldNotParseDBWSFile() {
        Object[] args = new Object[]{};
        DBWSException exception = new DBWSException(ExceptionMessageGenerator.buildMessage(DBWSException.class, 47012, args));
        exception.setErrorCode(47012);
        return exception;
    }
}

