/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;

public class DeferredLockManager {
    protected Vector deferredLocks = new Vector(1);
    protected Vector activeLocks = new Vector(1);
    protected int threadDepth = 0;
    protected boolean isThreadComplete = false;
    public static boolean SHOULD_USE_DEFERRED_LOCKS = true;

    public void addActiveLock(Object manager) {
        this.getActiveLocks().addElement(manager);
    }

    public void addDeferredLock(Object manager) {
        this.getDeferredLocks().addElement(manager);
    }

    public void decrementDepth() {
        --this.threadDepth;
    }

    public Vector getActiveLocks() {
        return this.activeLocks;
    }

    public Vector getDeferredLocks() {
        return this.deferredLocks;
    }

    public int getThreadDepth() {
        return this.threadDepth;
    }

    public boolean hasDeferredLock() {
        return !this.getDeferredLocks().isEmpty();
    }

    public void incrementDepth() {
        ++this.threadDepth;
    }

    public boolean isThreadComplete() {
        return this.isThreadComplete;
    }

    public void releaseActiveLocksOnThread() {
        Vector activeLocks = this.getActiveLocks();
        if (!activeLocks.isEmpty()) {
            Enumeration activeLocksEnum = activeLocks.elements();
            while (activeLocksEnum.hasMoreElements()) {
                ConcurrencyManager manager = (ConcurrencyManager)activeLocksEnum.nextElement();
                manager.release();
            }
        }
        this.setIsThreadComplete(true);
    }

    public void setActiveLocks(Vector activeLocks) {
        this.activeLocks = activeLocks;
    }

    public void setDeferredLocks(Vector deferredLocks) {
        this.deferredLocks = deferredLocks;
    }

    public void setIsThreadComplete(boolean isThreadComplete) {
        this.isThreadComplete = isThreadComplete;
    }
}

