/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.MethodEntryExitInstrumentor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class SynchronizedInstrumentor
extends MethodEntryExitInstrumentor {
    private String className;
    private boolean isStatic;
    private boolean isSyncMethod;

    public SynchronizedInstrumentor(String className, MethodVisitor mv, int access, String name, String desc) {
        super(mv, access, name, desc);
        this.className = className;
        this.isStatic = (access & 8) != 0;
        this.isSyncMethod = (access & 0x20) != 0;
    }

    @Override
    protected void onMethodEntry() {
        if (this.isSyncMethod) {
            this.pushLockedObject();
            this.onAfterSyncEntry();
            this.pop();
        }
    }

    @Override
    protected void onMethodReturn(int opcode) {
        this.onErrorReturn();
    }

    @Override
    protected void onErrorReturn() {
        if (this.isSyncMethod) {
            this.pushLockedObject();
            this.onBeforeSyncExit();
            this.pop();
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode == 194) {
            this.dup();
            this.onBeforeSyncEntry();
        } else if (opcode == 195) {
            this.dup();
            this.onBeforeSyncExit();
        }
        super.visitInsn(opcode);
        if (opcode == 194) {
            this.onAfterSyncEntry();
            this.pop();
        } else if (opcode == 195) {
            this.onAfterSyncExit();
            this.pop();
        }
    }

    protected void onBeforeSyncEntry() {
        this.println("before synchronized entry");
    }

    protected void onAfterSyncEntry() {
        this.println("after synchronized entry");
    }

    protected void onBeforeSyncExit() {
        this.println("before synchronized exit");
    }

    protected void onAfterSyncExit() {
        this.println("after synchronized exit");
    }

    private void pushLockedObject() {
        if (this.isStatic) {
            super.visitLdcInsn(Type.getObjectType(this.className));
        } else {
            this.loadThis();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.sun.btrace.runtime.SynchronizedInstrumentor <class>");
            System.exit(1);
        }
        args[0] = args[0].replace('.', '/');
        FileInputStream fis = new FileInputStream(args[0] + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(args[0] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        InstrumentUtils.accept(reader, new ClassAdapter(writer){
            private String className;

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                this.className = name;
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new SynchronizedInstrumentor(this.className, mv, access, name, desc);
            }
        });
        fos.write(writer.toByteArray());
    }
}

