/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.BaseDomainInfoObj;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.DirectoryMover;
import com.sun.enterprise.tools.upgrade.common.VersionExtracter;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TargetAppSrvObj
extends BaseDomainInfoObj {
    private static final Logger logger = LogService.getLogger();
    private static final StringManager sm = StringManager.getManager(TargetAppSrvObj.class);
    private DirectoryMover directoryMover = null;

    public boolean isValidPath(String s) {
        File targetPathDir = new File(s);
        if (!targetPathDir.exists()) {
            logger.log(Level.INFO, sm.getString("enterprise.tools.upgrade.target.dir_does_not_exist", targetPathDir.getAbsolutePath()));
            return false;
        }
        File tmpPath = new File(targetPathDir, CommonInfoModel.getInstance().getSource().getDomainName());
        if (!tmpPath.exists()) {
            return true;
        }
        if (this.directoryMover != null && this.directoryMover.moveDirectory(tmpPath)) {
            return true;
        }
        logger.log(Level.INFO, sm.getString("enterprise.tools.upgrade.target.dir_domain_exist", tmpPath.getAbsolutePath()));
        return false;
    }

    public void setInstallDir(String s) {
        this.installDir = s;
        if (s != null) {
            this.domainRoot = super.extractDomainRoot(s);
        }
    }

    public String getDomainDir() {
        return this.getInstallDir() + "/" + this.domainName;
    }

    public String getConfigXMLFile() {
        StringBuilder stringBuilder = new StringBuilder().append(this.getDomainDir()).append("/");
        this.getClass();
        return stringBuilder.append("config/domain.xml").toString();
    }

    public String getVersionEdition() {
        if (this.versionEdition == null) {
            VersionExtracter vExtracter = new VersionExtracter(CommonInfoModel.getInstance());
            this.version = "3.0.1";
            this.edition = "All";
            this.versionEdition = vExtracter.formatVersionEditionStrings(this.version, this.edition);
        }
        return this.versionEdition;
    }

    public void setDirectoryMover(DirectoryMover directoryMover) {
        this.directoryMover = directoryMover;
    }
}

