/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.scripting.jruby.JRubyContainer;
import org.glassfish.scripting.jruby.Messages;
import org.glassfish.scripting.jruby.common.config.JRubyConfig;

public class RackApplicationChooser {
    private final Logger logger = Logger.getLogger(JRubyContainer.class.getName());

    public JRubyConfig.Framework which(final String appPath, final String appType) {
        if (appType != null) {
            if (appType.equalsIgnoreCase("sinatra")) {
                return this.findSinatra(appPath);
            }
            if (appType.equalsIgnoreCase("rails")) {
                return new JRubyConfig.Framework(){

                    public String type() {
                        return appType;
                    }

                    public File initScript() {
                        return new File(appPath, "config/boot.rb");
                    }
                };
            }
            if (appType.equalsIgnoreCase("merb")) {
                return new JRubyConfig.Framework(){

                    public String type() {
                        return appType;
                    }

                    public File initScript() {
                        String nextFile;
                        String fileName = appPath + "config" + File.separator + "init.rb";
                        File init = new File(fileName);
                        if (!init.exists() && !(init = new File(nextFile = appPath + "root" + File.separator + "init.rb")).exists()) {
                            throw new IllegalArgumentException(Messages.format("jrubyappchosser.autodetection.merb.notfound", fileName, nextFile));
                        }
                        return init;
                    }
                };
            }
            return new JRubyConfig.Framework(){

                public String type() {
                    return appType;
                }

                public File initScript() {
                    if (RackApplicationChooser.this.isFileOrDir(appType)) {
                        File f = new File(appType);
                        if (!f.isAbsolute()) {
                            return new File(appPath, appType);
                        }
                        return f;
                    }
                    return null;
                }
            };
        }
        this.logger.fine("Path is " + appPath + ", checking for Rails");
        JRubyConfig.Framework rails = this.detectRails(appPath);
        if (rails != null) {
            return rails;
        }
        this.logger.fine("Rails not found, checking for Merb");
        JRubyConfig.Framework merb = this.detectMerb(appPath);
        if (merb != null) {
            return merb;
        }
        this.logger.fine("Merb not found, checking for Sinatra");
        JRubyConfig.Framework sinatra = this.findSinatra(appPath);
        if (sinatra != null) {
            return sinatra;
        }
        this.logger.info(Messages.format("jrubyappchosser.autodetection.framework.notfound", new Object[0]));
        JRubyConfig.Framework rackUp = this.findRackup(appPath);
        if (rackUp != null) {
            this.logger.info(Messages.format("jrubyappchosser.autodetection.rackup.found", appPath));
            return rackUp;
        }
        this.logger.severe(Messages.format("jrubyappchooser.autodetection.failed", new Object[0]));
        throw new IllegalStateException(Messages.format("jrubyappchosser.autodetection.noframework", new Object[0]));
    }

    private boolean isFileOrDir(String value) {
        return !value.equals("rails") && !value.equals("merb") && !value.equals("sinatra");
    }

    private boolean isSinatra(File f) {
        String app = "";
        if (f.exists()) {
            try {
                String s;
                BufferedReader in = new BufferedReader(new FileReader(f));
                while ((s = in.readLine()) != null) {
                    if (!s.matches("\\s*require\\s*[\"']sinatra[\"']")) continue;
                    return true;
                }
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, Messages.format("jrubyappchosser.autodetection.framework.exception", f.getAbsolutePath()), e);
            }
        } else {
            this.logger.severe(Messages.format("jrubyappchosser.autodetection.sinatra.notfound", f.getAbsolutePath()));
        }
        return false;
    }

    private String inhale(File f) {
        StringBuffer app = new StringBuffer();
        if (f.exists()) {
            try {
                String s;
                BufferedReader in = new BufferedReader(new FileReader(f));
                while ((s = in.readLine()) != null) {
                    s = s.trim();
                    app.append(s).append("\n");
                }
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, Messages.format("jrubyappchosser.autodetection.framework.exception", f.getAbsolutePath()), e);
            }
        } else {
            this.logger.severe(Messages.format("jrubyappchosser.autodetection.sinatra.notfound", f.getAbsolutePath()));
        }
        return app.toString();
    }

    private JRubyConfig.Framework findSinatra(String appPath) {
        final File appDir = new File(appPath);
        if (appDir.isDirectory()) {
            File[] files;
            for (final File file : files = appDir.listFiles()) {
                if (!file.getAbsolutePath().endsWith(".rb")) continue;
                this.logger.fine("Checking " + file.getName());
                if (!this.detectSinatra(file)) continue;
                this.logger.fine("Found Sinatra in " + file.getAbsolutePath());
                return new JRubyConfig.Framework(){

                    public String type() {
                        return "sinatra";
                    }

                    public File initScript() {
                        return file;
                    }
                };
            }
        } else if (this.detectSinatra(appDir)) {
            this.logger.fine("Found Sinatra in " + appDir.getAbsolutePath());
            return new JRubyConfig.Framework(){

                public String type() {
                    return "sinatra";
                }

                public File initScript() {
                    return appDir;
                }
            };
        }
        return null;
    }

    private JRubyConfig.Framework findRackup(String appPath) {
        File appDir = new File(appPath);
        if (appDir.isDirectory()) {
            File[] files;
            for (final File file : files = appDir.listFiles()) {
                if (!file.getAbsolutePath().endsWith(".ru")) continue;
                return new JRubyConfig.Framework(){

                    public String type() {
                        return "rackup";
                    }

                    public File initScript() {
                        return file;
                    }
                };
            }
        }
        return null;
    }

    private boolean detectSinatra(File appFile) {
        this.logger.fine("attempting to detect sinatra in " + appFile.getPath());
        if (this.isSinatra(appFile)) {
            this.logger.info(Messages.format("jrubyappchosser.autodetection.app.found.sinatra", new Object[0]));
            return true;
        }
        return false;
    }

    private JRubyConfig.Framework detectRails(String appPath) {
        String bootFile;
        final File boot = new File(appPath, "config/boot.rb");
        if (boot.exists() && ((bootFile = this.inhale(boot)).contains("RAILS_ROOT") || bootFile.contains("Rails.boot!"))) {
            this.logger.info(Messages.format("jrubyappchosser.autodetection.app.found.rails", new Object[0]));
            return new JRubyConfig.Framework(){

                public String type() {
                    return "rails";
                }

                public File initScript() {
                    return boot;
                }
            };
        }
        return null;
    }

    private JRubyConfig.Framework detectMerb(String appPath) {
        File init = new File(appPath, "config/init.rb");
        if (!init.exists() && !(init = new File(appPath, "root/init.rb")).exists()) {
            return null;
        }
        String initFile = this.inhale(init);
        if (initFile.contains("Merb::Config")) {
            this.logger.info(Messages.format("jrubyappchosser.autodetection.app.found.merb", new Object[0]));
            final File init1 = init;
            return new JRubyConfig.Framework(){

                public String type() {
                    return "merb";
                }

                public File initScript() {
                    return init1;
                }
            };
        }
        return null;
    }
}

