/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.monitor.utils;

import java.util.concurrent.atomic.AtomicLong;

public class TimeStat {
    public final AtomicLong startTime = new AtomicLong(0L);
    public final AtomicLong endTime = new AtomicLong(0L);
    public final AtomicLong totalTime = new AtomicLong(0L);

    public void entry() {
        this.startTime.set(System.currentTimeMillis());
    }

    public void exit() {
        this.endTime.set(System.currentTimeMillis());
        this.totalTime.addAndGet(this.endTime.get() - this.startTime.get());
    }

    public long getTotalTime(UNIT unit) {
        return unit == UNIT.MILLISECOND ? this.totalTime.get() : this.totalTime.get() / 1000L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UNIT {
        MILLISECOND,
        SECOND;

    }
}

