/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.security.ssl.J2EEKeyManager;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.catalina.net.ServerSocketFactory;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.SharedSecureRandom;
import org.jvnet.hk2.component.Habitat;

public class SSLSocketFactory
implements ServerSocketFactory {
    static Logger _logger = LogDomains.getLogger(SSLSocketFactory.class, (String)"javax.enterprise.system.container.web");
    private static final boolean clientAuth = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SSLSocketFactory.class);
    private SSLContext context = null;
    private SSLServerSocketFactory factory = null;
    private String[] cipherSuites;
    private static KeyManager[] keyManagers = null;
    private static TrustManager[] trustManagers = null;
    private static boolean initialized = false;

    public SSLSocketFactory() {
        try {
            if (keyManagers == null || trustManagers == null) {
                SSLSocketFactory.initStoresAtStartup();
            }
            this.context = SSLContext.getInstance("TLS");
            this.context.init(keyManagers, trustManagers, SharedSecureRandom.get());
            this.factory = this.context.getServerSocketFactory();
            this.cipherSuites = this.factory.getSupportedCipherSuites();
            for (int i = 0; i < this.cipherSuites.length; ++i) {
                if (!_logger.isLoggable(Level.FINEST)) continue;
                _logger.log(Level.FINEST, "Suite: " + this.cipherSuites[i]);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "web_security.excep_sslsockfact", e.getMessage());
        }
    }

    public ServerSocket createSocket(int port) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port);
        this.init(socket);
        return socket;
    }

    private void init(SSLServerSocket socket) {
        socket.setNeedClientAuth(false);
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port, backlog);
        this.init(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port, backlog, ifAddress);
        this.init(socket);
        return socket;
    }

    public static synchronized void initStoresAtStartup() throws Exception {
        if (initialized) {
            return;
        }
        Habitat habitat = Globals.getDefaultHabitat();
        SSLUtils sslUtils = habitat.getComponent(SSLUtils.class);
        keyManagers = sslUtils.getKeyManagers();
        trustManagers = sslUtils.getTrustManagers();
        SSLContext ctx = SSLContext.getInstance("TLS");
        String keyAlias = System.getProperty("com.sun.enterprise.security.httpsOutboundKeyAlias");
        KeyManager[] kMgrs = sslUtils.getKeyManagers();
        if (keyAlias != null && keyAlias.length() > 0 && kMgrs != null) {
            for (int i = 0; i < kMgrs.length; ++i) {
                kMgrs[i] = new J2EEKeyManager(habitat, (X509KeyManager)kMgrs[i], keyAlias);
            }
        }
        ctx.init(kMgrs, sslUtils.getTrustManagers(), null);
        HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
        initialized = true;
    }
}

