/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.sun.ejb.containers.util.cache.BaseCache;
import com.sun.ejb.containers.util.cache.EJBObjectCache;
import com.sun.ejb.containers.util.cache.EJBObjectCacheListener;
import com.sun.ejb.containers.util.cache.LruCache;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FIFOEJBObjectCache
extends LruCache
implements EJBObjectCache {
    protected int maxCacheSize;
    protected String name;
    protected EJBObjectCacheListener listener;
    protected Object refCountLock = new Object();
    protected int totalRefCount = 0;
    protected static boolean _printRefCount = false;
    private static final Logger _logger = LogDomains.getLogger(FIFOEJBObjectCache.class, (String)"javax.enterprise.system.container.ejb");

    public FIFOEJBObjectCache(String name) {
        this.name = name;
    }

    public FIFOEJBObjectCache(String name, long timeout) {
        super(timeout);
        this.name = name;
    }

    public void init(int maxEntries, int numberOfVictimsToSelect, long timeout, float loadFactor, Properties props) {
        super.init(maxEntries, loadFactor, props);
        this.timeout = timeout;
        this.maxCacheSize = maxEntries;
        _logger.log(Level.FINE, this.name + ": FIFOEJBObject cache created....");
    }

    public void setEJBObjectCacheListener(EJBObjectCacheListener listener) {
        this.listener = listener;
    }

    public Object get(Object key) {
        int hashCode = this.hash(key);
        return this.internalGet(hashCode, key, false);
    }

    public Object get(Object key, boolean incrementRefCount) {
        int hashCode = this.hash(key);
        return this.internalGet(hashCode, key, incrementRefCount);
    }

    public Object put(Object key, Object value) {
        int hashCode = this.hash(key);
        return this.internalPut(hashCode, key, value, -1, false);
    }

    public Object put(Object key, Object value, boolean incrementRefCount) {
        int hashCode = this.hash(key);
        return this.internalPut(hashCode, key, value, -1, incrementRefCount);
    }

    public Object remove(Object key) {
        return this.internalRemove(key, true);
    }

    public Object remove(Object key, boolean decrementRefCount) {
        return this.internalRemove(key, decrementRefCount);
    }

    protected boolean isThresholdReached() {
        return this.listSize > this.maxCacheSize;
    }

    protected void itemAccessed(BaseCache.CacheItem item) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemRemoved(BaseCache.CacheItem item) {
        LruCache.LruCacheItem l = (LruCache.LruCacheItem)item;
        FIFOEJBObjectCache fIFOEJBObjectCache = this;
        synchronized (fIFOEJBObjectCache) {
            if (l.isTrimmed) {
                return;
            }
            LruCache.LruCacheItem prev = l.lPrev;
            LruCache.LruCacheItem next = l.lNext;
            l.isTrimmed = true;
            if (prev != null) {
                prev.lNext = next;
            } else {
                this.head = next;
            }
            if (next != null) {
                next.lPrev = prev;
            } else {
                this.tail = prev;
            }
            l.lPrev = null;
            l.lNext = null;
            --this.listSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalGet(int hashCode, Object key, boolean incrementRefCount) {
        int index = this.getIndex(hashCode);
        Object value = null;
        BaseCache.CacheItem item = null;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            item = this.buckets[index];
            while (!(item == null || hashCode == item.hashCode && this.eq(key, item.key))) {
                item = item.next;
            }
            if (item != null) {
                value = item.getValue();
                if (incrementRefCount) {
                    EJBObjectCacheItem eoItem = (EJBObjectCacheItem)item;
                    ++eoItem.refCount;
                    if (_printRefCount) {
                        this.incrementReferenceCount();
                    }
                    if (!eoItem.isTrimmed) {
                        this.itemRemoved(eoItem);
                    }
                }
            }
        }
        if (item != null) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalPut(int hashCode, Object key, Object value, int size, boolean incrementRefCount) {
        int index = this.getIndex(hashCode);
        BaseCache.CacheItem oldItem = null;
        BaseCache.CacheItem overflow = null;
        EJBObjectCacheItem newItem = null;
        Object oldValue = null;
        boolean oldSize = false;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            BaseCache.CacheItem item = this.buckets[index];
            while (item != null) {
                if (hashCode == item.hashCode && this.eq(key, item.key)) {
                    oldItem = item;
                    break;
                }
                item = item.next;
            }
            if (oldItem == null) {
                newItem = (EJBObjectCacheItem)this.createItem(hashCode, key, value, size);
                newItem.isTrimmed = incrementRefCount;
                newItem.next = this.buckets[index];
                this.buckets[index] = newItem;
                if (incrementRefCount) {
                    ++newItem.refCount;
                    if (_printRefCount) {
                        this.incrementReferenceCount();
                    }
                } else {
                    overflow = this.itemAdded(newItem);
                }
            } else {
                oldValue = oldItem.getValue();
                if (incrementRefCount) {
                    EJBObjectCacheItem oldEJBO = (EJBObjectCacheItem)oldItem;
                    ++oldEJBO.refCount;
                    if (_printRefCount) {
                        this.incrementReferenceCount();
                    }
                }
            }
        }
        if (newItem != null) {
            this.incrementEntryCount();
            if (overflow != null && this.listener != null) {
                this.listener.handleOverflow(overflow.key);
            }
        }
        return oldValue;
    }

    public void print() {
        System.out.println("EJBObjectCache:: size: " + this.getEntryCount() + "; listSize: " + this.listSize);
        LruCache.LruCacheItem run = this.head;
        while (run != null) {
            System.out.print("(" + run.key + ", " + run.value + ") ");
            run = run.lNext;
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalRemove(Object key, boolean decrementRefCount) {
        int hashCode = this.hash(key);
        int index = this.getIndex(hashCode);
        BaseCache.CacheItem prev = null;
        BaseCache.CacheItem item = null;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            item = this.buckets[index];
            while (item != null) {
                if (hashCode == item.hashCode && key.equals(item.key)) {
                    EJBObjectCacheItem eoItem = (EJBObjectCacheItem)item;
                    if (decrementRefCount && eoItem.refCount > 0) {
                        --eoItem.refCount;
                        if (_printRefCount) {
                            this.decrementReferenceCount();
                        }
                    }
                    if (eoItem.refCount > 0) {
                        return null;
                    }
                    if (prev == null) {
                        this.buckets[index] = item.next;
                    } else {
                        prev.next = item.next;
                    }
                    item.next = null;
                    this.itemRemoved(item);
                    break;
                }
                prev = item;
                item = item.next;
            }
        }
        if (item != null) {
            this.decrementEntryCount();
            this.incrementRemovalCount();
            this.incrementHitCount();
            return item.value;
        }
        this.incrementMissCount();
        return null;
    }

    protected BaseCache.CacheItem createItem(int hashCode, Object key, Object value, int size) {
        return new EJBObjectCacheItem(hashCode, key, value, size);
    }

    public Map getStats() {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("(totalRef=").append(this.totalRefCount).append("; ");
        sbuf.append("listSize=").append(this.listSize).append("; curSize/totSize=").append(this.getEntryCount()).append("/").append(this.maxEntries).append("; trim=").append(this.trimCount).append("; remove=").append(this.removalCount).append("; hit/miss=").append(this.hitCount).append("/").append(this.missCount).append(")");
        map.put("[" + this.name + "]", sbuf.toString());
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimExpiredEntries(int maxCount) {
        int count;
        LruCache.LruCacheItem item;
        LruCache.LruCacheItem lastItem = null;
        long currentTime = System.currentTimeMillis();
        FIFOEJBObjectCache fIFOEJBObjectCache = this;
        synchronized (fIFOEJBObjectCache) {
            item = this.tail;
            for (count = 0; item != null && count < maxCount && this.timeout != -1L && item.lastAccessed + this.timeout <= currentTime; ++count) {
                item.isTrimmed = true;
                lastItem = item;
                item = item.lPrev;
            }
            if (item != this.tail) {
                lastItem.lPrev = null;
                if (item != null) {
                    item.lNext = null;
                } else {
                    this.head = null;
                }
                lastItem = this.tail;
                this.tail = item;
            }
            this.listSize -= count;
            this.trimCount += count;
        }
        if (count > 0) {
            ArrayList<Object> localVictims = new ArrayList<Object>(count);
            item = lastItem;
            while (item != null) {
                localVictims.add(item.key);
                item = item.lPrev;
            }
            if (this.listener != null) {
                this.listener.handleBatchOverflow(localVictims);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementReferenceCount() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.totalRefCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementReferenceCount() {
        Object object = this.refCountLock;
        synchronized (object) {
            --this.totalRefCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementReferenceCount(int count) {
        Object object = this.refCountLock;
        synchronized (object) {
            this.totalRefCount -= count;
        }
    }

    static void unitTest_1() throws Exception {
        String key;
        int i;
        String key2;
        int i2;
        FIFOEJBObjectCache cache = new FIFOEJBObjectCache("UnitTestCache");
        cache.init(512, 0, 0L, 1.0f, null);
        int maxCount = 14;
        ArrayList<String> keys = new ArrayList<String>();
        for (i2 = 0; i2 < maxCount; ++i2) {
            keys.add("K_" + i2);
        }
        for (i2 = 0; i2 < maxCount; ++i2) {
            key2 = (String)keys.get(i2);
            System.out.println("****  put(" + key2 + ", " + key2 + ", i" + (i2 % 2 == 0) + ")");
            cache.put((Object)key2, (Object)key2, i2 % 2 == 0);
        }
        System.out.println("***  Only odd numbered keys must be printed  ***");
        cache.print();
        System.out.println("************************************************");
        for (i2 = 0; i2 < maxCount; ++i2) {
            key2 = (String)keys.get(i2);
            cache.get(key2, i2 % 2 == 1);
        }
        System.out.println("****  NONE SHOULD BE PRINTED ****");
        cache.print();
        System.out.println("************************************************");
        cache.put((Object)"K__15", (Object)"K__15", true);
        cache.put((Object)"K__16", (Object)"K__15", true);
        cache.get("K__16", true);
        cache.put("K__17", "K__17");
        System.out.println("****  Only K__17 must be printed ****");
        cache.print();
        System.out.println("************************************************");
        for (i2 = 0; i2 < maxCount; ++i2) {
            key2 = (String)keys.get(i2);
            if (cache.remove(key2) != null) continue;
            throw new RuntimeException("Remove must have returned null!!");
        }
        Object k15 = cache.remove("K__15");
        Object k16_1 = cache.remove("K__16");
        Object k16_2 = cache.remove("K__16");
        Object k17 = cache.remove("K__17");
        if (k15 == null) {
            System.out.println("** FAILED for K_15");
        }
        if (k16_1 != null) {
            System.out.println("** FAILED for K_16_1");
        }
        if (k16_2 == null) {
            System.out.println("** FAILED for K_16_2");
        }
        if (k17 == null) {
            System.out.println("** FAILED for K_17");
        }
        for (i = 0; i < maxCount; i += 2) {
            key = (String)keys.get(i);
            cache.put((Object)key, (Object)key, i % 4 == 0);
        }
        cache.print();
        for (i = 0; i < maxCount; i += 2) {
            key = (String)keys.get(i);
            cache.get(key, true);
        }
        cache.print();
        for (i = 1; i < maxCount; i += 2) {
            key = (String)keys.get(i);
            cache.put((Object)key, (Object)key, i % 9 == 0);
        }
        cache.print();
    }

    public static void main(String[] args) throws Exception {
        FIFOEJBObjectCache.unitTest_1();
    }

    static {
        try {
            Properties props = System.getProperties();
            _printRefCount = Boolean.valueOf(props.getProperty("cache.printrefcount"));
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Cache PrintRefCount property ex", ex);
        }
    }

    protected static class EJBObjectCacheItem
    extends LruCache.LruCacheItem {
        protected int refCount;

        protected EJBObjectCacheItem(int hashCode, Object key, Object value, int size) {
            super(hashCode, key, value, size);
        }
    }
}

