/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.services;

import com.sun.enterprise.config.serverbeans.Resource;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.javaee.services.ResourceProxy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

@Service
public class ResourcesBinder {
    @Inject
    private GlassfishNamingManager manager;
    @Inject
    private Logger logger;
    @Inject
    private Habitat raProxyHabitat;
    @Inject
    private Habitat genericResourceProxy;

    public void deployResource(String jndiName, Resource resource) {
        try {
            this.bindResource(resource, jndiName);
        }
        catch (NamingException ne) {
            Object[] params = new Object[]{jndiName, ne};
            this.logger.log(Level.SEVERE, "resources.resources-binder.bind-resource-failed", params);
        }
    }

    private void bindResource(Resource resource, String jndiName) throws NamingException {
        ResourceProxy proxy = this.genericResourceProxy.getComponent(ResourceProxy.class);
        proxy.setResource(resource);
        proxy.setJndiName(jndiName);
        this.manager.publishObject(jndiName, (Object)proxy, true);
    }
}

