/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Scope;
import org.jboss.interceptor.model.InterceptionModel;
import org.jboss.interceptor.model.InterceptionModelBuilder;
import org.jboss.interceptor.model.InterceptorMetadata;
import org.jboss.interceptor.util.InterceptionUtils;
import org.jboss.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.interceptor.InterceptionMetadataService;
import org.jboss.weld.bean.interceptor.WeldClassReference;
import org.jboss.weld.bean.proxy.DecorationHelper;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.context.SerializableContextualImpl;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.SecureReflections;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassBean<T>
extends AbstractBean<T, Class<T>> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    protected WeldClass<T> annotatedItem;
    private List<Set<FieldInjectionPoint<?, ?>>> injectableFields;
    private List<Set<MethodInjectionPoint<?, ?>>> initializerMethods;
    private List<Decorator<?>> decorators;
    private Class<T> proxyClassForDecorators;
    private boolean hasSerializationOrInvocationInterceptorMethods;
    private List<WeldMethod<?, ? super T>> postConstructMethods;
    private List<WeldMethod<?, ? super T>> preDestroyMethods;
    private InjectionTarget<T> injectionTarget;
    private ConstructorInjectionPoint<T> constructor;

    protected static Set<Annotation> flattenInterceptorBindings(BeanManagerImpl beanManager, Set<Annotation> annotations) {
        HashSet<Annotation> foundInterceptionBindingTypes = new HashSet<Annotation>();
        for (Annotation annotation : annotations) {
            if (!beanManager.isInterceptorBinding(annotation.annotationType())) continue;
            foundInterceptionBindingTypes.add(annotation);
            foundInterceptionBindingTypes.addAll(beanManager.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(annotation.annotationType()).getInheritedInterceptionBindingTypes());
        }
        return foundInterceptionBindingTypes;
    }

    private static SerializableContextual[] toSerializableContextualArray(List<Interceptor<?>> interceptors) {
        ArrayList serializableContextuals = new ArrayList();
        for (Interceptor<?> interceptor : interceptors) {
            serializableContextuals.add(new SerializableContextualImpl(interceptor));
        }
        return serializableContextuals.toArray(new SerializableContextual[0]);
    }

    protected AbstractClassBean(WeldClass<T> type, String idSuffix, BeanManagerImpl beanManager) {
        super(idSuffix, beanManager);
        this.annotatedItem = type;
        this.initStereotypes();
        this.initAlternative();
        this.initInitializerMethods();
        this.initInjectableFields();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        super.initialize(environment);
        this.checkBeanImplementation();
        if (this.isInterceptionCandidate()) {
            this.initCdiBoundInterceptors();
            this.initDirectlyDefinedInterceptors();
        }
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        this.initDecorators();
        if (this.hasDecorators()) {
            this.initProxyClassForDecoratedBean();
        }
        super.initializeAfterBeanDiscovery();
    }

    public void initDecorators() {
        this.decorators = this.getBeanManager().resolveDecorators(this.getTypes(), this.getQualifiers());
    }

    public boolean hasDecorators() {
        return this.decorators != null && this.decorators.size() > 0;
    }

    protected void initProxyClassForDecoratedBean() {
        this.proxyClassForDecorators = Proxies.createProxyClass(Proxies.TypeInfo.of(this.getTypes()).add((Type)((Object)TargetInstanceProxy.class)));
    }

    protected T applyDecorators(T instance, CreationalContext<T> creationalContext, InjectionPoint originalInjectionPoint) {
        T proxy = null;
        DecorationHelper<Object> decorationHelper = new DecorationHelper<T>(instance, this.proxyClassForDecorators, this.beanManager, this.decorators);
        DecorationHelper.getHelperStack().push(decorationHelper);
        proxy = decorationHelper.getNextDelegate(originalInjectionPoint, creationalContext);
        decorationHelper = DecorationHelper.getHelperStack().pop();
        if (proxy == null) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_FAILED, this);
        }
        return proxy;
    }

    public List<Decorator<?>> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    protected void initType() {
        this.type = this.getWeldAnnotated().getJavaClass();
    }

    protected void initInjectableFields() {
        this.injectableFields = Beans.getFieldInjectionPoints(this, this.annotatedItem);
        this.addInjectionPoints(Beans.getFieldInjectionPoints(this, this.injectableFields));
    }

    protected void initInitializerMethods() {
        this.initializerMethods = Beans.getInitializerMethods(this, this.getWeldAnnotated());
        this.addInjectionPoints(Beans.getParameterInjectionPoints(this, this.initializerMethods));
    }

    @Override
    protected void initScope() {
        for (WeldClass<?> clazz = this.getWeldAnnotated(); clazz != null; clazz = clazz.getWeldSuperclass()) {
            HashSet<Annotation> scopes = new HashSet<Annotation>();
            scopes.addAll(clazz.getDeclaredMetaAnnotations(Scope.class));
            scopes.addAll(clazz.getDeclaredMetaAnnotations(NormalScope.class));
            if (scopes.size() == 1) {
                if (!this.getWeldAnnotated().isAnnotationPresent(((Annotation)scopes.iterator().next()).annotationType())) break;
                this.scope = ((Annotation)scopes.iterator().next()).annotationType();
                log.trace(BeanMessage.USING_SCOPE, this.scope, this);
                break;
            }
            if (scopes.size() <= 1) continue;
            throw new DefinitionException(BeanMessage.ONLY_ONE_SCOPE_ALLOWED, this.getWeldAnnotated());
        }
        if (this.scope == null) {
            this.initScopeFromStereotype();
        }
        if (this.scope == null) {
            this.scope = Dependent.class;
            log.trace(BeanMessage.USING_DEFAULT_SCOPE, this);
        }
    }

    protected void checkBeanImplementation() {
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (this.getWeldAnnotated().getWeldSuperclass() == null || this.getWeldAnnotated().getWeldSuperclass().getJavaClass().equals(Object.class)) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MUST_EXTEND_A_BEAN, this);
        }
    }

    public WeldClass<T> getWeldAnnotated() {
        return this.annotatedItem;
    }

    @Override
    protected String getDefaultName() {
        String name = Introspector.decapitalize(this.getWeldAnnotated().getSimpleName());
        return name;
    }

    public List<? extends Set<? extends MethodInjectionPoint<?, ?>>> getInitializerMethods() {
        return Collections.unmodifiableList(this.initializerMethods);
    }

    public List<? extends Set<FieldInjectionPoint<?, ?>>> getInjectableFields() {
        return Collections.unmodifiableList(this.injectableFields);
    }

    protected void initPostConstruct() {
        this.postConstructMethods = Beans.getPostConstructMethods(this.getWeldAnnotated());
    }

    protected void initPreDestroy() {
        this.preDestroyMethods = Beans.getPreDestroyMethods(this.getWeldAnnotated());
    }

    public List<WeldMethod<?, ? super T>> getPostConstruct() {
        return this.postConstructMethods;
    }

    public List<WeldMethod<?, ? super T>> getPreDestroy() {
        return this.preDestroyMethods;
    }

    protected abstract boolean isInterceptionCandidate();

    protected void initCdiBoundInterceptors() {
        if (this.beanManager.getCdiInterceptorsRegistry().getInterceptionModel(this.getType()) == null) {
            InterceptionModelBuilder builder = InterceptionModelBuilder.newBuilderFor(this.getType(), SerializableContextual.class);
            Set<Annotation> classBindingAnnotations = AbstractClassBean.flattenInterceptorBindings(this.beanManager, this.getWeldAnnotated().getAnnotations());
            for (Class<Annotation> annotation : this.getStereotypes()) {
                classBindingAnnotations.addAll(AbstractClassBean.flattenInterceptorBindings(this.beanManager, this.beanManager.getStereotypeDefinition(annotation)));
            }
            if (classBindingAnnotations.size() > 0) {
                if (Beans.findInterceptorBindingConflicts(this.beanManager, classBindingAnnotations)) {
                    throw new DeploymentException(BeanMessage.CONFLICTING_INTERCEPTOR_BINDINGS, this.getType());
                }
                Annotation[] classBindingAnnotationsArray = classBindingAnnotations.toArray(new Annotation[0]);
                List<Interceptor<?>> resolvedPostConstructInterceptors = this.beanManager.resolveInterceptors(InterceptionType.POST_CONSTRUCT, classBindingAnnotationsArray);
                builder.interceptPostConstruct().with(AbstractClassBean.toSerializableContextualArray(resolvedPostConstructInterceptors));
                List<Interceptor<?>> resolvedPreDestroyInterceptors = this.beanManager.resolveInterceptors(InterceptionType.PRE_DESTROY, classBindingAnnotationsArray);
                builder.interceptPreDestroy().with(AbstractClassBean.toSerializableContextualArray(resolvedPreDestroyInterceptors));
                List<Interceptor<?>> resolvedPrePassivateInterceptors = this.beanManager.resolveInterceptors(InterceptionType.PRE_PASSIVATE, classBindingAnnotationsArray);
                builder.interceptPrePassivate().with(AbstractClassBean.toSerializableContextualArray(resolvedPrePassivateInterceptors));
                List<Interceptor<?>> resolvedPostActivateInterceptors = this.beanManager.resolveInterceptors(InterceptionType.POST_ACTIVATE, classBindingAnnotationsArray);
                builder.interceptPostActivate().with(AbstractClassBean.toSerializableContextualArray(resolvedPostActivateInterceptors));
            }
            List<WeldMethod<?, ?>> businessMethods = Beans.getInterceptableMethods(this.getWeldAnnotated());
            for (WeldMethod<?, ?> method : businessMethods) {
                List<Interceptor<?>> methodBoundInterceptors;
                HashSet<Annotation> methodBindingAnnotations = new HashSet<Annotation>(classBindingAnnotations);
                methodBindingAnnotations.addAll(AbstractClassBean.flattenInterceptorBindings(this.beanManager, method.getAnnotations()));
                if (methodBindingAnnotations.size() <= 0) continue;
                if (Beans.findInterceptorBindingConflicts(this.beanManager, classBindingAnnotations)) {
                    throw new DeploymentException(BeanMessage.CONFLICTING_INTERCEPTOR_BINDINGS, this.getType() + "." + method.getName() + "()");
                }
                if (method.isAnnotationPresent(this.beanManager.getServices().get(EJBApiAbstraction.class).TIMEOUT_ANNOTATION_CLASS)) {
                    methodBoundInterceptors = this.beanManager.resolveInterceptors(InterceptionType.AROUND_TIMEOUT, methodBindingAnnotations.toArray(new Annotation[0]));
                    builder.interceptAroundTimeout(method.getJavaMember()).with(AbstractClassBean.toSerializableContextualArray(methodBoundInterceptors));
                    continue;
                }
                methodBoundInterceptors = this.beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, methodBindingAnnotations.toArray(new Annotation[0]));
                builder.interceptAroundInvoke(method.getJavaMember()).with(AbstractClassBean.toSerializableContextualArray(methodBoundInterceptors));
            }
            InterceptionModel serializableContextualInterceptionModel = builder.build();
            if (serializableContextualInterceptionModel.getAllInterceptors().size() > 0) {
                this.beanManager.getCdiInterceptorsRegistry().registerInterceptionModel(this.getType(), serializableContextualInterceptionModel);
            }
        }
    }

    public void setInjectionTarget(InjectionTarget<T> injectionTarget) {
        this.injectionTarget = injectionTarget;
    }

    public InjectionTarget<T> getInjectionTarget() {
        return this.injectionTarget;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.getInjectionTarget().getInjectionPoints();
    }

    protected void defaultPreDestroy(T instance) {
        for (WeldMethod<?, T> method : this.getPreDestroy()) {
            if (method == null) continue;
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new WeldException(BeanMessage.INVOCATION_ERROR, (Throwable)e, method, instance);
            }
        }
    }

    protected void defaultPostConstruct(T instance) {
        for (WeldMethod<?, T> method : this.getPostConstruct()) {
            if (method == null) continue;
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new WeldException(BeanMessage.INVOCATION_ERROR, (Throwable)e, method, instance);
            }
        }
    }

    public boolean hasCdiBoundInterceptors() {
        if (this.beanManager.getCdiInterceptorsRegistry().getInterceptionModel(this.getType()) != null) {
            return this.beanManager.getCdiInterceptorsRegistry().getInterceptionModel(this.getType()).getAllInterceptors().size() > 0;
        }
        return false;
    }

    public boolean hasDirectlyDefinedInterceptors() {
        if (this.beanManager.getClassDeclaredInterceptorsRegistry().getInterceptionModel(this.getType()) != null) {
            return this.hasSerializationOrInvocationInterceptorMethods || this.beanManager.getClassDeclaredInterceptorsRegistry().getInterceptionModel(this.getType()).getAllInterceptors().size() > 0;
        }
        return false;
    }

    public boolean hasInterceptors() {
        return this.isInterceptionCandidate() && (this.hasCdiBoundInterceptors() || this.hasDirectlyDefinedInterceptors());
    }

    protected void initDirectlyDefinedInterceptors() {
        if (this.beanManager.getClassDeclaredInterceptorsRegistry().getInterceptionModel(this.getType()) == null && InterceptionUtils.supportsEjb3InterceptorDeclaration()) {
            InterceptionModelBuilder builder = InterceptionModelBuilder.newBuilderFor(this.getType(), Class.class);
            Class<?>[] classDeclaredInterceptors = null;
            if (this.getWeldAnnotated().isAnnotationPresent(InterceptionUtils.getInterceptorsAnnotationClass())) {
                Annotation interceptorsAnnotation = this.getType().getAnnotation(InterceptionUtils.getInterceptorsAnnotationClass());
                classDeclaredInterceptors = SecureReflections.extractValues(interceptorsAnnotation);
            }
            if (classDeclaredInterceptors != null) {
                builder.interceptAll().with(classDeclaredInterceptors);
            }
            List<WeldMethod<?, ?>> businessMethods = Beans.getInterceptableMethods(this.getWeldAnnotated());
            for (WeldMethod<?, ?> method : businessMethods) {
                boolean excludeClassInterceptors = method.isAnnotationPresent(InterceptionUtils.getExcludeClassInterceptorsAnnotationClass());
                Class<?>[] methodDeclaredInterceptors = null;
                if (method.isAnnotationPresent(InterceptionUtils.getInterceptorsAnnotationClass())) {
                    methodDeclaredInterceptors = SecureReflections.extractValues(method.getAnnotation(InterceptionUtils.getInterceptorsAnnotationClass()));
                }
                if (excludeClassInterceptors) {
                    builder.ignoreGlobalInterceptors(method.getJavaMember());
                }
                if (methodDeclaredInterceptors == null) continue;
                if (method.isAnnotationPresent(this.beanManager.getServices().get(EJBApiAbstraction.class).TIMEOUT_ANNOTATION_CLASS)) {
                    builder.interceptAroundTimeout(method.getJavaMember()).with(methodDeclaredInterceptors);
                    continue;
                }
                builder.interceptAroundInvoke(method.getJavaMember()).with(methodDeclaredInterceptors);
            }
            InterceptionModel interceptionModel = builder.build();
            InterceptorMetadata interceptorClassMetadata = this.beanManager.getServices().get(InterceptionMetadataService.class).getInterceptorMetadataRegistry().getInterceptorClassMetadata(WeldClassReference.of(this.getWeldAnnotated()), true);
            boolean bl = this.hasSerializationOrInvocationInterceptorMethods = !interceptorClassMetadata.getInterceptorMethods(org.jboss.interceptor.model.InterceptionType.AROUND_INVOKE).isEmpty() || !interceptorClassMetadata.getInterceptorMethods(org.jboss.interceptor.model.InterceptionType.AROUND_TIMEOUT).isEmpty() || !interceptorClassMetadata.getInterceptorMethods(org.jboss.interceptor.model.InterceptionType.PRE_PASSIVATE).isEmpty() || !interceptorClassMetadata.getInterceptorMethods(org.jboss.interceptor.model.InterceptionType.POST_ACTIVATE).isEmpty();
            if (interceptionModel.getAllInterceptors().size() > 0 || this.hasSerializationOrInvocationInterceptorMethods) {
                this.beanManager.getClassDeclaredInterceptorsRegistry().registerInterceptionModel(this.getType(), builder.build());
            }
        } else {
            InterceptorMetadata interceptorClassMetadata = this.beanManager.getServices().get(InterceptionMetadataService.class).getInterceptorMetadataRegistry().getInterceptorClassMetadata(WeldClassReference.of(this.getWeldAnnotated()), true);
            this.hasSerializationOrInvocationInterceptorMethods = !interceptorClassMetadata.getInterceptorMethods(org.jboss.interceptor.model.InterceptionType.AROUND_INVOKE).isEmpty() || !interceptorClassMetadata.getInterceptorMethods(org.jboss.interceptor.model.InterceptionType.AROUND_TIMEOUT).isEmpty() || !interceptorClassMetadata.getInterceptorMethods(org.jboss.interceptor.model.InterceptionType.PRE_PASSIVATE).isEmpty() || !interceptorClassMetadata.getInterceptorMethods(org.jboss.interceptor.model.InterceptionType.POST_ACTIVATE).isEmpty();
        }
    }

    protected void checkConstructor() {
        if (!this.constructor.getWeldParameters(Disposes.class).isEmpty()) {
            throw new DefinitionException(BeanMessage.PARAMETER_ANNOTATION_NOT_ALLOWED_ON_CONSTRUCTOR, "@Disposes", this.constructor);
        }
        if (!this.constructor.getWeldParameters(Observes.class).isEmpty()) {
            throw new DefinitionException(BeanMessage.PARAMETER_ANNOTATION_NOT_ALLOWED_ON_CONSTRUCTOR, "@Observes", this.constructor);
        }
    }

    protected void initConstructor() {
        this.constructor = Beans.getBeanConstructor(this, this.getWeldAnnotated());
        this.addInjectionPoints(Beans.getParameterInjectionPoints(this, this.constructor));
    }

    public ConstructorInjectionPoint<T> getConstructor() {
        return this.constructor;
    }
}

