/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.auth;

import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class Ntlm {
    private PrintStream debugout;

    public Ntlm(PrintStream debugout) {
        this.debugout = debugout;
    }

    public String generateType1Msg(boolean useUnicode, int flags, String domain, String workstation) throws IOException {
        try {
            Class<?> t1MClass = Class.forName("jcifs.ntlmssp.Type1Message");
            Constructor<?> t1Mconstructor = t1MClass.getConstructor(Integer.TYPE, String.class, String.class);
            Object t1m = t1Mconstructor.newInstance(new Integer(flags), domain, workstation);
            if (this.debugout != null) {
                this.debugout.println("DEBUG NTLM: type 1 message: " + t1m);
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            BASE64EncoderStream out = new BASE64EncoderStream(bout, Integer.MAX_VALUE);
            if (this.debugout != null) {
                this.debugout.println("DEBUG NTLM: type 1 message length: " + ((byte[])t1MClass.getMethod("toByteArray", new Class[0]).invoke(t1m, null)).length);
            }
            out.write((byte[])t1MClass.getMethod("toByteArray", new Class[0]).invoke(t1m, null));
            out.flush();
            out.close();
            return new String(bout.toByteArray());
        }
        catch (IOException ioex) {
            if (this.debugout != null) {
                ioex.printStackTrace(this.debugout);
            }
            throw ioex;
        }
        catch (Exception ex) {
            if (this.debugout != null) {
                ex.printStackTrace(this.debugout);
            }
            return null;
        }
    }

    public String generateType3Msg(String username, String password, String domain, String workstation, String challenge, int flags, int lmCompatibility) throws IOException {
        try {
            Object t2m;
            Class<?> t2MClass = Class.forName("jcifs.ntlmssp.Type2Message");
            Constructor<?> t2Mconstructor = t2MClass.getConstructor(Class.forName("[B"));
            try {
                BASE64DecoderStream in = new BASE64DecoderStream(new ByteArrayInputStream(challenge.getBytes()));
                byte[] bytes = new byte[in.available()];
                in.read(bytes);
                t2m = t2Mconstructor.newInstance(new Object[]{bytes});
            }
            catch (IOException ex) {
                IOException ioex = new IOException("Invalid Type2 message");
                ioex.initCause(ex);
                throw ioex;
            }
            Class<?> t3MClass = Class.forName("jcifs.ntlmssp.Type3Message");
            Constructor<?> t3Mconstructor = t3MClass.getConstructor(t2MClass, String.class, String.class, String.class, String.class, Integer.TYPE);
            Object t3m = t3Mconstructor.newInstance(t2m, password, domain == null ? "" : domain, username, workstation, new Integer(flags));
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            BASE64EncoderStream out = new BASE64EncoderStream(bout, Integer.MAX_VALUE);
            out.write((byte[])t3MClass.getMethod("toByteArray", new Class[0]).invoke(t3m, null));
            out.flush();
            out.close();
            return new String(bout.toByteArray());
        }
        catch (InvocationTargetException itex) {
            Throwable t;
            if (this.debugout != null) {
                itex.printStackTrace(this.debugout);
            }
            if ((t = itex.getTargetException()) instanceof IOException) {
                throw (IOException)t;
            }
            IOException ioex = new IOException("Ntlm.generateType3Msg failed; Exception: " + t);
            ioex.initCause(itex);
            throw ioex;
        }
        catch (IOException ioex) {
            if (this.debugout != null) {
                ioex.printStackTrace(this.debugout);
            }
            throw ioex;
        }
        catch (Exception ex) {
            if (this.debugout != null) {
                ex.printStackTrace(this.debugout);
            }
            return null;
        }
    }
}

