/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore;

import org.jboss.weld.exceptions.ForbiddenArgumentException;
import org.jboss.weld.logging.messages.ContextMessage;

public class NamingScheme {
    public String prefix;
    public String delimiter;

    public NamingScheme(String prefix, String delimiter) {
        if (prefix.indexOf(delimiter) >= 0) {
            throw new ForbiddenArgumentException(ContextMessage.DELIMITER_IN_PREFIX, delimiter, prefix);
        }
        this.prefix = prefix;
        this.delimiter = delimiter;
    }

    public boolean acceptKey(String key) {
        return key.startsWith(this.prefix);
    }

    public String getId(String key) {
        return key.substring(this.prefix.length() + this.delimiter.length());
    }

    public String getKey(String id) {
        return this.prefix + this.delimiter + id;
    }
}

