/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLChoiceFieldToClassAssociation;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLEntry;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLChoiceCollectionMapping
extends DatabaseMapping
implements XMLMapping {
    private Map<XMLField, Class> fieldToClassMappings = new HashMap<XMLField, Class>();
    private Map<Class, XMLField> classToFieldMappings;
    private Map<XMLField, XMLMapping> choiceElementMappings;
    private Map<XMLField, String> fieldToClassNameMappings = new HashMap<XMLField, String>();
    private Map<XMLField, Converter> fieldsToConverters;
    private ContainerPolicy containerPolicy;
    private boolean isWriteOnly;
    private static final AttributeAccessor temporaryAccessor = new InstanceVariableAttributeAccessor();
    private boolean reuseContainer;
    private Converter converter;

    public XMLChoiceCollectionMapping() {
        this.classToFieldMappings = new HashMap<Class, XMLField>();
        this.choiceElementMappings = new HashMap<XMLField, XMLMapping>();
        this.fieldsToConverters = new HashMap<XMLField, Converter>();
        this.containerPolicy = ContainerPolicy.buildDefaultPolicy();
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    @Override
    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildBackupClone");
    }

    @Override
    public void buildClone(Object original, Object clone, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildClone");
    }

    @Override
    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildCloneFromRow");
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    @Override
    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareForChange");
    }

    @Override
    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareObjects");
    }

    @Override
    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        throw DescriptorException.invalidMappingOperation(this, "fixObjectReferences");
    }

    @Override
    public void iterate(DescriptorIterator iterator) {
        throw DescriptorException.invalidMappingOperation(this, "iterate");
    }

    @Override
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        throw DescriptorException.invalidMappingOperation(this, "mergeChangesIntoObject");
    }

    @Override
    public void mergeIntoObject(Object target, boolean isTargetUninitialized, Object source, MergeManager mergeManager) {
        throw DescriptorException.invalidMappingOperation(this, "mergeIntoObject");
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        List<XMLEntry> values = ((DOMRecord)row).getValuesIndicatingNoEntry(this.getFields());
        Object container = this.getContainerPolicy().containerInstance(values.size());
        for (XMLEntry next : values) {
            Object value;
            DatabaseMapping xmlMapping;
            XMLField valueField = next.getXMLField();
            DatabaseMapping nextMapping = (DatabaseMapping)((Object)this.choiceElementMappings.get(valueField));
            Converter converter = this.getConverter();
            if (nextMapping.isAbstractCompositeCollectionMapping()) {
                xmlMapping = (XMLCompositeCollectionMapping)nextMapping;
                value = ((XMLCompositeCollectionMapping)xmlMapping).buildObjectFromNestedRow((AbstractRecord)next.getValue(), joinManager, sourceQuery, executionSession);
                if (converter != null) {
                    value = converter instanceof XMLConverter ? ((XMLConverter)converter).convertDataValueToObjectValue(value, executionSession, ((XMLRecord)row).getUnmarshaller()) : converter.convertDataValueToObjectValue(value, executionSession);
                }
                this.getContainerPolicy().addInto(value, container, executionSession);
                continue;
            }
            xmlMapping = (XMLCompositeDirectCollectionMapping)nextMapping;
            value = next.getValue();
            if (converter != null) {
                value = converter instanceof XMLConverter ? ((XMLConverter)converter).convertDataValueToObjectValue(value, executionSession, ((XMLRecord)row).getUnmarshaller()) : converter.convertDataValueToObjectValue(value, executionSession);
            }
            this.getContainerPolicy().addInto(value, container, executionSession);
        }
        return container;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session) throws DescriptorException {
        Object attributeValue = this.getAttributeValueFromObject(object);
        ArrayList<XMLEntry> nestedRows = new ArrayList<XMLEntry>();
        XMLRecord record = (XMLRecord)row;
        ContainerPolicy cp = this.getContainerPolicy();
        Object iterator = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iterator)) {
            Object value = cp.next(iterator, session);
            if (null != this.converter) {
                value = this.converter instanceof XMLConverter ? ((XMLConverter)this.converter).convertObjectValueToDataValue(value, session, record.getMarshaller()) : this.converter.convertObjectValueToDataValue(value, session);
            }
            Object associatedNodeValue = null;
            XMLField associatedField = null;
            Object fieldValue = value;
            if (value instanceof XMLRoot) {
                XMLRoot rootValue = (XMLRoot)value;
                String localName = rootValue.getLocalName();
                String namespaceUri = rootValue.getNamespaceURI();
                fieldValue = rootValue.getObject();
                associatedField = this.getFieldForName(localName, namespaceUri);
                if (associatedField == null) {
                    associatedField = this.getClassToFieldMappings().get(fieldValue.getClass());
                }
            } else {
                associatedField = this.getClassToFieldMappings().get(value.getClass());
            }
            DatabaseMapping xmlMapping = (DatabaseMapping)((Object)this.choiceElementMappings.get(associatedField));
            if (xmlMapping.isAbstractCompositeCollectionMapping()) {
                fieldValue = ((XMLCompositeCollectionMapping)xmlMapping).buildCompositeRow(fieldValue, session, row);
            }
            XMLEntry entry = new XMLEntry();
            entry.setValue(fieldValue);
            entry.setXMLField(associatedField);
            nestedRows.add(entry);
        }
        ((DOMRecord)row).put(this.getFields(), (Object)nestedRows);
    }

    private XMLField getFieldForName(String localName, String namespaceUri) {
        for (XMLField xMLField : this.getFields()) {
            for (XPathFragment fragment = xMLField.getXPathFragment(); fragment != null && !fragment.nameIsText(); fragment = fragment.getNextFragment()) {
                if (fragment.getNextFragment() != null && !fragment.getHasText() || !fragment.getLocalName().equals(localName)) continue;
                String fragUri = fragment.getNamespaceURI();
                if ((namespaceUri != null || fragUri != null) && (namespaceUri == null || fragUri == null || !namespaceUri.equals(fragUri))) continue;
                return xMLField;
            }
        }
        return null;
    }

    @Override
    public void writeSingleValue(Object value, Object parent, XMLRecord row, AbstractSession session) {
    }

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public Vector<DatabaseField> getFields() {
        if (this.fields == null || this.fields.size() == 0) {
            this.fields = this.collectFields();
        }
        return this.fields;
    }

    @Override
    protected Vector<DatabaseField> collectFields() {
        return new Vector<DatabaseField>(this.fieldToClassMappings.keySet());
    }

    public void addChoiceElement(String xpath, Class elementType) {
        XMLField field = new XMLField(xpath);
        this.addChoiceElement(field, elementType);
    }

    public void addChoiceElement(String xpath, String elementTypeName) {
        XMLField field = new XMLField(xpath);
        this.addChoiceElement(field, elementTypeName);
    }

    public void addChoiceElement(XMLField xmlField, Class elementType) {
        this.getFieldToClassMappings().put(xmlField, elementType);
        if (!this.fieldToClassNameMappings.containsKey(xmlField)) {
            this.fieldToClassNameMappings.put(xmlField, elementType.getName());
        }
        if (this.classToFieldMappings.get(elementType) == null) {
            this.classToFieldMappings.put(elementType, xmlField);
        }
        this.addChoiceElementMapping(xmlField, elementType);
    }

    public void addChoiceElement(XMLField field, String elementTypeName) {
        this.fieldToClassNameMappings.put(field, elementTypeName);
        this.addChoiceElementMapping(field, elementTypeName);
    }

    public Map<XMLField, Class> getFieldToClassMappings() {
        return this.fieldToClassMappings;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.fieldToClassMappings.size() == 0) {
            this.convertClassNamesToClasses(((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).getLoader());
        }
        for (DatabaseMapping databaseMapping : this.getChoiceElementMappings().values()) {
            Converter converter = null;
            if (this.fieldsToConverters != null) {
                converter = this.fieldsToConverters.get(databaseMapping.getField());
            }
            if (databaseMapping.isAbstractCompositeDirectCollectionMapping()) {
                XMLConversionManager xmlConversionManager = (XMLConversionManager)session.getDatasourcePlatform().getConversionManager();
                QName schemaType = (QName)xmlConversionManager.getDefaultJavaTypes().get(((AbstractCompositeDirectCollectionMapping)databaseMapping).getAttributeElementClass());
                if (schemaType != null) {
                    ((XMLField)databaseMapping.getField()).setSchemaType(schemaType);
                }
                if (converter != null) {
                    ((AbstractCompositeDirectCollectionMapping)databaseMapping).setValueConverter(converter);
                }
                ((AbstractCompositeDirectCollectionMapping)databaseMapping).setContainerPolicy(this.getContainerPolicy());
            } else {
                if (converter != null) {
                    ((AbstractCompositeCollectionMapping)databaseMapping).setConverter(converter);
                }
                ((AbstractCompositeCollectionMapping)databaseMapping).setContainerPolicy(this.getContainerPolicy());
            }
            databaseMapping.initialize(session);
        }
    }

    public Map<Class, XMLField> getClassToFieldMappings() {
        return this.classToFieldMappings;
    }

    public Map<XMLField, XMLMapping> getChoiceElementMappings() {
        return this.choiceElementMappings;
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public void setContainerPolicy(ContainerPolicy cp) {
        this.containerPolicy = cp;
    }

    public void useCollectionClass(Class concreteContainerClass) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(concreteContainerClass));
    }

    public void useCollectionClassName(String concreteContainerClassName) {
        this.setContainerPolicy(new CollectionContainerPolicy(concreteContainerClassName));
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        for (Map.Entry<XMLField, String> entry : this.fieldToClassNameMappings.entrySet()) {
            Class elementType;
            block7: {
                String className = entry.getValue();
                elementType = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            elementType = (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, classLoader));
                            break block7;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(className, exception.getException());
                        }
                    }
                    elementType = PrivilegedAccessHelper.getClassForName(className, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(className, exc);
                }
            }
            if (this.classToFieldMappings.get(elementType) == null) {
                this.classToFieldMappings.put(elementType, entry.getKey());
            }
            if (this.fieldToClassMappings.get(entry.getKey()) != null) continue;
            this.fieldToClassMappings.put(entry.getKey(), elementType);
        }
    }

    public void addConverter(XMLField field, Converter converter) {
        if (this.fieldsToConverters == null) {
            this.fieldsToConverters = new HashMap<XMLField, Converter>();
        }
        this.fieldsToConverters.put(field, converter);
    }

    public Converter getConverter(XMLField field) {
        if (null != this.fieldsToConverters) {
            Converter converter = this.fieldsToConverters.get(field);
            if (null != converter) {
                return converter;
            }
            if (null != this.choiceElementMappings) {
                DatabaseMapping mapping = (DatabaseMapping)((Object)this.choiceElementMappings.get(field));
                if (null == mapping) {
                    return null;
                }
                if (mapping.isAbstractCompositeDirectCollectionMapping()) {
                    return ((XMLCompositeDirectCollectionMapping)mapping).getValueConverter();
                }
                if (mapping.isAbstractDirectMapping()) {
                    return ((XMLDirectMapping)mapping).getConverter();
                }
            }
        }
        return null;
    }

    public ArrayList getChoiceFieldToClassAssociations() {
        ArrayList<XMLChoiceFieldToClassAssociation> associations = new ArrayList<XMLChoiceFieldToClassAssociation>();
        if (this.fieldToClassNameMappings.size() > 0) {
            for (XMLField xmlField : this.fieldToClassNameMappings.keySet()) {
                String className = this.fieldToClassNameMappings.get(xmlField);
                XMLChoiceFieldToClassAssociation association = new XMLChoiceFieldToClassAssociation(xmlField, className);
                associations.add(association);
            }
        }
        return associations;
    }

    public void setChoiceFieldToClassAssociations(ArrayList associations) {
        if (associations.size() > 0) {
            for (Object next : associations) {
                XMLChoiceFieldToClassAssociation association = (XMLChoiceFieldToClassAssociation)next;
                this.addChoiceElement(association.getXmlField(), association.getClassName());
                if (association.getConverter() == null) continue;
                this.addConverter(association.getXmlField(), association.getConverter());
            }
        }
    }

    private void addChoiceElementMapping(XMLField xmlField, String className) {
        if (xmlField.getLastXPathFragment().nameIsText()) {
            XMLCompositeDirectCollectionMapping xmlMapping = new XMLCompositeDirectCollectionMapping();
            Class theClass = XMLConversionManager.getDefaultXMLManager().convertClassNameToClass(className);
            xmlMapping.setAttributeElementClass(theClass);
            xmlMapping.setField(xmlField);
            xmlMapping.setAttributeAccessor(temporaryAccessor);
            this.choiceElementMappings.put(xmlField, xmlMapping);
        } else {
            XMLCompositeCollectionMapping xmlMapping = new XMLCompositeCollectionMapping();
            if (!className.equals("java.lang.Object")) {
                xmlMapping.setReferenceClassName(className);
            }
            xmlMapping.setField(xmlField);
            xmlMapping.setAttributeAccessor(temporaryAccessor);
            this.choiceElementMappings.put(xmlField, xmlMapping);
        }
    }

    private void addChoiceElementMapping(XMLField xmlField, Class theClass) {
        if (xmlField.getLastXPathFragment().nameIsText()) {
            XMLCompositeDirectCollectionMapping xmlMapping = new XMLCompositeDirectCollectionMapping();
            xmlMapping.setAttributeElementClass(theClass);
            xmlMapping.setField(xmlField);
            xmlMapping.setAttributeAccessor(temporaryAccessor);
            this.choiceElementMappings.put(xmlField, xmlMapping);
        } else {
            XMLCompositeCollectionMapping xmlMapping = new XMLCompositeCollectionMapping();
            if (!theClass.equals(ClassConstants.OBJECT)) {
                xmlMapping.setReferenceClass(theClass);
            }
            xmlMapping.setField(xmlField);
            xmlMapping.setAttributeAccessor(temporaryAccessor);
            this.choiceElementMappings.put(xmlField, xmlMapping);
        }
    }

    @Override
    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    @Override
    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        this.getAttributeAccessor().setIsWriteOnly(this.isWriteOnly());
        this.getAttributeAccessor().setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
        for (DatabaseMapping databaseMapping : this.getChoiceElementMappings().values()) {
            databaseMapping.setAttributeName(this.getAttributeName());
            if (databaseMapping.getAttributeAccessor() == temporaryAccessor) {
                databaseMapping.setAttributeAccessor(this.getAttributeAccessor());
            }
            databaseMapping.setDescriptor(this.getDescriptor());
            databaseMapping.preInitialize(session);
        }
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }

    public boolean getReuseContainer() {
        return this.reuseContainer;
    }

    public void setReuseContainer(boolean reuseContainer) {
        this.reuseContainer = reuseContainer;
    }
}

