/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.ha.util.PersistenceTypeResolver;
import com.sun.enterprise.web.MemoryStrategyBuilder;
import com.sun.enterprise.web.PersistenceStrategyBuilder;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.session.PersistenceType;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Context;

public class PersistenceStrategyBuilderFactory {
    private static final Logger _logger = LogDomains.getLogger(PersistenceStrategyBuilderFactory.class, (String)"javax.enterprise.system.container.web");
    private static final String COHERENCE_WEB_PACKAGE = "com.tangosol.coherence.servlet.glassfish";
    private String _eeBuilderPath = null;
    private ServerConfigLookup serverConfigLookup;

    public PersistenceStrategyBuilderFactory(ServerConfigLookup serverConfigLookup) {
        this.serverConfigLookup = serverConfigLookup;
        this._eeBuilderPath = serverConfigLookup.getEEBuilderPathFromConfig();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("_eeBuilderPath = " + this._eeBuilderPath);
        }
    }

    private String getEEBuilderPath() {
        return this._eeBuilderPath;
    }

    public PersistenceStrategyBuilder createPersistenceStrategyBuilder(String persistenceType, String frequency, String scope, Context ctx) {
        String resolvedPersistenceType = null;
        String resolvedPersistenceFrequency = null;
        String resolvedPersistenceScope = null;
        PersistenceTypeResolver persistenceTypeResolver = this.getPersistenceTypeResolver();
        resolvedPersistenceType = persistenceTypeResolver != null ? persistenceTypeResolver.resolvePersistenceType(persistenceType) : persistenceType;
        if (!resolvedPersistenceType.equalsIgnoreCase("memory") && !resolvedPersistenceType.equalsIgnoreCase("file")) {
            resolvedPersistenceFrequency = frequency;
            resolvedPersistenceScope = scope;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("resolvedPersistenceType = " + resolvedPersistenceType);
            _logger.finest("resolvedPersistenceFrequency = " + resolvedPersistenceFrequency);
            _logger.finest("resolvedPersistenceScope = " + resolvedPersistenceScope);
        }
        String passedInPersistenceType = persistenceType;
        PersistenceStrategyBuilder builder = new MemoryStrategyBuilder();
        String className = this.createClassNameFrom(resolvedPersistenceType, resolvedPersistenceFrequency, resolvedPersistenceScope);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("PersistenceStrategyBuilderFactory>>createPersistenceStrategyBuilder: CandidateBuilderClassName = " + className);
        }
        try {
            builder = (PersistenceStrategyBuilder)Class.forName(className).newInstance();
        }
        catch (Exception ex) {
            Object[] params = new Object[]{this.getApplicationId(ctx), persistenceType, frequency, scope};
            _logger.log(Level.WARNING, "webcontainer.invalidSessionManagerConfig", params);
        }
        builder.setPersistenceFrequency(frequency);
        builder.setPersistenceScope(scope);
        builder.setPassedInPersistenceType(passedInPersistenceType);
        return builder;
    }

    PersistenceStrategyBuilder createPersistenceStrategyBuilder(String persistenceType, String frequency, String scope) {
        String passedInPersistenceType = persistenceType;
        PersistenceStrategyBuilder builder = new MemoryStrategyBuilder();
        String className = this.createClassNameFrom(persistenceType, frequency, scope);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("PersistenceStrategyBuilderFactory>>createPersistenceStrategyBuilder: CandidateBuilderClassName = " + className);
        }
        try {
            builder = (PersistenceStrategyBuilder)Class.forName(className).newInstance();
        }
        catch (Exception ex) {
            Object[] params = new Object[]{persistenceType, frequency, scope};
            _logger.log(Level.WARNING, "webcontainer.invalidSessionManagerConfig", params);
        }
        builder.setPersistenceFrequency(frequency);
        builder.setPersistenceScope(scope);
        builder.setPassedInPersistenceType(passedInPersistenceType);
        return builder;
    }

    private PersistenceTypeResolver getPersistenceTypeResolver() {
        String resolverClassName = "com.sun.enterprise.ee.web.sessmgmt.EEPersistenceTypeResolver";
        PersistenceTypeResolver persistenceTypeResolver = null;
        try {
            persistenceTypeResolver = (PersistenceTypeResolver)Class.forName(resolverClassName).newInstance();
        }
        catch (Exception ex) {
            _logger.finest("unable to create persistence type resolver");
        }
        return persistenceTypeResolver;
    }

    public String getApplicationId(Context ctx) {
        return ((WebModule)ctx).getID();
    }

    private String createClassNameFrom(String persistenceType, String frequency, String scope) {
        StringBuilder sb = new StringBuilder();
        String pkg = this.getClass().getPackage().getName();
        if (!persistenceType.equalsIgnoreCase("memory") && !persistenceType.equalsIgnoreCase("file")) {
            pkg = persistenceType.equalsIgnoreCase(PersistenceType.COHERENCE_WEB.getType()) ? COHERENCE_WEB_PACKAGE : this.getEEBuilderPath();
        }
        sb.append(pkg + ".");
        sb.append(this.camelCase(persistenceType));
        if (frequency != null) {
            sb.append(this.camelCase(frequency));
        }
        if (scope != null) {
            sb.append(this.camelCase(scope));
        }
        sb.append("StrategyBuilder");
        return sb.toString();
    }

    private String camelCase(String inputString) {
        String strippedString = this.stripNonAlphas(inputString);
        String firstLetter = strippedString.substring(0, 1).toUpperCase();
        String remainingPart = strippedString.substring(1, strippedString.length()).toLowerCase();
        return firstLetter + remainingPart;
    }

    private String stripNonAlphas(String inputString) {
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i < inputString.length(); ++i) {
            char nextChar = inputString.charAt(i);
            if (!Character.isLetter(nextChar)) continue;
            sb.append(nextChar);
        }
        return sb.toString();
    }
}

