/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmaki.runtime.CombinedResource;

public class CombinedResourceServlet
extends HttpServlet {
    private static boolean rDebug = false;
    private Logger logger = null;
    private ServletContext context;
    private boolean gzip = true;

    public void init(ServletConfig config) throws ServletException {
        String gzipString;
        super.init(config);
        this.context = config.getServletContext();
        boolean destroyCacheOnDeploy = true;
        String destroyCacheOnDeployString = this.context.getInitParameter("jmaki-destroyCacheOnDeploy");
        if (this.context.getInitParameter("jmaki-cache-destroyCacheOnDeploy") == null) {
            destroyCacheOnDeployString = this.context.getInitParameter("jmaki-cache-destroyCacheOnDeploy");
        }
        if (destroyCacheOnDeployString != null) {
            if ("false".equals(destroyCacheOnDeployString)) {
                destroyCacheOnDeploy = false;
            } else if ("true".equals(destroyCacheOnDeployString)) {
                destroyCacheOnDeploy = true;
            }
        }
        if (destroyCacheOnDeploy) {
            this.getLogger().severe("CombinedResourceServlet: Destroying cache.");
            if (this.context.getAttribute("JMAKI_JS_RESOURCES") != null) {
                this.context.setAttribute("JMAKI_JS_RESOURCES", null);
            }
            if (this.context.getAttribute("JMAKI_CSS_RESOURCES") != null) {
                this.context.setAttribute("JMAKI_CSS_RESOURCES", null);
            }
        }
        if (this.context.getInitParameter("jmaki-cache-gzip") != null && "false".equals(gzipString = this.context.getInitParameter("jmaki-cache-gzip"))) {
            this.gzip = false;
        }
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger("jmaki.runtime.Log");
        }
        return this.logger;
    }

    private void logMessage(String message) {
        if (rDebug) {
            this.getLogger().info(message);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        try {
            if (req.getParameter("id") != null) {
                String id = req.getParameter("id").toLowerCase();
                int index = id.indexOf(".");
                String target = null;
                String type = null;
                if (index != -1 && index + 1 < id.length()) {
                    target = id.substring(0, index);
                    type = id.substring(index + 1, id.length());
                }
                if (target != null && type != null) {
                    CombinedResource cr = null;
                    if ("js".equals(type) && this.context.getAttribute("JMAKI_JS_RESOURCES") != null) {
                        Hashtable scripts = (Hashtable)this.context.getAttribute("JMAKI_JS_RESOURCES");
                        cr = (CombinedResource)scripts.get(target);
                    } else if ("css".equals(type) && this.context.getAttribute("JMAKI_CSS_RESOURCES") != null) {
                        Hashtable styles = (Hashtable)this.context.getAttribute("JMAKI_CSS_RESOURCES");
                        cr = (CombinedResource)styles.get(target);
                    }
                    if (cr != null) {
                        PrintWriter out;
                        String etag = cr.getContentHash();
                        String ifNoneMatch = req.getHeader("If-None-Match");
                        if (etag != null && ifNoneMatch != null && ifNoneMatch.equals(etag)) {
                            res.setStatus(304);
                        }
                        res.setHeader("Expires", cr.getExpires());
                        res.setHeader("Cache-Control", "public,max-age=" + cr.getMaxAge());
                        if (etag != null) {
                            res.setHeader("ETag", etag);
                        }
                        boolean canGzip = false;
                        if (this.gzip) {
                            Enumeration hnum = req.getHeaders("Accept-Encoding");
                            while (hnum.hasMoreElements()) {
                                String acceptType = (String)hnum.nextElement();
                                if (!"gzip".equals(acceptType)) continue;
                                canGzip = true;
                                break;
                            }
                        }
                        if (this.gzip && canGzip) {
                            res.setHeader("Content-Encoding", "gzip");
                            out = res.getOutputStream();
                            byte[] bytes = cr.getGZippedContent();
                            if (bytes != null) {
                                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                                this.writeBinaryResource(bis, (OutputStream)((Object)out));
                            }
                        } else {
                            res.setHeader("Content-Type", cr.getContentType());
                            out = res.getWriter();
                            out.println(cr.getContent().toString());
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logMessage("CombinedResourceServlet : Error wrtting resource " + ex);
        }
    }

    private void writeBinaryResource(InputStream in, OutputStream out) {
        byte[] bytes = new byte[1024];
        try {
            int read = 0;
            while ((read = in.read(bytes)) > 0) {
                out.write(bytes, 0, read);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            System.out.println("CombinedResourceServlet stream error : " + e);
        }
    }
}

