/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.naming.ResourceRef;

public class BeanFactory
implements ObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        if (obj instanceof ResourceRef) {
            try {
                Reference ref = (Reference)obj;
                String beanClassName = ref.getClassName();
                Class<?> beanClass = null;
                ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                if (tcl != null) {
                    try {
                        beanClass = tcl.loadClass(beanClassName);
                    }
                    catch (ClassNotFoundException e) {
                        throw (NamingException)new NamingException().initCause(e);
                    }
                }
                try {
                    beanClass = Class.forName(beanClassName);
                }
                catch (ClassNotFoundException e) {
                    throw (NamingException)new NamingException().initCause(e);
                }
                if (beanClass == null) {
                    throw new NamingException("Class not found: " + beanClassName);
                }
                BeanInfo bi = Introspector.getBeanInfo(beanClass);
                PropertyDescriptor[] pda = bi.getPropertyDescriptors();
                Object bean = beanClass.newInstance();
                Enumeration<RefAddr> e = ref.getAll();
                while (e.hasMoreElements()) {
                    RefAddr ra = e.nextElement();
                    String propName = ra.getType();
                    if (propName.equals("factory") || propName.equals("scope") || propName.equals("auth")) continue;
                    String value = (String)ra.getContent();
                    Object[] valueArray = new Object[1];
                    int i = 0;
                    for (i = 0; i < pda.length; ++i) {
                        if (!pda[i].getName().equals(propName)) continue;
                        Class<?> propType = pda[i].getPropertyType();
                        if (propType.equals(String.class)) {
                            valueArray[0] = value;
                        } else if (propType.equals(Character.class) || propType.equals(Character.TYPE)) {
                            valueArray[0] = Character.valueOf(value.charAt(0));
                        } else if (propType.equals(Byte.class) || propType.equals(Byte.TYPE)) {
                            valueArray[0] = Byte.valueOf(value);
                        } else if (propType.equals(Short.class) || propType.equals(Short.TYPE)) {
                            valueArray[0] = Short.valueOf(value);
                        } else if (propType.equals(Integer.class) || propType.equals(Integer.TYPE)) {
                            valueArray[0] = Integer.valueOf(value);
                        } else if (propType.equals(Long.class) || propType.equals(Long.TYPE)) {
                            valueArray[0] = Long.valueOf(value);
                        } else if (propType.equals(Float.class) || propType.equals(Float.TYPE)) {
                            valueArray[0] = Float.valueOf(value);
                        } else if (propType.equals(Double.class) || propType.equals(Double.TYPE)) {
                            valueArray[0] = Double.valueOf(value);
                        } else {
                            throw new NamingException("String conversion for property type '" + propType.getName() + "' not available");
                        }
                        Method setProp = pda[i].getWriteMethod();
                        if (setProp != null) {
                            setProp.invoke(bean, valueArray);
                            break;
                        }
                        throw new NamingException("Write not allowed for property: " + propName);
                    }
                    if (i != pda.length) continue;
                    throw new NamingException("No set method found for property: " + propName);
                }
                return bean;
            }
            catch (IntrospectionException ie) {
                throw new NamingException(ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new NamingException(iae.getMessage());
            }
            catch (InstantiationException ie2) {
                throw new NamingException(ie2.getMessage());
            }
            catch (InvocationTargetException ite) {
                throw new NamingException(ite.getMessage());
            }
        }
        return null;
    }
}

