/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.enterprise.deployment.InterceptorDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.InvocationContext;

public class SystemInterceptorProxy {
    public Object delegate;
    private Method postConstruct;
    private Method preDestroy;
    private Method aroundInvoke;
    private Method aroundTimeout;

    public void setDelegate(Object d) {
        Class<?> delegateClass = d.getClass();
        try {
            for (Method m : delegateClass.getDeclaredMethods()) {
                if (m.getAnnotation(PostConstruct.class) != null) {
                    this.postConstruct = m;
                    this.prepareMethod(m);
                    continue;
                }
                if (m.getAnnotation(PreDestroy.class) != null) {
                    this.preDestroy = m;
                    this.prepareMethod(m);
                    continue;
                }
                if (m.getAnnotation(AroundInvoke.class) != null) {
                    this.aroundInvoke = m;
                    this.prepareMethod(m);
                    continue;
                }
                if (m.getAnnotation(AroundTimeout.class) == null) continue;
                this.aroundTimeout = m;
                this.prepareMethod(m);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.delegate = d;
    }

    private void prepareMethod(final Method m) throws Exception {
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                return null;
            }
        });
    }

    @PostConstruct
    public void init(InvocationContext ctx) throws Throwable {
        this.doCallback(ctx, this.postConstruct);
    }

    @PreDestroy
    public void destroy(InvocationContext ctx) throws Throwable {
        this.doCallback(ctx, this.preDestroy);
    }

    private void doCallback(InvocationContext ctx, Method m) throws Throwable {
        if (this.delegate != null && m != null) {
            try {
                m.invoke(this.delegate, ctx);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        } else {
            ctx.proceed();
        }
    }

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Throwable {
        return this.doAround(ctx, this.aroundInvoke);
    }

    @AroundTimeout
    public Object aroundTimeout(InvocationContext ctx) throws Throwable {
        return this.doAround(ctx, this.aroundTimeout);
    }

    private Object doAround(InvocationContext ctx, Method m) throws Throwable {
        Object returnValue = null;
        if (this.delegate != null && m != null) {
            try {
                returnValue = m.invoke(this.delegate, ctx);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        } else {
            returnValue = ctx.proceed();
        }
        return returnValue;
    }

    public static InterceptorDescriptor createInterceptorDesc() {
        InterceptorDescriptor interceptor = new InterceptorDescriptor();
        Class<SystemInterceptorProxy> interceptorClass = SystemInterceptorProxy.class;
        String interceptorName = interceptorClass.getName();
        interceptor.setInterceptorClass(interceptorClass);
        LifecycleCallbackDescriptor desc = new LifecycleCallbackDescriptor();
        desc.setLifecycleCallbackClass(interceptorName);
        desc.setLifecycleCallbackMethod("init");
        interceptor.addCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT, desc);
        desc = new LifecycleCallbackDescriptor();
        desc.setLifecycleCallbackClass(interceptorName);
        desc.setLifecycleCallbackMethod("destroy");
        interceptor.addCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY, desc);
        desc = new LifecycleCallbackDescriptor();
        desc.setLifecycleCallbackClass(interceptorName);
        desc.setLifecycleCallbackMethod("aroundInvoke");
        interceptor.addAroundInvokeDescriptor(desc);
        desc = new LifecycleCallbackDescriptor();
        desc.setLifecycleCallbackClass(interceptorName);
        desc.setLifecycleCallbackMethod("aroundTimeout");
        interceptor.addAroundTimeoutDescriptor(desc);
        return interceptor;
    }
}

