/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.security.SecurityRoleMapperFactoryGen;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.security.Policy;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;

public class SecurityUtil {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SecurityUtil.class);
    private static final Logger _logger = LogDomains.getLogger(SecurityUtil.class, (String)"javax.enterprise.system.core.security");
    public static final String VENDOR_PRESENT = "com.sun.enterprise.security.provider.jaccvendorpresent";
    private static final boolean vendorPresent = Boolean.getBoolean("com.sun.enterprise.security.provider.jaccvendorpresent");
    private static final String REPOSITORY_HOME_PROP = "com.sun.enterprise.jaccprovider.property.repository";
    public static final String repository = System.getProperty("com.sun.enterprise.jaccprovider.property.repository");

    public static void generatePolicyFile(String name) throws IASSecurityException {
        assert (name != null);
        if (name == null) {
            throw new IASSecurityException("Invalid Module Name");
        }
        try {
            boolean inService = PolicyConfigurationFactory.getPolicyConfigurationFactory().inService(name);
            if (!inService) {
                PolicyConfigurationFactory pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                PolicyConfiguration pc = pcf.getPolicyConfiguration(name, false);
                pc.commit();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("JACC: committed policy for context: " + name);
                }
            }
            Policy.getPolicy().refresh();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IASSecurityException(cnfe);
        }
        catch (PolicyContextException pce) {
            throw new IASSecurityException(pce);
        }
    }

    public static void removePolicy(String name) throws IASSecurityException {
        assert (name != null);
        if (name == null) {
            throw new IASSecurityException("Invalid Module Name");
        }
        try {
            boolean wasInService = PolicyConfigurationFactory.getPolicyConfigurationFactory().inService(name);
            PolicyConfiguration pc = PolicyConfigurationFactory.getPolicyConfigurationFactory().getPolicyConfiguration(name, false);
            pc.delete();
            if (wasInService) {
                Policy.getPolicy().refresh();
            }
        }
        catch (ClassNotFoundException cnfe) {
            String msg = localStrings.getLocalString("enterprise.security.securityutil.classnotfound", "Could not find PolicyConfigurationFactory class. Check javax.security.jacc.PolicyConfigurationFactory.provider property");
            throw new IASSecurityException(msg);
        }
        catch (PolicyContextException pce) {
            throw new IASSecurityException(pce.toString());
        }
    }

    public static boolean linkPolicyFile(String name, String linkName, boolean lastInService) throws IASSecurityException {
        boolean rvalue;
        block8: {
            rvalue = lastInService;
            assert (name != null);
            if (name == null) {
                throw new IASSecurityException("Invalid Module Name");
            }
            try {
                PolicyConfigurationFactory pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                boolean inService = pcf.inService(name);
                if (linkName == null) {
                    rvalue = inService;
                    break block8;
                }
                if (inService == lastInService) {
                    if (!inService) {
                        PolicyConfiguration pc = pcf.getPolicyConfiguration(name, false);
                        PolicyConfiguration linkPc = pcf.getPolicyConfiguration(linkName, false);
                        pc.linkConfiguration(linkPc);
                    }
                    break block8;
                }
                throw new IASSecurityException("Inconsistent Module State");
            }
            catch (ClassNotFoundException cnfe) {
                String msg = localStrings.getLocalString("enterprise.security.securityutil.classnotfound", "Could not find PolicyConfigurationFactory class. Check javax.security.jacc.PolicyConfigurationFactory.provider property");
                throw new IASSecurityException(msg);
            }
            catch (PolicyContextException pce) {
                throw new IASSecurityException(pce.toString());
            }
        }
        return rvalue;
    }

    private static String createUniquePseudoModuleID(EjbBundleDescriptor ejbDesc) {
        String pseudonym;
        boolean unique;
        Application app = ejbDesc.getApplication();
        Set webModules = app.getWebBundleDescriptors();
        Set ejbModules = app.getEjbBundleDescriptors();
        String moduleName = ejbDesc.getUniqueFriendlyId();
        int uniquifier = 0;
        do {
            unique = true;
            pseudonym = moduleName + (uniquifier == 0 ? "_internal" : "_internal_" + uniquifier);
            if (webModules != null) {
                for (WebBundleDescriptor w : webModules) {
                    if (!pseudonym.equals(w.getUniqueFriendlyId())) continue;
                    unique = false;
                    break;
                }
            }
            if (unique && ejbModules != null) {
                for (EjbBundleDescriptor e : ejbModules) {
                    if (!pseudonym.equals(e.getUniqueFriendlyId())) continue;
                    unique = false;
                    break;
                }
            }
            ++uniquifier;
        } while (!unique);
        return app.getRegistrationName() + "/" + pseudonym;
    }

    public static String getContextID(EjbBundleDescriptor ejbBundleDesc) {
        String cid = null;
        if (ejbBundleDesc != null) {
            RootDeploymentDescriptor root = ejbBundleDesc.getModuleDescriptor().getDescriptor();
            cid = root != ejbBundleDesc && root instanceof WebBundleDescriptor ? SecurityUtil.createUniquePseudoModuleID(ejbBundleDesc) : ejbBundleDesc.getApplication().getRegistrationName() + '/' + ejbBundleDesc.getUniqueFriendlyId();
        }
        return cid;
    }

    public static String getContextID(WebBundleDescriptor wbd) {
        String cid = null;
        if (wbd != null) {
            cid = wbd.getApplication().getRegistrationName() + '/' + wbd.getUniqueFriendlyId();
        }
        return cid;
    }

    public static void removeRoleMapper(DeploymentContext dc) {
        OpsParams params = dc.getCommandParameters(OpsParams.class);
        if (params.origin != OpsParams.Origin.undeploy) {
            return;
        }
        String appName = params.name();
        SecurityRoleMapperFactory factory = SecurityRoleMapperFactoryGen.getSecurityRoleMapperFactory();
        if (factory == null) {
            throw new IllegalArgumentException("This application has no role mapper factory defined");
        }
        factory.removeRoleMapper(appName);
    }
}

