/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.enterprise.security.integration.AppClientSSL;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.PrincipalImpl;

public class ClientCertificateLoginModule
implements LoginModule {
    private static Logger _logger = null;
    private static LocalStringManagerImpl localStrings;
    private static KeyStore ks;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String alias;
    private X509Certificate certificate;
    private PrincipalImpl userPrincipal;
    private AppClientSSL ssl;
    private SSLUtils sslUtils;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.sslUtils = Globals.getDefaultHabitat().getComponent(SSLUtils.class);
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        try {
            String[] as = new String[ks.size()];
            String[] aliasString = new String[ks.size()];
            Enumeration<String> aliases = ks.aliases();
            for (int i = 0; i < ks.size(); ++i) {
                aliasString[i] = aliases.nextElement();
                as[i] = ((X509Certificate)ks.getCertificate(aliasString[i])).getSubjectDN().getName();
            }
            Callback[] callbacks = new Callback[]{new ChoiceCallback(localStrings.getLocalString("login.certificate", "Choose from list of certificates: "), as, 0, false)};
            this.callbackHandler.handle(callbacks);
            String[] choices = ((ChoiceCallback)callbacks[0]).getChoices();
            int[] idx = ((ChoiceCallback)callbacks[0]).getSelectedIndexes();
            if (choices == null) {
                // empty if block
            }
            if (idx == null) {
                throw new LoginException("No certificate selected!");
            }
            if (idx[0] == -1) {
                throw new LoginException("Incorrect keystore password");
            }
            if (this.debug && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "\t\t[ClientCertificateLoginModule] user entered certificate: ");
                for (int i = 0; i < idx.length; ++i) {
                    _logger.log(Level.FINE, aliasString[idx[i]]);
                }
            }
            this.alias = aliasString[idx[0]];
            this.certificate = (X509Certificate)ks.getCertificate(this.alias);
            if (this.debug && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "\t\t[ClientCertificateLoginModule] authentication succeeded");
            }
            this.succeeded = true;
            return true;
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information " + "from the user");
        }
        catch (Exception e) {
            throw new LoginException(e.toString());
        }
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new PrincipalImpl(this.alias);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add((Principal)this.userPrincipal);
        }
        if (this.debug && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "\t\t[ClientCertificateLoginModule] added PrincipalImpl to Subject");
        }
        this.ssl = new AppClientSSL();
        this.ssl.setCertNickname(this.alias);
        this.sslUtils.setAppclientSsl(this.ssl);
        String realm = "certificate";
        X509Certificate[] certChain = new X509Certificate[]{this.certificate};
        X509CertificateCredential pc = new X509CertificateCredential(certChain, this.alias, realm);
        if (!this.subject.getPrivateCredentials().contains(pc)) {
            this.subject.getPrivateCredentials().add(pc);
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.alias = null;
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.ssl = null;
        this.sslUtils.setAppclientSsl(this.ssl);
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.alias = null;
        this.userPrincipal = null;
        return true;
    }

    public static void setKeyStore(KeyStore keyStore) {
        ks = keyStore;
    }

    static {
        _logger = LogDomains.getLogger(ClientCertificateLoginModule.class, (String)"javax.enterprise.system.core.security");
        localStrings = new LocalStringManagerImpl(ClientCertificateLoginModule.class);
        ks = null;
    }
}

