/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.beans.Beans;
import java.util.Iterator;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;

public class Label
extends UIOutput
implements NamingContainer {
    public static final String REQUIRED_ID = "_required";
    public static final String REQUIRED_FACET = "required";
    public static final String ERROR_ID = "_error";
    public static final String ERROR_FACET = "error";
    private EditableValueHolder labeledComponent = null;
    private String element = "span";
    private static final boolean DEBUG = false;
    private String _for = null;
    private boolean hideIndicators = false;
    private boolean hideIndicators_set = false;
    private int labelLevel = Integer.MIN_VALUE;
    private boolean labelLevel_set = false;
    private String onClick = null;
    private String onMouseDown = null;
    private String onMouseMove = null;
    private String onMouseOut = null;
    private String onMouseOver = null;
    private String onMouseUp = null;
    private boolean requiredIndicator = false;
    private boolean requiredIndicator_set = false;
    private String style = null;
    private String styleClass = null;
    private String toolTip = null;
    private boolean visible = false;
    private boolean visible_set = false;

    public Label() {
        this.setRendererType("com.sun.webui.jsf.Label");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.Label";
    }

    public void setLabeledComponent(UIComponent comp) {
        if (comp == null) {
            this.labeledComponent = null;
        } else if (comp instanceof EditableValueHolder) {
            this.labeledComponent = (EditableValueHolder)comp;
            if (!Beans.isDesignTime()) {
                this.setFor(comp.getClientId(FacesContext.getCurrentInstance()));
            }
            this.element = "label";
        } else {
            if (LogUtil.infoEnabled(Label.class)) {
                FacesContext context = FacesContext.getCurrentInstance();
                LogUtil.info(Label.class, "Label.invalidFor", new Object[]{this.getId(), context.getViewRoot().getViewId(), comp.getId()});
            }
            this.labeledComponent = null;
            this.element = "label";
        }
    }

    public EditableValueHolder getLabeledComponent() {
        if (this.labeledComponent != null) {
            return this.labeledComponent;
        }
        String id = this.getFor();
        if (id == null) {
            this.setLabeledComponent(this.findLabeledChild());
        } else {
            if (id.indexOf(":") > -1 && !id.startsWith(":")) {
                id = ":" + id;
            }
            try {
                UIComponent parent = this.getParent();
                this.setLabeledComponent(parent.findComponent(id));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.element = "label";
        }
        return this.labeledComponent;
    }

    public String getLabeledComponentId(FacesContext context) {
        String id = null;
        if (this.labeledComponent != null) {
            if (this.labeledComponent instanceof ComplexComponent) {
                ComplexComponent compComp = (ComplexComponent)this.labeledComponent;
                id = compComp.getPrimaryElementID(context);
            } else {
                UIComponent comp = (UIComponent)this.labeledComponent;
                id = comp.getClientId(context);
            }
        } else {
            UIComponent comp;
            id = this.getFor();
            if (id != null && id.indexOf(":") == -1 && (comp = this.getParent()) instanceof NamingContainer) {
                id = comp.getClientId(context) + ":" + id;
            }
        }
        return id;
    }

    private UIComponent findLabeledChild() {
        List kids = this.getChildren();
        for (int i = 0; i < kids.size(); ++i) {
            Object kid = kids.get(i);
            if (!(kid instanceof EditableValueHolder)) continue;
            return (UIComponent)kid;
        }
        return null;
    }

    public UIComponent getRequiredIcon(Theme theme, FacesContext context) {
        UIComponent comp = this.getFacet(REQUIRED_FACET);
        if (comp != null) {
            return comp;
        }
        Icon icon = ThemeUtilities.getIcon(theme, "LABEL_REQUIRED_ICON");
        icon.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, REQUIRED_FACET));
        icon.setParent((UIComponent)this);
        icon.setBorder(0);
        return icon;
    }

    public UIComponent getErrorIcon(Theme theme, FacesContext context, boolean valid) {
        UIComponent comp = this.getFacet(ERROR_FACET);
        if (comp != null) {
            return comp;
        }
        Icon icon = ThemeUtilities.getIcon(theme, "LABEL_INVALID_ICON");
        icon.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, ERROR_FACET));
        icon.setParent((UIComponent)this);
        icon.setBorder(0);
        if (valid) {
            icon.setIcon("DOT");
            icon.setAlt("");
        } else if (this.labeledComponent != null) {
            String labeledCompID = ((UIComponent)this.labeledComponent).getClientId(context);
            Iterator messages = context.getMessages(labeledCompID);
            FacesMessage fm = null;
            StringBuffer msgBuffer = new StringBuffer(200);
            while (messages.hasNext()) {
                fm = (FacesMessage)messages.next();
                msgBuffer.append(fm.getDetail());
                msgBuffer.append(" ");
            }
            icon.setToolTip(msgBuffer.toString());
        }
        return icon;
    }

    public String getElement() {
        return this.element;
    }

    private void log(String s) {
        System.out.println(((Object)((Object)this)).getClass().getName() + "::" + s);
    }

    public int getLabelLevel() {
        int level = this._getLabelLevel();
        if (level < 1 || level > 3) {
            level = 2;
            this.setLabelLevel(level);
        }
        return level;
    }

    public void setConverter(Converter converter) {
        super.setConverter(converter);
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    public ValueExpression getValueExpression(String name) {
        if (name.equals("text")) {
            return super.getValueExpression("value");
        }
        return super.getValueExpression(name);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (name.equals("text")) {
            super.setValueExpression("value", binding);
            return;
        }
        super.setValueExpression(name, binding);
    }

    public Object getValue() {
        return super.getValue();
    }

    public String getFor() {
        if (this._for != null) {
            return this._for;
        }
        ValueExpression _vb = this.getValueExpression("for");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setFor(String _for) {
        this._for = _for;
    }

    public boolean isHideIndicators() {
        if (this.hideIndicators_set) {
            return this.hideIndicators;
        }
        ValueExpression _vb = this.getValueExpression("hideIndicators");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setHideIndicators(boolean hideIndicators) {
        this.hideIndicators = hideIndicators;
        this.hideIndicators_set = true;
    }

    public int _getLabelLevel() {
        if (this.labelLevel_set) {
            return this.labelLevel;
        }
        ValueExpression _vb = this.getValueExpression("labelLevel");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return Integer.MIN_VALUE;
            }
            return (Integer)_result;
        }
        return 2;
    }

    public void setLabelLevel(int labelLevel) {
        this.labelLevel = labelLevel;
        this.labelLevel_set = true;
    }

    public String getOnClick() {
        if (this.onClick != null) {
            return this.onClick;
        }
        ValueExpression _vb = this.getValueExpression("onClick");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    public String getOnMouseDown() {
        if (this.onMouseDown != null) {
            return this.onMouseDown;
        }
        ValueExpression _vb = this.getValueExpression("onMouseDown");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseDown(String onMouseDown) {
        this.onMouseDown = onMouseDown;
    }

    public String getOnMouseMove() {
        if (this.onMouseMove != null) {
            return this.onMouseMove;
        }
        ValueExpression _vb = this.getValueExpression("onMouseMove");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseMove(String onMouseMove) {
        this.onMouseMove = onMouseMove;
    }

    public String getOnMouseOut() {
        if (this.onMouseOut != null) {
            return this.onMouseOut;
        }
        ValueExpression _vb = this.getValueExpression("onMouseOut");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOut(String onMouseOut) {
        this.onMouseOut = onMouseOut;
    }

    public String getOnMouseOver() {
        if (this.onMouseOver != null) {
            return this.onMouseOver;
        }
        ValueExpression _vb = this.getValueExpression("onMouseOver");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseOver(String onMouseOver) {
        this.onMouseOver = onMouseOver;
    }

    public String getOnMouseUp() {
        if (this.onMouseUp != null) {
            return this.onMouseUp;
        }
        ValueExpression _vb = this.getValueExpression("onMouseUp");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setOnMouseUp(String onMouseUp) {
        this.onMouseUp = onMouseUp;
    }

    public boolean isRequiredIndicator() {
        if (this.requiredIndicator_set) {
            return this.requiredIndicator;
        }
        ValueExpression _vb = this.getValueExpression("requiredIndicator");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return false;
    }

    public void setRequiredIndicator(boolean requiredIndicator) {
        this.requiredIndicator = requiredIndicator;
        this.requiredIndicator_set = true;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression _vb = this.getValueExpression("style");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression _vb = this.getValueExpression("styleClass");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public Object getText() {
        return this.getValue();
    }

    public void setText(Object text) {
        this.setValue(text);
    }

    public String getToolTip() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        ValueExpression _vb = this.getValueExpression("toolTip");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setToolTip(String toolTip) {
        this.toolTip = toolTip;
    }

    public boolean isVisible() {
        if (this.visible_set) {
            return this.visible;
        }
        ValueExpression _vb = this.getValueExpression("visible");
        if (_vb != null) {
            Object _result = _vb.getValue(this.getFacesContext().getELContext());
            if (_result == null) {
                return false;
            }
            return (Boolean)_result;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.visible_set = true;
    }

    public void restoreState(FacesContext _context, Object _state) {
        Object[] _values = (Object[])_state;
        super.restoreState(_context, _values[0]);
        this._for = (String)_values[1];
        this.hideIndicators = (Boolean)_values[2];
        this.hideIndicators_set = (Boolean)_values[3];
        this.labelLevel = (Integer)_values[4];
        this.labelLevel_set = (Boolean)_values[5];
        this.onClick = (String)_values[6];
        this.onMouseDown = (String)_values[7];
        this.onMouseMove = (String)_values[8];
        this.onMouseOut = (String)_values[9];
        this.onMouseOver = (String)_values[10];
        this.onMouseUp = (String)_values[11];
        this.requiredIndicator = (Boolean)_values[12];
        this.requiredIndicator_set = (Boolean)_values[13];
        this.style = (String)_values[14];
        this.styleClass = (String)_values[15];
        this.toolTip = (String)_values[16];
        this.visible = (Boolean)_values[17];
        this.visible_set = (Boolean)_values[18];
    }

    public Object saveState(FacesContext _context) {
        Object[] _values = new Object[]{super.saveState(_context), this._for, this.hideIndicators ? Boolean.TRUE : Boolean.FALSE, this.hideIndicators_set ? Boolean.TRUE : Boolean.FALSE, new Integer(this.labelLevel), this.labelLevel_set ? Boolean.TRUE : Boolean.FALSE, this.onClick, this.onMouseDown, this.onMouseMove, this.onMouseOut, this.onMouseOver, this.onMouseUp, this.requiredIndicator ? Boolean.TRUE : Boolean.FALSE, this.requiredIndicator_set ? Boolean.TRUE : Boolean.FALSE, this.style, this.styleClass, this.toolTip, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visible_set ? Boolean.TRUE : Boolean.FALSE};
        return _values;
    }
}

