/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.ClientSniffer;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import com.sun.webui.theme.ThemeImage;
import java.beans.Beans;
import java.io.IOException;
import java.text.MessageFormat;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ImageRenderer
extends AbstractRenderer {
    private static final String[] integerAttributes = new String[]{"border", "hspace", "vspace"};
    private static final String[] stringAttributes = new String[]{"align", "onClick", "onDblClick", "onMouseDown", "onMouseMove", "onMouseOut", "onMouseOver"};

    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        ImageComponent image = (ImageComponent)component;
        writer.startElement("img", (UIComponent)image);
    }

    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        String longDesc;
        ImageComponent image = (ImageComponent)component;
        String clientId = image.getClientId(context);
        if (clientId != null) {
            writer.writeAttribute("id", (Object)clientId, null);
        }
        String url = image.getUrl();
        String icon = image.getIcon();
        String alt = image.getAlt();
        int height = image.getHeight();
        int width = image.getWidth();
        Theme theme = ThemeUtilities.getTheme(context);
        if (image instanceof Icon || icon != null && url == null) {
            ThemeImage themeImage = theme.getImage(icon);
            url = themeImage.getPath();
            int dim = themeImage.getHeight();
            if (height < 0 && dim >= 0) {
                height = dim;
            }
            dim = themeImage.getWidth();
            if (width < 0 && dim >= 0) {
                width = dim;
            }
            String iconAlt = themeImage.getAlt();
            if (alt == null) {
                alt = iconAlt;
            }
        } else if (url == null) {
            if (!Beans.isDesignTime() && LogUtil.warningEnabled(ImageRenderer.class)) {
                LogUtil.warning(ImageRenderer.class, "  URL  was not specified and generally should be");
            }
        } else {
            url = context.getApplication().getViewHandler().getResourceURL(context, url);
        }
        url = url != null && url.trim().length() != 0 ? context.getExternalContext().encodeResourceURL(url) : "";
        String style = image.getStyle();
        StringBuffer errorMsg = new StringBuffer("Image's {0} was not").append(" specified. Using a generic").append(" default value of {1}");
        MessageFormat mf = new MessageFormat(errorMsg.toString());
        if (this.isPngAndIE(context, url)) {
            String imgHeight = null;
            String imgWidth = null;
            if (width >= 0) {
                imgWidth = Integer.toString(width);
            } else {
                imgWidth = theme.getMessage("Image.defaultWidth");
                if (LogUtil.fineEnabled(ImageRenderer.class)) {
                    LogUtil.fine(ImageRenderer.class, mf.format(new String[]{"width", imgWidth}));
                }
            }
            if (height >= 0) {
                imgHeight = Integer.toString(height);
            } else {
                imgHeight = theme.getMessage("Image.defaultHeight");
                if (LogUtil.fineEnabled(ImageRenderer.class)) {
                    LogUtil.fine(ImageRenderer.class, mf.format(new String[]{"height", imgHeight}));
                }
            }
            String IEStyle = theme.getMessage("Image.IEPngCSSStyleQuirk", new String[]{imgWidth, imgHeight, url});
            url = theme.getImagePath("DOT");
            style = style == null ? IEStyle : IEStyle + style;
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)image, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        RenderingUtilities.renderURLAttribute(context, writer, (UIComponent)image, "src", url, "url");
        if (alt != null) {
            writer.writeAttribute("alt", (Object)alt, null);
        } else {
            writer.writeAttribute("alt", (Object)"", null);
        }
        String toolTip = image.getToolTip();
        if (toolTip != null) {
            writer.writeAttribute("title", (Object)toolTip, null);
        }
        if ((longDesc = image.getLongDesc()) != null) {
            writer.writeAttribute("longdesc", (Object)longDesc, null);
        }
        if (height >= 0) {
            writer.writeAttribute("height", (Object)Integer.toString(height), null);
        }
        if (width >= 0) {
            writer.writeAttribute("width", (Object)Integer.toString(width), null);
        }
        this.addIntegerAttributes(context, component, writer, integerAttributes);
        ImageRenderer.addStringAttributes(context, component, writer, stringAttributes);
    }

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        ImageComponent image = (ImageComponent)component;
        writer.endElement("img");
    }

    private boolean isPngAndIE(FacesContext context, String url) {
        ClientSniffer cs = ClientSniffer.getInstance(context);
        if (url.indexOf("sessionid") != -1) {
            if (url.substring(0, url.indexOf(59)).endsWith(".png") && cs.isIe6up()) {
                return false;
            }
            if (url.substring(0, url.indexOf(59)).endsWith(".png") && cs.isIe5up()) {
                return true;
            }
        } else if (url.endsWith(".png")) {
            if (cs.isIe6up()) {
                return false;
            }
            if (cs.isIe5up()) {
                return true;
            }
        }
        return false;
    }
}

