/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;

class LogDBHelper {
    String resName = "jdbc/TxnDS";
    DataSource ds = null;
    Method getNonTxConnectionMethod = null;
    static final String insertStatement = System.getProperty("com.sun.jts.dblogging.insertquery", "insert into  txn_log_table values ( ? , ? , ? )");
    static final String deleteStatement = System.getProperty("com.sun.jts.dblogging.deletequery", "delete from txn_log_table where localtid = ? and servername = ? ");
    static final String selectStatement = System.getProperty("com.sun.jts.dblogging.selectquery", "select * from txn_log_table where servername = ? ");
    static Logger _logger = LogDomains.getLogger(LogDBHelper.class, (String)"javax.enterprise.system.core.transaction");
    static LogDBHelper _instance = new LogDBHelper();

    static LogDBHelper getInstance() {
        return _instance;
    }

    LogDBHelper() {
        if (Configuration.getPropertyValue("com.sun.jts.logResource") != null) {
            this.resName = Configuration.getPropertyValue("com.sun.jts.logResource");
        }
        try {
            InitialContext ctx = new InitialContext();
            this.ds = (DataSource)ctx.lookup(this.resName);
            Class<?> cls = this.ds.getClass();
            this.getNonTxConnectionMethod = cls.getMethod("getNonTxConnection", null);
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "jts.unconfigured_db_log_resource", this.resName);
            _logger.log(Level.SEVERE, "", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addRecord(long localTID, byte[] data) {
        if (this.ds != null) {
            Connection conn = null;
            Statement prepStmt1 = null;
            try {
                conn = this.ds.getConnection();
                prepStmt1 = conn.prepareStatement(insertStatement);
                prepStmt1.setLong(1, localTID);
                prepStmt1.setString(2, Configuration.getServerName());
                prepStmt1.setBytes(3, data);
                prepStmt1.executeUpdate();
                boolean bl = true;
                return bl;
            }
            catch (Throwable ex) {
                _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (prepStmt1 != null) {
                        prepStmt1.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ex1) {
                    _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex1);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteRecord(long localTID) {
        if (this.ds != null) {
            Connection conn = null;
            Statement prepStmt1 = null;
            try {
                conn = (Connection)this.getNonTxConnectionMethod.invoke((Object)this.ds, null);
                prepStmt1 = conn.prepareStatement(deleteStatement);
                prepStmt1.setLong(1, localTID);
                prepStmt1.setString(2, Configuration.getServerName());
                prepStmt1.executeUpdate();
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (prepStmt1 != null) {
                        prepStmt1.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ex1) {
                    _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex1);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getGlobalTIDMap() {
        HashMap<GlobalTID, Long> gtidMap = new HashMap<GlobalTID, Long>();
        if (this.ds != null) {
            Connection conn = null;
            PreparedStatement prepStmt1 = null;
            ResultSet rs = null;
            try {
                conn = this.ds.getConnection();
                prepStmt1 = conn.prepareStatement(selectStatement);
                prepStmt1.setString(1, Configuration.getServerName());
                rs = prepStmt1.executeQuery();
                while (rs.next()) {
                    Long localTID = new Long(rs.getLong(1));
                    byte[] gtridbytes = rs.getBytes(3);
                    gtidMap.put(GlobalTID.fromTIDBytes(rs.getBytes(3)), localTID);
                }
            }
            catch (Exception ex) {
                _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (prepStmt1 != null) {
                        prepStmt1.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception ex1) {
                    _logger.log(Level.SEVERE, "jts.exception_in_db_log_resource", ex1);
                }
            }
        }
        return gtidMap;
    }
}

