/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.jruby.rack;

import com.sun.grizzly.jruby.rack.Messages;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.scripting.jruby.common.config.JRubyConfig;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassCache;

public class JRubyRuntime {
    public final Ruby ruby;
    private final Logger logger = Logger.getLogger(JRubyRuntime.class.getName());

    public JRubyRuntime(JRubyConfig config) {
        long startTime = System.currentTimeMillis();
        RubyInstanceConfig iconfig = new RubyInstanceConfig();
        ArrayList<String> libs = new ArrayList<String>();
        libs.add("META-INF/jruby.home/lib/ruby/site_ruby/1.8");
        try {
            String binjruby = RubyInstanceConfig.class.getResource("/META-INF/jruby.home/bin/jruby").getFile();
            iconfig.setJRubyHome(binjruby.substring(0, binjruby.length() - 10));
        }
        catch (Exception e) {
            iconfig.setJRubyHome(config.jrubyHome());
        }
        ClassCache cache = new ClassCache(JRubyRuntime.class.getClassLoader());
        iconfig.setLoader(JRubyRuntime.class.getClassLoader());
        if (System.getProperty("jruby.debug") != null) {
            iconfig.processArguments(new String[]{"-d"});
        }
        iconfig.setClassCache(cache);
        this.ruby = JavaEmbedUtils.initialize(libs, (RubyInstanceConfig)iconfig);
        this.ruby.defineReadonlyVariable("$glassfish_config", JavaEmbedUtils.javaToRuby((Ruby)this.ruby, (Object)config));
        IRubyObject loggerObj = JavaEmbedUtils.javaToRuby((Ruby)this.ruby, (Object)this.logger);
        this.ruby.defineReadonlyVariable("$logger", loggerObj);
        String logLevel = System.getProperty("glassfish.log-level");
        if (logLevel != null) {
            if (logLevel.equalsIgnoreCase("OFF")) {
                logLevel = "FATAL";
            } else if (logLevel.equalsIgnoreCase("SEVERE")) {
                logLevel = "ERROR";
            } else if (logLevel.equalsIgnoreCase("WARNING")) {
                logLevel = "WARN";
            } else if (logLevel.equalsIgnoreCase("INFO") || logLevel.equalsIgnoreCase("FINE") || logLevel.equalsIgnoreCase("FINER") || logLevel.equalsIgnoreCase("FINEST")) {
                logLevel = "DEBUG";
            } else if (logLevel.equalsIgnoreCase("CONFIG")) {
                logLevel = "INFO";
            }
            IRubyObject loggerLevelObj = JavaEmbedUtils.javaToRuby((Ruby)this.ruby, (Object)logLevel);
            this.ruby.defineReadonlyVariable("$glassfish_log_level", loggerLevelObj);
        }
        this.logger.log(Level.INFO, Messages.format("newinstance.creation.time", "JRuby runtime", System.currentTimeMillis() - startTime));
    }

    private String getEffectiveLogLevel() {
        Level myLevel = this.logger.getLevel();
        Logger pLogger = this.logger;
        while (myLevel == null) {
            pLogger = pLogger.getParent();
            myLevel = pLogger.getLevel();
        }
        return myLevel.getName();
    }
}

