/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.eclipse.persistence.jpa.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarInputStreamURLArchive
implements Archive {
    private URL url;
    private List<String> entries = new ArrayList<String>();
    private Logger logger;

    public JarInputStreamURLArchive(URL url) throws IOException {
        this(url, Logger.global);
    }

    public JarInputStreamURLArchive(URL url, Logger logger) throws IOException {
        logger.entering("JarInputStreamURLArchive", "JarInputStreamURLArchive", new Object[]{url});
        this.logger = logger;
        this.url = url;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        JarInputStream jis = new JarInputStream(new BufferedInputStream(this.url.openStream()));
        try {
            ZipEntry ze;
            while ((ze = jis.getNextEntry()) != null) {
                if (ze.isDirectory()) continue;
                this.entries.add(ze.getName());
            }
        }
        finally {
            jis.close();
        }
    }

    @Override
    public Iterator<String> getEntries() {
        return this.entries.iterator();
    }

    @Override
    public InputStream getEntry(String entryPath) throws IOException {
        ZipEntry ze;
        if (!this.entries.contains(entryPath)) {
            return null;
        }
        JarInputStream jis = new JarInputStream(new BufferedInputStream(this.url.openStream()));
        while ((ze = jis.getNextEntry()) != null) {
            if (!ze.getName().equals(entryPath)) continue;
            return jis;
        }
        assert (false);
        return null;
    }

    @Override
    public URL getEntryAsURL(String entryPath) throws IOException {
        URL result;
        result = this.entries.contains(entryPath) ? (result = new URL("jar:" + this.url + "!/" + entryPath)) : null;
        return result;
    }

    @Override
    public URL getRootURL() {
        return this.url;
    }

    @Override
    public void close() {
    }
}

