/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageUtil {
    public static final Locale US = new Locale("en", "US");
    private String resourceBundleName;

    public MessageUtil(String string) {
        this.resourceBundleName = string;
    }

    public String getTextMessage(String string) {
        return this.getCompleteMessage(string, null);
    }

    public String getTextMessage(String string, Object object) {
        return this.getCompleteMessage(string, new Object[]{object});
    }

    public String getTextMessage(String string, Object object, Object object2) {
        return this.getCompleteMessage(string, new Object[]{object, object2});
    }

    public String getTextMessage(String string, Object object, Object object2, Object object3) {
        return this.getCompleteMessage(string, new Object[]{object, object2, object3});
    }

    public String getTextMessage(String string, Object object, Object object2, Object object3, Object object4) {
        return this.getCompleteMessage(string, new Object[]{object, object2, object3, object4});
    }

    public String getCompleteMessage(String string, Object[] objectArray) {
        return MessageUtil.getCompleteMessage(string, this.resourceBundleName, objectArray);
    }

    public static String getCompleteMessage(Locale locale, String string, String string2, Object[] objectArray, boolean bl) throws MissingResourceException {
        try {
            return MessageUtil.formatMessage(ResourceBundle.getBundle(string, locale), string2, objectArray, false);
        }
        catch (MissingResourceException missingResourceException) {
            return MessageUtil.formatMessage(ResourceBundle.getBundle(string, US), string2, objectArray, bl);
        }
    }

    public static String getCompleteMessage(String string, String string2, Object[] objectArray) throws MissingResourceException {
        return MessageUtil.getCompleteMessage(Locale.getDefault(), string2, string, objectArray, true);
    }

    public static String formatMessage(ResourceBundle resourceBundle, String string, Object[] objectArray, boolean bl) {
        block9: {
            String string2 = null;
            Object var5_5 = null;
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            if (resourceBundle != null) {
                try {
                    string2 = resourceBundle.getString(string);
                    try {
                        return MessageFormat.format(string2, objectArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!bl) {
                            throw illegalArgumentException;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        if (!bl) {
                            throw nullPointerException;
                        }
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    if (bl) break block9;
                    throw missingResourceException;
                }
            }
        }
        return MessageUtil.composeDefaultMessage("UNKNOWN MESSAGE, id " + string, objectArray);
    }

    private static int countParams(String string) {
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                bl = true;
            }
            if (c != '}' || !bl) continue;
            ++n;
            bl = false;
        }
        return n;
    }

    public static String composeDefaultMessage(String string, Object[] objectArray) {
        if (string == null) {
            string = "UNKNOWN";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (objectArray == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append(" : ");
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('[');
            stringBuffer.append(i);
            stringBuffer.append("] ");
            if (objectArray[i] == null) {
                stringBuffer.append("null");
                continue;
            }
            stringBuffer.append(objectArray[i].toString());
        }
        return stringBuffer.toString();
    }
}

