/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.web;

import com.sun.enterprise.deployment.MultipartConfigDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MultipartConfigNode
extends DeploymentDescriptorNode {
    private MultipartConfigDescriptor descriptor;

    public Object getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (MultipartConfigDescriptor)super.getDescriptor();
        }
        return this.descriptor;
    }

    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("location", "setLocation");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("max-file-size".equals(element.getQName())) {
            this.descriptor.setMaxFileSize(Long.valueOf(value));
        } else if ("max-request-size".equals(element.getQName())) {
            this.descriptor.setMaxRequestSize(Long.valueOf(value));
        } else if ("file-size-threshold".equals(element.getQName())) {
            this.descriptor.setFileSizeThreshold(Integer.valueOf(value));
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, MultipartConfigDescriptor descriptor) {
        Element myNode = MultipartConfigNode.appendChild(parent, nodeName);
        MultipartConfigNode.appendTextChild((Node)myNode, "location", descriptor.getLocation());
        if (descriptor.getMaxFileSize() != null) {
            MultipartConfigNode.appendTextChild((Node)myNode, "max-file-size", descriptor.getMaxFileSize().toString());
        }
        if (descriptor.getMaxRequestSize() != null) {
            MultipartConfigNode.appendTextChild((Node)myNode, "max-request-size", descriptor.getMaxRequestSize().toString());
        }
        if (descriptor.getFileSizeThreshold() != null) {
            MultipartConfigNode.appendTextChild((Node)myNode, "file-size-threshold", descriptor.getFileSizeThreshold().toString());
        }
        return myNode;
    }
}

