/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.glassfish.admingui.common.util.V3AMX;

public class HtmlAdaptorHandler {
    private static boolean _bHtmlAdaptorServerRegistered = false;

    public static void initHtmlAdaptor(HandlerContext handlerCtx) {
        if (!_bHtmlAdaptorServerRegistered) {
            if (System.getProperty("html.adaptor.port") == null) {
                _bHtmlAdaptorServerRegistered = true;
            }
            HtmlAdaptorHandler.registerHTMLAdaptor(V3AMX.getInstance().getMbeanServerConnection());
        }
    }

    private static void registerHTMLAdaptor(MBeanServerConnection mbsc) {
        try {
            int port = Integer.parseInt(System.getProperty("html.adaptor.port", "4444"));
            Class<?> cl = Class.forName("com.sun.jdmk.comm.HtmlAdaptorServer");
            Constructor<?> contr = cl.getConstructor(Integer.TYPE);
            Object adaptor = contr.newInstance(port);
            Method method = cl.getMethod("start", new Class[0]);
            ObjectName htmlAdaptorObjectName = new ObjectName("Adaptor:name=html,port=" + port);
            MBeanServer mbs = (MBeanServer)mbsc;
            mbs.registerMBean(adaptor, htmlAdaptorObjectName);
            method.invoke(adaptor, new Object[0]);
            _bHtmlAdaptorServerRegistered = true;
        }
        catch (Exception e) {
            System.out.println("Warning !! cannot create HTML Adapter. Ensure that you have jmxtools.jar in __adnmingui/WEB-INF/lib directory");
            System.out.println(e.getMessage());
        }
    }
}

