/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.descriptors;

import com.sun.jsftemplating.layout.LayoutDefinitionManager;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.layout.event.AfterLoopEvent;
import com.sun.jsftemplating.layout.event.BeforeLoopEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutForEach
extends LayoutComponent {
    private static final long serialVersionUID = 1L;
    public static final String AFTER_LOOP = "afterLoop";
    public static final String BEFORE_LOOP = "beforeLoop";
    private boolean _doubleEval = false;

    public LayoutForEach(LayoutElement parent, String listBinding, String key) {
        super(parent, null, LayoutDefinitionManager.getGlobalComponentType(null, "foreach"));
        if (listBinding == null || listBinding.equals("")) {
            throw new IllegalArgumentException("'listBinding' is required!");
        }
        if (key == null || key.equals("")) {
            throw new IllegalArgumentException("'key' is required!");
        }
        this.addOption("list", listBinding);
        this.addOption("key", key);
        if (listBinding.equals("$property{list}")) {
            this._doubleEval = true;
        }
    }

    @Override
    public boolean encodeThis(FacesContext context, UIComponent component) {
        return true;
    }

    protected List<Object> getList(FacesContext context, UIComponent comp) {
        Object value = this.resolveValue(context, comp, this.getOption("list"));
        if (this._doubleEval) {
            value = this.resolveValue(context, comp, value);
        }
        if (value == null) {
            throw new NullPointerException("List not found via expression: '" + this.getOption("list") + "'.");
        }
        if (!(value instanceof List)) {
            throw new IllegalArgumentException("Expression '" + this.getOption("list") + "' did not resolve to a List! Found: '" + value.getClass().getName() + "'");
        }
        return (List)value;
    }

    private void setCurrentForEachValue(FacesContext context, Object value, int index, String key) {
        Map map = context.getExternalContext().getRequestMap();
        map.put(key, value);
        map.put(key + "-index", "" + index);
    }

    @Override
    public void encode(FacesContext context, UIComponent component) throws IOException {
        this.dispatchHandlers(context, BEFORE_LOOP, new BeforeLoopEvent(component));
        String key = this.resolveValue(context, component, this.getOption("key")).toString();
        List<Object> list = this.getList(context, component);
        context.getExternalContext().getRequestMap().put(key + "-size", list.size());
        Iterator<Object> it = list.iterator();
        int index = 1;
        while (it.hasNext()) {
            this.setCurrentForEachValue(context, it.next(), index, key);
            super.encode(context, component);
            ++index;
        }
        this.dispatchHandlers(context, AFTER_LOOP, new AfterLoopEvent(component));
    }

    @Override
    public List<Handler> getHandlers(String type, UIComponent comp) {
        return super.getHandlers(type, null);
    }
}

